/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductCountTransactionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductCountTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductProduceTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InventoryProductChargeCountTable
extends Table2 {
    private Node<List<ProductCountTransactionComplete>> node = INodeCreator.getDefaultImpl().getNode4DTO(new ArrayList(), false, false);

    public InventoryProductChargeCountTable(final InnerPopUp2 popUp) {
        super(true, Words.ADD);
        this.setRequestFocusOnAdd(true);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                InventoryProductChargeCountTable.this.revalidate();
                popUp.createFocusCycle();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                UnitComplete unit = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getPieceUnit();
                ProductCountTransactionComplete count = new ProductCountTransactionComplete();
                count.setClientOId(Long.valueOf(ADTO.getNextId()));
                count.setQuantity(new StoreQuantityComplete(Long.valueOf(0L), unit));
                InventoryProductChargeCountTable.this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)count, true, false), 0L);
                popUp.createFocusCycle();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columns.add(new TableColumnInfo(Words.COUNT, null, null, null, "", 120));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.getModel().setNode(this.node);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<ProductComplete> productSearch;
        private InputComboBox2 count;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.productSearch = SearchTextField2Factory.getProductSearchField(true, m.getNode().getChildNamed(ProductCountTransactionComplete_.product));
            this.productSearch.addSearchTextFieldListener(new SearchTextField2Listener(){

                @Override
                public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
                    ProductComplete product = (ProductComplete)n.getValue();
                    if (product != null) {
                        UnitComplete unit = product.getCurrentVariant().getLabelUnit();
                        if (unit == null) {
                            unit = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getPieceUnit();
                        }
                        TableRowImpl.this.model.getNode().getChildNamed(new DtoField[]{ProductProduceTransactionComplete_.quantity, StoreQuantityComplete_.unit}).setValue((Object)unit, 0L);
                        TableRowImpl.this.count.setSelectedUnit(unit);
                        List units = UnitConversionToolkit.getAllUnits((UnitComplete)unit);
                        TableRowImpl.this.count.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                        TableRowImpl.this.count.getUnitNode().setValue((Object)unit, 0L);
                    }
                }
            });
            this.count = new InputComboBox2(m.getNode().getChildNamed(ProductCountTransactionComplete_.quantity).getChildNamed(StoreQuantityComplete_.amount), m.getNode().getChildNamed(ProductCountTransactionComplete_.quantity).getChildNamed(StoreQuantityComplete_.unit), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
            this.initProductUnits(m);
            this.delete = new DeleteButton();
            this.delete.addButtonListener((source, x, y) -> m.getNode().getParent().removeChild(m.getNode(), 0L));
            this.setLayout(new Layout());
            this.add(this.productSearch);
            this.add(this.count);
            this.add(this.delete);
        }

        @Override
        public void requestFocusInWindowNow() {
            this.productSearch.requestFocusInWindowNow();
        }

        private void initProductUnits(Table2RowModel m) {
            this.count.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(Collections.singletonList((UnitComplete)m.getNode().getChildNamed(new DtoField[]{ProductCountTransactionComplete_.quantity, QuantityComplete_.unit}).getValue())));
            this.count.setSelectedUnit((UnitComplete)m.getNode().getChildNamed(new DtoField[]{ProductCountTransactionComplete_.quantity, StoreQuantityComplete_.unit}).getValue());
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.productSearch.kill();
            this.count.kill();
            this.delete.kill();
            this.productSearch = null;
            this.count = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.productSearch);
            CheckedListAdder.addToList(focusList, this.count);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.productSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.productSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.productSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.productSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX += w);
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

