/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryProductCountComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryProductCountComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class InventoryProductCountTable
extends Table2 {
    private Node<List<InventoryProductCountComplete>> node = INodeCreator.getDefaultImpl().getNode4DTO(new ArrayList(), false, false);

    public InventoryProductCountTable(final InnerPopUp2 popUp) {
        super(true, Words.ADD);
        this.setRequestFocusOnAdd(true);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                InventoryProductCountTable.this.revalidate();
                popUp.createFocusCycle();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                InventoryProductCountComplete count = new InventoryProductCountComplete();
                count.setClientOId(Long.valueOf(ADTO.getNextId()));
                count.setCounted(Integer.valueOf(0));
                InventoryProductCountTable.this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)count, true, false), 0L);
                popUp.createFocusCycle();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columns.add(new TableColumnInfo(Words.COUNT, null, null, null, "", 120));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.getModel().setNode(this.node);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<ProductComplete> productSearch;
        private TextField count;
        private TextLabel unit;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.productSearch = SearchTextField2Factory.getProductSearchField(true, m.getNode().getChildNamed(InventoryProductCountComplete_.product));
            this.count = new TextField(m.getNode().getChildNamed(InventoryProductCountComplete_.counted), TextFieldType.INT);
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            this.unit = new TextLabel(settings.getPieceUnit().getShortName());
            this.delete = new DeleteButton();
            this.delete.addButtonListener((source, x, y) -> m.getNode().getParent().removeChild(m.getNode(), 0L));
            this.setLayout(new Layout());
            this.add(this.productSearch);
            this.add(this.count);
            this.add(this.unit);
            this.add(this.delete);
        }

        @Override
        public void requestFocusInWindowNow() {
            this.productSearch.requestFocusInWindowNow();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.productSearch.kill();
            this.count.kill();
            this.delete.kill();
            this.unit.kill();
            this.productSearch = null;
            this.count = null;
            this.delete = null;
            this.unit = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.productSearch);
            CheckedListAdder.addToList(focusList, this.count);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.productSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.productSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.productSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.productSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize((int)((double)w - ((double)(3 * TableRowImpl.this.getCellPadding()) + TableRowImpl.this.unit.getPreferredSize().getWidth())), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                TableRowImpl.this.unit.setLocation(TableRowImpl.this.count.getX() + TableRowImpl.this.count.getWidth() + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.unit.setSize(TableRowImpl.this.unit.getPreferredSize());
                TableRowImpl.this.setControlsX(currentX += w);
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

