/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDImageChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.variant.ArticleKanbanConfigurationVariantAdd;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.kanban.ArticleKanbanConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.supply.kanban.ArticleKanbanConfigurationComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class KanbanConfigurationTable
extends Table2 {
    private Node storeUnitSelectionNode;
    private final Node<BasicArticleComplete> article;

    public KanbanConfigurationTable(RDProvider provider, Node storeUnitSelectionNode, final Node<BasicArticleComplete> article) {
        super(true, Words.ADD);
        this.setProvider(provider);
        this.setUseWriteAccessRight(true);
        this.storeUnitSelectionNode = storeUnitSelectionNode;
        this.article = article;
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                KanbanConfigurationTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                if (KanbanConfigurationTable.this.getRowCount() == 0) {
                    ArticleKanbanConfigurationComplete config = new ArticleKanbanConfigurationComplete();
                    config.setClientOId(Long.valueOf(ADTO.getNextId()));
                    config.setValidity(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
                    config.setAverageDailyUsageQuantity(new StoreQuantityComplete(Long.valueOf(1L), (UnitComplete)article.getChildNamed(BasicArticleComplete_.mainStoreUnit).getValue()));
                    config.setQuantityPerCard(new StoreQuantityComplete(Long.valueOf(1L), (UnitComplete)article.getChildNamed(BasicArticleComplete_.mainStoreUnit).getValue()));
                    KanbanConfigurationTable.this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)config, true, false), 0L);
                } else {
                    ArticleKanbanConfigurationComplete articleKanbanConfigurationComplete = (ArticleKanbanConfigurationComplete)new ArticleKanbanConfigurationVariantAdd().addVariant(KanbanConfigurationTable.this.getModel().getNode(), null);
                }
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int pw = DateChooser.getPreferredWidth(this, false) + 2 * this.getCellPadding();
        int preferredWidth = DateChooser.getPreferredWidth(this, true) + 2 * this.getCellPadding();
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", pw));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", preferredWidth));
        columns.add(new TableColumnInfo(Words.STORE, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columns.add(new TableColumnInfo(Words.IMAGE, null, null, null, "", 260, 260, 260));
        int dw = 2 * this.getCellPadding() + InputComboBox2.getPreferredWidth(this, 3);
        columns.add(new TableColumnInfo("Qty per Card", null, null, null, "", dw));
        columns.add(new TableColumnInfo("Daily Average Usage", null, null, null, "", dw));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private StorePositionSearchBox store;
        private RDDateChooser startDate;
        private RDDateChooser endDate;
        private RDImageChooser image;
        private InputComboBox2 qty;
        private InputComboBox2 averageQty;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.startDate = new RDDateChooser(KanbanConfigurationTable.this.getProvider());
            this.startDate.setOverrideName(BasicArticleComplete_.kanbanConfigurations);
            this.endDate = new RDDateChooser(KanbanConfigurationTable.this.getProvider());
            this.endDate.setOverrideName(BasicArticleComplete_.kanbanConfigurations);
            this.endDate.setCheckBoxEnabled();
            this.startDate.setNode(m.getNode().getChildNamed(new DtoField[]{ArticleKanbanConfigurationComplete_.validity, PeriodComplete_.startDate}));
            this.endDate.setNode(m.getNode().getChildNamed(new DtoField[]{ArticleKanbanConfigurationComplete_.validity, PeriodComplete_.endDate}));
            this.store = new StorePositionSearchBox(true, KanbanConfigurationTable.this.getProvider());
            this.store.setOverrideName(BasicArticleComplete_.kanbanConfigurations.getFieldName());
            this.store.setNode((Node<StorePositionLight>)m.getNode().getChildNamed(ArticleKanbanConfigurationComplete_.storePosition));
            this.image = new RDImageChooser(KanbanConfigurationTable.this.getProvider());
            this.image.setOverrideName(BasicArticleComplete_.kanbanConfigurations.getFieldName());
            this.image.setNode(m.getNode().getChildNamed(ArticleKanbanConfigurationComplete_.image));
            this.qty = new InputComboBox2(m.getNode().getChildNamed(new DtoField[]{ArticleKanbanConfigurationComplete_.quantityPerCard, StoreQuantityComplete_.amount}), m.getNode().getChildNamed(new DtoField[]{ArticleKanbanConfigurationComplete_.quantityPerCard, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
            this.averageQty = new InputComboBox2(m.getNode().getChildNamed(new DtoField[]{ArticleKanbanConfigurationComplete_.averageDailyUsageQuantity, StoreQuantityComplete_.amount}), m.getNode().getChildNamed(new DtoField[]{ArticleKanbanConfigurationComplete_.averageDailyUsageQuantity, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
            this.qty.setPossibleUnits(KanbanConfigurationTable.this.storeUnitSelectionNode);
            this.averageQty.setPossibleUnits(KanbanConfigurationTable.this.storeUnitSelectionNode);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.startDate);
            this.add(this.endDate);
            this.add(this.store);
            this.add(this.image);
            this.add(this.qty);
            this.add(this.averageQty);
            this.add(this.delete);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.startDate.kill();
            this.endDate.kill();
            this.store.kill();
            this.image.kill();
            this.qty.kill();
            this.averageQty.kill();
            this.delete.kill();
            this.startDate = null;
            this.endDate = null;
            this.store = null;
            this.image = null;
            this.qty = null;
            this.averageQty = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.startDate);
            CheckedListAdder.addToList(focusList, this.endDate);
            CheckedListAdder.addToList(focusList, this.store);
            CheckedListAdder.addToList(focusList, this.image);
            CheckedListAdder.addToList(focusList, this.qty);
            CheckedListAdder.addToList(focusList, this.averageQty);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.startDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.startDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.startDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.startDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.endDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.endDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.endDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.endDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.store.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.store.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.store.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.store.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.image.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.image.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.image.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.image.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.qty.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.qty.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.qty.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.qty.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.averageQty.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.averageQty.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.averageQty.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.averageQty.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

