/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.GeneralInfoSheetComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LabelListTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public LabelListTable() {
        super(false, "", false, false, "");
        this.setSortDirection(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.USER, null, null, null, "", 120, 120, 120));
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.PAX_COUNT, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel user;
        private TextLabel date;
        private TextLabel paxConfig;
        private ViewButton viewButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.user = new TextLabel(m.getNode().getChildNamed(new DtoField[]{GeneralInfoSheetComplete_.sheet, PegasusFileComplete_.uploadUser}), ConverterRegistry.getConverter(UserConverter.class));
            this.date = new TextLabel(m.getNode().getChildNamed(new DtoField[]{GeneralInfoSheetComplete_.sheet, PegasusFileComplete_.uploadTime}), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.paxConfig = new TextLabel(m.getNode().getChildNamed(GeneralInfoSheetComplete_.paxConfig));
            this.viewButton = new ViewButton();
            this.viewButton.addButtonListener(this);
            this.setLayout(new Layout3());
            this.add(this.user);
            this.add(this.date);
            this.add(this.paxConfig);
            this.add(this.viewButton);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.viewButton) {
                LabelListTable.this.showLoadingAnimation(Words.OPEN_SHEET);
                ThreadSafeExecutable run = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        File f = FileTransferUtil.download((PegasusFileComplete)((PegasusFileComplete)TableRowImpl.this.model.getNode().getChildNamed(new String[]{"sheet"}).getValue()), (FileTransferListener[])new FileTransferListener[0]);
                        PrintPopupToolkit.previewFile(f);
                        return null;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                LabelListTable.this.hideLoadingAnimation();
                            }

                            public void errorOccurred(ClientException exception) {
                                LabelListTable.this.hideLoadingAnimation();
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.viewButton = null;
            this.paxConfig = null;
            this.date = null;
            this.user = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.viewButton);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new DtoField[]{GeneralInfoSheetComplete_.sheet, PegasusFileComplete_.uploadUser}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new DtoField[]{GeneralInfoSheetComplete_.sheet, PegasusFileComplete_.uploadTime}).getValue();
                }
            }
            return this.model.getNode().getChildNamed(new DtoField[]{GeneralInfoSheetComplete_.sheet, PegasusFileComplete_.uploadTime}).getValue();
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.user.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.user.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.user.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.user.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(TableRowImpl.this.date.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.paxConfig.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.paxConfig.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.paxConfig.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.paxConfig.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.viewButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.viewButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.viewButton.setSize(TableRowImpl.this.viewButton.getPreferredSize());
            }
        }
    }
}

