/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ManMinutesOverflowComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ManMinutesOverflowComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ManMinutesOverflowTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public ManMinutesOverflowTable() {
        this(true);
    }

    public ManMinutesOverflowTable(boolean background) {
        super(true, Words.ADD, background, background, Words.MAN_MINUTES_OVERFLOW);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ManMinutesOverflowTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                ManMinutesOverflowComplete overflow = new ManMinutesOverflowComplete();
                overflow.setClientOId(Long.valueOf(ADTO.getNextId()));
                ManMinutesOverflowTable.this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)overflow, true, false), 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.FROM_PERCENT, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.TO_PRECENT, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.DISCOUNT_IN_PERCENT, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextField from;
        private TextField to;
        private TextField discount;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.from = new TextField(m.getNode().getChildNamed(ManMinutesOverflowComplete_.differenceLowerBound), TextFieldType.INT);
            this.to = new TextField(m.getNode().getChildNamed(ManMinutesOverflowComplete_.differenceUpperBound), TextFieldType.INT);
            this.discount = new TextField(m.getNode().getChildNamed(ManMinutesOverflowComplete_.timeDiscount), TextFieldType.DOUBLE);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout3());
            this.add(this.from);
            this.add(this.to);
            this.add(this.discount);
            this.add(this.delete);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.from.kill();
            this.to.kill();
            this.discount.kill();
            this.delete.kill();
            this.from = null;
            this.to = null;
            this.discount = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.from);
            CheckedListAdder.addToList(a, this.to);
            CheckedListAdder.addToList(a, this.discount);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.from.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.from.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.from.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.from.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.to.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.to.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.to.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.to.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.discount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.discount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.discount.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.discount.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

