/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.SaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.EnterMessagePopupInsert;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.especs.ESpecsDataImportComplete_;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.matdispo.MatDispoDataExportComplete;
import ch.icit.pegasus.server.core.dtos.matdispo.MatDispoDataExportComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.MatDispoAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MatDispoExportSheetListTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public MatDispoExportSheetListTable() {
        super(false, "", false, false, "");
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.USER, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.REMARK, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel user;
        private TextLabel date;
        private TextLabel remark;
        private EditButton editRemark;
        private ViewButton viewButton;
        private SaveButton saveButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.user = new TextLabel(m.getNode().getChildNamed(ESpecsDataImportComplete_.creationUser), ConverterRegistry.getConverter(UserConverter.class));
            this.date = new TextLabel(m.getNode().getChildNamed(ESpecsDataImportComplete_.creationTime), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.remark = new TextLabel(m.getNode().getChildNamed(MatDispoDataExportComplete_.remark));
            this.editRemark = new EditButton();
            this.editRemark.addButtonListener(this);
            this.viewButton = new ViewButton();
            this.viewButton.addButtonListener(this);
            this.saveButton = new SaveButton();
            this.saveButton.addButtonListener(this);
            this.setLayout(new Layout3());
            this.add(this.user);
            this.add(this.date);
            this.add(this.remark);
            this.add(this.editRemark);
            this.add(this.viewButton);
            this.add(this.saveButton);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.editRemark) {
                InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
                pop.setAttributes(this, true, true, MatDispoAccess.INFO_MATERIAL_DISPOSITION_HISTORY.getDisplayName());
                EnterMessagePopupInsert r = new EnterMessagePopupInsert(this.model.getNode().getChildNamed(MatDispoDataExportComplete_.remark));
                pop.setView(r);
                pop.showPopUp(x, y, 300, 200, new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        if (xargs == null) {
                            return;
                        }
                        MatDispoExportSheetListTable.this.showLoadingAnimation(Words.SAVE_DATA);
                        ThreadSafeExecutable run = new ThreadSafeExecutable(){

                            @Override
                            public Node<?> loadData() throws Exception {
                                TableRowImpl.this.model.getNode().commitThis(MatDispoDataExportComplete.class);
                                MatDispoDataExportComplete d = (MatDispoDataExportComplete)TableRowImpl.this.model.getNode().getValue(MatDispoDataExportComplete.class);
                                d = (MatDispoDataExportComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateMatDispoExport(d).getValue();
                                TableRowImpl.this.model.getNode().removeExistingValues();
                                TableRowImpl.this.model.getNode().setValue((Object)d, 0L);
                                TableRowImpl.this.model.getNode().updateNode();
                                return null;
                            }

                            @Override
                            public RemoteLoader getInvoker() {
                                return new RemoteLoader(){

                                    public void remoteObjectLoaded(Node<?> node) {
                                        MatDispoExportSheetListTable.this.hideLoadingAnimation();
                                    }

                                    public void errorOccurred(ClientException exception) {
                                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)MatDispoExportSheetListTable.this);
                                    }
                                };
                            }

                            @Override
                            public long getID() {
                                return 0L;
                            }
                        };
                        ThreadSafeLoader.run(run);
                    }
                }, this);
            } else {
                Boolean preview;
                if (source == this.viewButton) {
                    MatDispoExportSheetListTable.this.showLoadingAnimation(Words.OPEN_SHEET);
                    preview = true;
                } else {
                    MatDispoExportSheetListTable.this.showLoadingAnimation(Words.DOWNLOAD_SHEET);
                    preview = false;
                }
                ThreadSafeExecutable run = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        File f = FileTransferUtil.download((PegasusFileComplete)((PegasusFileComplete)TableRowImpl.this.model.getNode().getChildNamed(ESpecsDataImportComplete_.sheet).getValue()), (FileTransferListener[])new FileTransferListener[0]);
                        if (preview.booleanValue()) {
                            PrintPopupToolkit.previewFile(f);
                        } else {
                            FileChooserUtil.saveFile(f, "xlsx");
                        }
                        return null;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                MatDispoExportSheetListTable.this.hideLoadingAnimation();
                            }

                            public void errorOccurred(ClientException exception) {
                                MatDispoExportSheetListTable.this.hideLoadingAnimation();
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.viewButton = null;
            this.saveButton = null;
            this.date = null;
            this.user = null;
            this.remark = null;
            this.editRemark = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.editRemark);
            CheckedListAdder.addToList(a, this.saveButton);
            CheckedListAdder.addToList(a, this.viewButton);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(TableRowImpl.this.date.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.user.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.user.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.user.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.user.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.remark.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.remark.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.remark.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.editRemark.getPreferredSize().getWidth())), (int)TableRowImpl.this.remark.getPreferredSize().getHeight());
                TableRowImpl.this.editRemark.setLocation(TableRowImpl.this.remark.getX() + TableRowImpl.this.remark.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.editRemark.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.editRemark.setSize(TableRowImpl.this.editRemark.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.saveButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.saveButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.saveButton.setSize(TableRowImpl.this.saveButton.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.viewButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.viewButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.viewButton.setSize(TableRowImpl.this.viewButton.getPreferredSize());
            }
        }
    }
}

