/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorTenderVariantComplete_;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorVariantComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class MaterialCostPeriodTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    protected JComponent parentComponent;
    private boolean showCustomer;
    private boolean canRemoveVariant;
    private boolean canEditPeriodDate;
    private RDProvider provider;

    public MaterialCostPeriodTable(JComponent parentComponent, RDProvider provider) {
        this(parentComponent, provider, false);
    }

    public MaterialCostPeriodTable(JComponent parentComponent, RDProvider provider, boolean showCustomer) {
        super(true, Words.ADD, false, false);
        this.provider = provider;
        this.parentComponent = parentComponent;
        this.showCustomer = showCustomer;
        this.setUseWriteAccessRight(true);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                MaterialCostPeriodTable.this.parentComponent.validate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                MaterialCostPeriodTable.this.createNewMaterialCost();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        if (showCustomer) {
            columns.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", 180, 180, 180));
        }
        columns.add(new TableColumnInfo(Words.PERIOD, null, null, null, "", 30, 30, 30));
        int tw = this.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        if (showCustomer) {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        } else {
            ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        }
        this.setModel(new Table2Model(columns, model1 -> new VariantTableRowImpl(model1, provider)));
    }

    public void setTender(boolean tender, boolean isNewArticle) {
        if (!tender) {
            this.canRemoveVariant = this.provider.isWritable(BasicArticleLight_.materialCostFactorVariants.getFieldName() + "-removevariant") || isNewArticle;
            this.canEditPeriodDate = this.provider.isWritable(BasicArticleLight_.materialCostFactorVariants.getFieldName() + "-period") || isNewArticle;
        } else {
            this.canRemoveVariant = this.provider.isWritable(BasicArticleLight_.materialCostFactorTenderVariants.getFieldName() + "-removevariant") || isNewArticle;
            this.canEditPeriodDate = this.provider.isWritable(BasicArticleLight_.materialCostFactorTenderVariants.getFieldName() + "-period") || isNewArticle;
        }
    }

    protected void createNewMaterialCost() {
        Node latestData = this.getModel().getNode().getChildCount() > 0 ? this.getModel().getNode().getChildAt(this.getModel().getNode().getChildCount() - 1) : null;
        MaterialCostFactorVariantComplete m = new MaterialCostFactorVariantComplete();
        m.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (latestData != null) {
            Date d;
            Node latestDateStart = latestData.getChildNamed(new DtoField[]{MaterialCostFactorVariantComplete_.validityPeriod, PeriodComplete_.startDate});
            Node latestDateEnd = latestData.getChildNamed(new DtoField[]{MaterialCostFactorVariantComplete_.validityPeriod, PeriodComplete_.endDate});
            Date lastEnd = (Date)latestDateEnd.getValue();
            Date lastStart = (Date)latestDateStart.getValue();
            boolean isFuture = false;
            if (lastStart.getTime() > System.currentTimeMillis()) {
                isFuture = true;
            }
            boolean wasInfinity = false;
            if (CalendarUtil.isInfinityDate((Date)lastEnd)) {
                wasInfinity = true;
                if (isFuture) {
                    d = new Date(lastStart.getTime());
                    d = new PeriodComplete(null, d).getEndDate();
                    latestDateEnd.setValue((Object)d, 0L);
                } else {
                    d = new Date(System.currentTimeMillis());
                    d = new PeriodComplete(d, null).getStartDate();
                    d = new PeriodComplete(null, d).getEndDate();
                    latestDateEnd.setValue((Object)d, 0L);
                }
                d = new PeriodComplete(null, d).getEndDate();
            } else {
                d = lastEnd;
                d = new PeriodComplete(null, d).getEndDate();
            }
            d.setTime(d.getTime() + 2L);
            PeriodComplete period = new PeriodComplete(d, d);
            if (wasInfinity) {
                period.setEndDate(CalendarUtil.getInfinityDate());
            }
            m.setValidityPeriod(period);
        } else {
            m.setValidityPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        }
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)m, true, false);
        this.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.parentComponent.validate();
    }

    class VariantTableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TitledPeriodEditor period;
        private SearchComboBox customer;
        private DeleteButton delete;

        public VariantTableRowImpl(Table2RowModel m, RDProvider provider) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.setSelectable(true);
            this.period = new TitledPeriodEditor(null, null, false, null, BasicArticleComplete_.materialCostFactorVariants.getFieldName());
            this.period.enableInfinity(false, true);
            if (MaterialCostPeriodTable.this.showCustomer) {
                this.customer = SearchComboBoxFactory.getCustomerSearchField(true, m.getNode().getChildNamed(MaterialCostFactorTenderVariantComplete_.customer));
            }
            this.period.setStartDateNode(m.getNode().getChildNamed(new DtoField[]{MaterialCostFactorVariantComplete_.validityPeriod, PeriodComplete_.startDate}));
            this.period.setEndDateNode(m.getNode().getChildNamed(new DtoField[]{MaterialCostFactorVariantComplete_.validityPeriod, PeriodComplete_.endDate}));
            this.setLayout(new Layout());
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            if (MaterialCostPeriodTable.this.showCustomer) {
                this.add(this.customer);
            }
            this.add(this.period);
            this.add(this.delete);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    if (MaterialCostPeriodTable.this.showCustomer) {
                        this.model.getNode().getChildNamed(MaterialCostFactorTenderVariantComplete_.customer).getValue();
                    }
                    return this.period.getStartDate();
                }
                case 1: {
                    if (!MaterialCostPeriodTable.this.showCustomer) break;
                    return this.period.getStartDate();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.period.setEnabled(isEnabled && MaterialCostPeriodTable.this.canEditPeriodDate);
            this.delete.setEnabled(isEnabled && MaterialCostPeriodTable.this.canRemoveVariant);
            if (this.customer != null) {
                this.customer.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.period.kill();
            this.delete.kill();
            this.period = null;
            this.delete = null;
            if (this.customer != null) {
                this.customer.kill();
            }
            this.customer = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.customer);
            CheckedListAdder.addToList(a, this.period);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.period.requestFocusInWindowNow();
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = VariantTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                if (MaterialCostPeriodTable.this.showCustomer) {
                    VariantTableRowImpl.this.customer.setLocation(currentX + VariantTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - VariantTableRowImpl.this.customer.getPreferredSize().getHeight()) / 2.0));
                    VariantTableRowImpl.this.customer.setSize(w - (VariantTableRowImpl.this.getCellPadding() + VariantTableRowImpl.this.getCellPadding()), (int)VariantTableRowImpl.this.customer.getPreferredSize().getHeight());
                    currentX += w;
                    w = VariantTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                }
                VariantTableRowImpl.this.period.setLocation(currentX + VariantTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - VariantTableRowImpl.this.period.getPreferredSize().getHeight()) / 2.0));
                VariantTableRowImpl.this.period.setSize(w - (VariantTableRowImpl.this.getCellPadding() + VariantTableRowImpl.this.getCellPadding()), (int)VariantTableRowImpl.this.period.getPreferredSize().getHeight());
                currentX += w;
                w = MaterialCostPeriodTable.this.showCustomer ? VariantTableRowImpl.this.model.getParentModel().getColumnWidth(2) : VariantTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                VariantTableRowImpl.this.setControlsX(currentX);
                VariantTableRowImpl.this.delete.setLocation(currentX + VariantTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - VariantTableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                VariantTableRowImpl.this.delete.setSize(VariantTableRowImpl.this.delete.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, VariantTableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

