/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.QuantityConverter1Decimal;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanelLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.ProductChargeBatchSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.production_new.charges.ProductChargeBatchComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.charges.ProductChargeLight_;
import ch.icit.pegasus.server.core.dtos.search.ProductChargeBatchSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight_;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.util.ArrayList;

public class ProductChargeBatchSearchTable
extends PageableTable2 {
    private StoreLight store;
    private static final String FILTER_NAME_NUMBER = "Name/Number";
    private String filterName;

    public ProductChargeBatchSearchTable() {
        super("Product Charges", true, false, false);
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        headers.add(new TableColumnInfo("Number", null, null, null, "", TableColumnInfo.numberColumnWidth));
        headers.add(new TableColumnInfo("Name", null, null, null, "", 40, Integer.MAX_VALUE, 120));
        headers.add(new TableColumnInfo("Charge", null, null, null, "", TableColumnInfo.numberColumnWidth));
        headers.add(new TableColumnInfo("Position", null, null, null, "", TableColumnInfo.costCenter));
        headers.add(new TableColumnInfo("Last Inventory", null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        headers.add(new TableColumnInfo("Quantity", null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        ((TableColumnInfo)headers.get(0)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(1)).setxExpand(1.0);
        ((TableColumnInfo)headers.get(2)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(3)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(4)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(5)).setxExpand(0.0);
        this.setModel(new Table2Model(headers, model -> this.createRow(model)));
    }

    public void setStore(StoreLight store) {
        this.store = store;
    }

    public void setNode(Node node) {
        this.getModel().setNode(node);
        this.invokeDefaultSearch();
    }

    @Override
    public void fillFilterChain() {
        this.filterChain.addSeachField(FILTER_NAME_NUMBER, Words.NAME_OR_NUMBER);
    }

    @Override
    public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
        return this.filterChainValueChanged(id, value);
    }

    private ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterChainValueChanged(String id, Object value) {
        if (id == FILTER_NAME_NUMBER) {
            this.filterName = (String)value;
        }
        ProductChargeBatchSearchConfiguration config = new ProductChargeBatchSearchConfiguration();
        config.setStore(this.store);
        try {
            Integer no = Integer.valueOf(this.filterName);
            config.setNumber(no);
        }
        catch (Exception e) {
            config.setNumber(null);
        }
        config.setName(this.filterName);
        return config;
    }

    @Override
    public SearchAlgorithm getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(ProductChargeBatchSearchAlgorithm.class);
    }

    private Table2RowPanel createRow(Table2RowModel m) {
        DefaultTable2RowPanel row = new DefaultTable2RowPanel(m);
        row.addLayoutComponent(new TextLabel(m.getNode().getChildNamed(new DtoField[]{ProductChargeBatchComplete_.charge, ProductChargeLight_.product, ProductComplete_.number}), ConverterRegistry.getConverter(IntegerConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(m.getNode().getChildNamed(new DtoField[]{ProductChargeBatchComplete_.charge, ProductChargeLight_.product, ProductComplete_.currentVariant, ProductVariantLight_.name}), ConverterRegistry.getConverter(StringConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(m.getNode().getChildNamed(new DtoField[]{ProductChargeBatchComplete_.charge, ProductChargeLight_.number}), ConverterRegistry.getConverter(IntegerConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(m.getNode().getChildNamed(new DtoField[]{ProductChargeBatchComplete_.position, StoreLight_.name}), ConverterRegistry.getConverter(StringConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(m.getNode().getChildNamed(ProductChargeBatchComplete_.lastInventory), ConverterRegistry.getConverter(DateConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(m.getNode().getChildNamed(ProductChargeBatchComplete_.quantity), ConverterRegistry.getConverter(QuantityConverter1Decimal.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        return row;
    }
}

