/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SageImportTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public SageImportTable() {
        super(true, Words.ADD, false, false);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                SageImportTable.this.getParent().revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                DTOProxyNode node = new DTOProxyNode();
                SageImportTable.this.getModel().getNode().addChild((Node)node, 0L);
                SageImportTable.this.getParent().revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.SAGE_IMPORT, null, null, null, "", 10, Integer.MAX_VALUE, 10));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public void setNode(Node<?> node) {
        this.getModel().setNode(node);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2 sageImportSearch;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.sageImportSearch = SearchTextField2Factory.getSageImportSearchField(true, m.getNode());
            if (m.getNode().getValue() != null) {
                this.sageImportSearch.resetText();
            }
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.sageImportSearch);
            this.add(this.deleteButton);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.sageImportSearch.kill();
            this.deleteButton.kill();
            this.sageImportSearch = null;
            this.deleteButton = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.sageImportSearch.getFocusComponents());
            a.addAll(this.deleteButton.getFocusComponents());
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.sageImportSearch.setEnabled(isEnabled);
            this.deleteButton.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                SageImportTable.this.getModel().getNode().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.sageImportSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.sageImportSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.sageImportSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.sageImportSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
            }
        }
    }
}

