/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.DepartmentConverter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanelLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanStoreConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanStoreConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanStoreTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.ArrayList;

public class WeeklyPlanStoreConfigurationTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public WeeklyPlanStoreConfigurationTable() {
        super(true, Words.ADD, true, true, "Store Configuration");
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                WeeklyPlanStoreConfigurationTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                WeeklyPlanStoreConfigurationComplete part = new WeeklyPlanStoreConfigurationComplete();
                part.setClientOId(Long.valueOf(ADTO.getNextId()));
                WeeklyPlanStoreConfigurationTable.this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)part, true, false), 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("Store", null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columns.add(new TableColumnInfo("Department", null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columns.add(new TableColumnInfo("Type", null, null, null, "", 40, Integer.MAX_VALUE, 40));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.34);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.33);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.33);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model -> this.createRow(model)));
    }

    public void setNode(Node<WeeklyPlanSettingsComplete> node) {
        this.getModel().setNode(node.getChildNamed(WeeklyPlanSettingsComplete_.storeConfigurations));
    }

    private Table2RowPanel createRow(Table2RowModel m) {
        DefaultTable2RowPanel row = new DefaultTable2RowPanel(m);
        row.addLayoutComponent(SearchTextField2Factory.getStoreSearchField(true, m.getNode().getChildNamed(WeeklyPlanStoreConfigurationComplete_.store)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new ComboBox(m.getNode().getChildNamed(WeeklyPlanStoreConfigurationComplete_.department), NodeToolkit.getAffixList(InternalCostCenterComplete.class), ConverterRegistry.getConverter(DepartmentConverter.class), true), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(ComboBoxFactory.getNodeWeeklyPlanStoreTypeComboBox((Node<WeeklyPlanStoreTypeE>)m.getNode().getChildNamed(WeeklyPlanStoreConfigurationComplete_.type)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new DeleteButton((source, x, y) -> m.getNode().getParent().removeChild(m.getNode(), 0L)), DefaultTable2RowPanelLayout.LayoutType.FIX);
        return row;
    }
}

