/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.textfield;

import ch.icit.pegasus.client.converter.InternationalizedConverter;
import ch.icit.pegasus.client.gui.utils.textfield.AbstractTextField;
import ch.icit.pegasus.client.gui.utils.textfield.DateTimeTextField;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.PasswordTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JFormattedTextField;

public enum TextFieldType {
    DATE{

        @Override
        public void textChanged(Node node, AbstractTextField textField, boolean silentForAll) {
            Object d = textField.converter.inverseConvert((Object)textField.getText(), node.getValue());
            if (d != null) {
                Date dd = (Date)d;
                if ((node.getValue() == null || dd.getTime() != ((Date)node.getValue()).getTime()) && node instanceof Node) {
                    node.setValueSilent(d, silentForAll, TextFieldType.getNewId(), new NodeListener[]{textField});
                }
                textField.switchState(true);
            } else {
                textField.switchState(false);
            }
        }

        @Override
        public void nodeChanged(Node node, AbstractTextField textField) {
            if (node.getValue() == null) {
                textField.setText(((InternationalizedConverter)textField.converter).getplaceHolderPattern());
            } else {
                String value = (String)textField.converter.convert(node.getValue(), node, new Object[0]);
                textField.setText(value);
            }
            if (textField.getTextField() instanceof JFormattedTextField) {
                try {
                    ((JFormattedTextField)textField.getTextField()).commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }

        @Override
        public TextField createTextField(Node node) {
            return new DateTimeTextField(node, DATE);
        }
    }
    ,
    DAYTIME{

        @Override
        public void textChanged(Node node, AbstractTextField textField, boolean silentForAll) {
            Object d = textField.converter.inverseConvert((Object)textField.getText(), node.getValue());
            if (d != null) {
                Date dd = (Date)d;
                if ((node.getValue() == null || dd.getTime() != ((Date)node.getValue()).getTime()) && node instanceof Node) {
                    node.setValueSilent(d, silentForAll, TextFieldType.getNewId(), new NodeListener[]{textField});
                }
                textField.switchState(true);
            } else {
                textField.switchState(false);
            }
        }

        @Override
        public void nodeChanged(Node node, AbstractTextField textField) {
            DATE.nodeChanged(node, textField);
        }

        @Override
        public TextField createTextField(Node node) {
            return new DateTimeTextField(node, DAYTIME);
        }
    }
    ,
    HOUR_MINUTE_SECOND_TIME{

        @Override
        public void textChanged(Node node, AbstractTextField textField, boolean silentForAll) {
            Object d = textField.converter.inverseConvert((Object)textField.getText(), node.getValue());
            if (d != null) {
                if (d instanceof Date) {
                    Date dd = (Date)d;
                    if ((node.getValue() == null || dd.getTime() != ((Date)node.getValue()).getTime()) && node instanceof Node) {
                        node.setValueSilent((Object)dd, silentForAll, TextFieldType.getNewId(), new NodeListener[]{textField});
                    }
                } else if (d instanceof Double) {
                    Double dd = (Double)d;
                    if ((node.getValue() == null || !dd.equals(node.getValue())) && node instanceof Node) {
                        node.setValueSilent((Object)dd, silentForAll, TextFieldType.getNewId(), new NodeListener[]{textField});
                    }
                }
                textField.switchState(true);
            } else {
                textField.switchState(false);
            }
        }

        @Override
        public void nodeChanged(Node node, AbstractTextField textField) {
            if (node.getValue() == null) {
                textField.setText(((InternationalizedConverter)textField.converter).getplaceHolderPattern());
            } else {
                String value = (String)textField.converter.convert(node.getValue(), node, new Object[0]);
                textField.setText(value);
            }
            try {
                ((JFormattedTextField)textField.getTextField()).commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        @Override
        public TextField createTextField(Node node) {
            return new DateTimeTextField(node, HOUR_MINUTE_SECOND_TIME);
        }
    }
    ,
    INT{

        @Override
        public void textChanged(Node node, AbstractTextField textField, boolean silentForAll) {
            try {
                int intValue = 0;
                double dV = 0.0;
                if (textField.getText().equals("-")) {
                    return;
                }
                if (!textField.getText().equals("")) {
                    dV = Double.valueOf(textField.getText());
                }
                intValue = (int)dV;
                if (node instanceof Node) {
                    node.setValueSilent((Object)intValue, silentForAll, TextFieldType.getNewId(), new NodeListener[]{textField});
                    node.commit();
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void nodeChanged(Node node, AbstractTextField textField) {
            if (node.getValue() instanceof Double) {
                double v = (Double)node.getValue();
                int v1 = (int)Math.round(v);
                textField.setText("" + v1);
            } else if (node.getValue() instanceof Integer) {
                int v = (Integer)node.getValue();
                textField.setText("" + v);
            } else if (node.getValue() instanceof Long) {
                long v = (Long)node.getValue();
                textField.setText("" + v);
            } else {
                textField.setText("");
            }
        }

        @Override
        public TextField createTextField(Node node) {
            return new NumberTextField(node, INT);
        }
    }
    ,
    INT_NULLABLE{

        @Override
        public void textChanged(Node node, AbstractTextField textField, boolean silentForAll) {
            try {
                Integer intValue = 0;
                Double dV = null;
                if (textField.getText().equals("-")) {
                    return;
                }
                if (!textField.getText().equals("")) {
                    dV = Double.valueOf(textField.getText());
                } else {
                    intValue = null;
                }
                if (dV != null) {
                    intValue = dV.intValue();
                }
                node.setValueSilent((Object)intValue, silentForAll, TextFieldType.getNewId(), new NodeListener[]{textField});
                node.commit();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void nodeChanged(Node node, AbstractTextField textField) {
            if (node.getValue() instanceof Double) {
                double v = (Double)node.getValue();
                int v1 = (int)Math.round(v);
                textField.setText("" + v1);
            } else if (node.getValue() instanceof Integer) {
                int v = (Integer)node.getValue();
                textField.setText("" + v);
            } else if (node.getValue() instanceof Long) {
                long v = (Long)node.getValue();
                textField.setText("" + v);
            } else {
                textField.setText("");
            }
        }

        @Override
        public TextField createTextField(Node node) {
            return new NumberTextField(node, INT_NULLABLE);
        }
    }
    ,
    LONG{

        @Override
        public void textChanged(Node node, AbstractTextField textField, boolean silentForAll) {
            long longValue = 0L;
            double dV = 0.0;
            if (textField.getText().equals("-")) {
                return;
            }
            if (!textField.getText().equals("")) {
                dV = Double.valueOf(textField.getText());
            }
            longValue = (long)dV;
            if (node instanceof Node) {
                node.setValueSilent((Object)longValue, silentForAll, TextFieldType.getNewId(), new NodeListener[]{textField});
                node.commit();
            }
        }

        @Override
        public void nodeChanged(Node node, AbstractTextField textField) {
            INT.nodeChanged(node, textField);
        }

        @Override
        public TextField createTextField(Node node) {
            return new NumberTextField(node, LONG);
        }
    }
    ,
    DOUBLE{

        @Override
        public void textChanged(Node node, AbstractTextField textField, boolean silentForAll) {
            double doubleValue = 0.0;
            String t = NumberTextField.getUnifiedDecimalString(textField.getText());
            if (t.equals(".") || t.equals("-")) {
                return;
            }
            if (!t.equals("")) {
                try {
                    doubleValue = Double.valueOf(t);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            node.setValueSilent((Object)doubleValue, silentForAll, TextFieldType.getNewId(), new NodeListener[]{textField});
            node.commit();
        }

        @Override
        public void nodeChanged(Node node, AbstractTextField textField) {
            if (node.getValue() instanceof Integer) {
                int v = (Integer)node.getValue();
                String t = "" + v;
                if (textField.format != null) {
                    t = textField.format.format(v);
                }
                textField.setText(t);
            } else if (node.getValue() != null) {
                double v = (Double)node.getValue();
                String t = "" + v;
                if (textField.format != null) {
                    t = textField.format.format(v);
                }
                textField.setText(t);
            } else {
                textField.setText("");
            }
        }

        @Override
        public TextField createTextField(Node node) {
            return new NumberTextField(node, DOUBLE);
        }
    }
    ,
    NORMAL{

        @Override
        public void textChanged(Node node, AbstractTextField textField, boolean silentForAll) {
            if ((node.getValue() == null || !node.getValue().equals(textField.getText())) && node instanceof Node) {
                node.setValueSilent((Object)textField.getText(), silentForAll, TextFieldType.getNewId(), new NodeListener[]{textField});
                node.commit();
            }
        }

        @Override
        public void nodeChanged(Node node, AbstractTextField textField) {
            if (node.getValue() == null) {
                textField.setText("");
            } else {
                String nt = (String)node.getFormattedValue();
                if (!nt.equals(textField.getText())) {
                    textField.setText(nt);
                }
            }
        }

        @Override
        public TextField createTextField(Node node) {
            return new TextField(node);
        }
    }
    ,
    PASSWORD{

        @Override
        public void textChanged(Node node, AbstractTextField textField, boolean silentForAll) {
            NORMAL.textChanged(node, textField, silentForAll);
        }

        @Override
        public void nodeChanged(Node node, AbstractTextField textField) {
            NORMAL.nodeChanged(node, textField);
        }

        @Override
        public TextField createTextField(Node node) {
            return new PasswordTextField(node);
        }
    };


    public abstract void textChanged(Node var1, AbstractTextField var2, boolean var3);

    public abstract void nodeChanged(Node var1, AbstractTextField var2);

    public abstract TextField createTextField(Node var1);

    private static long getNewId() {
        return System.currentTimeMillis();
    }
}

