/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tooltip.impls;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter3Decimals;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import java.sql.Timestamp;
import java.util.List;

public class PackagingQuantityFormulaCoverter
implements Converter<BasicArticleComplete, String> {
    public String convert(BasicArticleComplete art, Node<BasicArticleComplete> currentNode, Object ... param) {
        if (art == null) {
            return NULL_RETURN;
        }
        String retString = "";
        Timestamp validity = new Timestamp(System.currentTimeMillis());
        List qList = null;
        for (PackagingQuantityBaseComplete baseComplete : art.getPackingQuantitiesVariants()) {
            if (baseComplete.getPeriod().getStartDate().getTime() > validity.getTime() || baseComplete.getPeriod().getEndDate().getTime() < validity.getTime()) continue;
            qList = baseComplete.getPackingQuantities();
        }
        FormattedDoubleConverter3Decimals conv = (FormattedDoubleConverter3Decimals)ConverterRegistry.getConverter(FormattedDoubleConverter3Decimals.class);
        double amount = 1.0;
        for (PackagingQuantityComplete q : qList) {
            String fr = conv.convert((Number)(amount *= (double)q.getAmount().intValue()), null, new Object[0]);
            retString = retString + fr + " " + q.getUnit().getShortName() + " = ";
        }
        if (retString.length() > 3) {
            retString = retString.substring(0, retString.length() - 3);
        }
        return retString;
    }

    public Class<? extends BasicArticleComplete> getParameterClass() {
        return BasicArticleComplete.class;
    }
}

