/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.searcher.searchfieldimpls;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.FlightSearchAlgorithm;
import ch.icit.pegasus.client.searcher.SearchFieldSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import java.sql.Date;
import java.sql.Timestamp;

public class FlightSearchFieldRemoteSearchAlgorithm
extends SearchFieldSearchAlgorithm<FlightSearchAlgorithm, FlightLight> {
    public FlightSearchFieldRemoteSearchAlgorithm() {
        super(SearchAlgorithmRegistry.getSearchAlgorithm(FlightSearchAlgorithm.class));
    }

    @Override
    public ASearchConfiguration<FlightLight, ? extends Enum<?>> getInternalSearchParameters(Object ... xargs) {
        Object[] o;
        String t = (String)xargs[0];
        FlightSearchConfiguration c = new FlightSearchConfiguration();
        c.setFlightNumber(t);
        if (xargs.length >= 2 && (o = (Object[])xargs[1]) != null && o.length >= 1) {
            if (o[0] instanceof CustomerLight) {
                CustomerLight customer = (CustomerLight)o[0];
                c.setCustomer(customer);
            } else if (o[0] instanceof Node) {
                Node no = (Node)o[0];
                if (no.getValue() instanceof CustomerLight) {
                    c.setCustomer((CustomerLight)no.getValue());
                } else if (no.getValue() instanceof Timestamp) {
                    Timestamp timest = (Timestamp)no.getValue();
                    c.setDayPeriod(new PeriodComplete(new Date(timest.getTime()), new Date(timest.getTime())));
                } else if (no.getValue() instanceof Date) {
                    Date timest = (Date)no.getValue();
                    c.setDayPeriod(new PeriodComplete(new Date(timest.getTime()), new Date(timest.getTime())));
                } else if (no.getValue() instanceof PeriodComplete) {
                    c.setDayPeriod(new PeriodComplete((Date)no.getChildNamed(PeriodComplete_.startDate).getValue(), (Date)no.getChildNamed(PeriodComplete_.endDate).getValue()));
                }
            }
            if (o.length >= 2 && o[1] instanceof Boolean) {
                c.setOnlyOpenFlights((Boolean)o[1]);
            }
        }
        c.setNumResults(((FlightSearchAlgorithm)this.searchAlgorithm).getNumberOfShownResults());
        return c;
    }
}

