/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.async;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ExceptionHandler;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeRun;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadSafeLoader {
    private static Logger log = LoggerFactory.getLogger(ThreadSafeLoader.class);
    private static Thread worker;
    private static LinkedList<ThreadSafeExecutable> queue;
    private static BlockingQueue<Runnable> rt;
    private static ThreadSafeExecutable currentExecutable;
    private static boolean isRunning;
    private static boolean isCancel;
    private static long animationMinTime;
    public static MainFrame mainFrame;
    protected static List<ThreadSafeRun> currentBackgrounds;
    private static ThreadPoolExecutor r;

    public static void runInBackground(ThreadSafeExecutable run) {
        ThreadSafeRun rr = new ThreadSafeRun(run);
        currentBackgrounds.add(rr);
        r.execute(rr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLoadingList() {
        LinkedList<ThreadSafeExecutable> linkedList = queue;
        synchronized (linkedList) {
            queue.clear();
        }
        if (isRunning) {
            isCancel = true;
        }
    }

    public static boolean isOperationFinished() {
        return queue.isEmpty() && currentExecutable == null;
    }

    public static boolean isBackgroundOperationFinished() {
        return currentBackgrounds.isEmpty();
    }

    public static void setAnimationMinTime(long minTime) {
        animationMinTime = minTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoadingGroupReady(long loadingGroup) {
        if (currentExecutable != null && currentExecutable.getID() == loadingGroup) {
            return false;
        }
        try {
            Iterator it = null;
            LinkedList<ThreadSafeExecutable> linkedList = queue;
            synchronized (linkedList) {
                it = ((LinkedList)queue.clone()).iterator();
            }
            while (it.hasNext()) {
                ThreadSafeExecutable r = (ThreadSafeExecutable)it.next();
                if (r.getID() != loadingGroup) continue;
                return false;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ExceptionHandler.getHandler().fireException(Thread.currentThread(), (Throwable)new ClientRemoteException((Throwable)e, "Somethig very very strange happend. This shouldn't be -> inserted synchronized into ensureWorker", null, new String[0]), false);
            return true;
        }
        return true;
    }

    private static synchronized void ensureWorker_single_thread() {
        if (worker == null) {
            worker = new Thread("Catit Workerthread"){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                ThreadSafeExecutable r = null;
                                r = (ThreadSafeExecutable)queue.poll();
                                if (r != null) {
                                    currentExecutable = r;
                                    ClientException error = null;
                                    Node<?> n = null;
                                    try {
                                        n = r.loadData();
                                    }
                                    catch (ClientException e) {
                                        error = e;
                                        if (e.getCause() != null) {
                                            e.getCause().printStackTrace();
                                        }
                                    }
                                    catch (Exception e) {
                                        error = new ClientException("", (Throwable)e);
                                        log.error("", (Throwable)e);
                                    }
                                    Node<?> node = n;
                                    ClientException err = error;
                                    currentExecutable = null;
                                    ThreadSafeExecutable rf = r;
                                    if (r.getInvoker() != null) {
                                        if (err != null) {
                                            log.error("Call from " + r.getCallingClass().getSimpleName() + " to errorOccurred in " + (r.getInvoker().getClass().getSimpleName().isEmpty() ? "anonymous inner Class" : r.getInvoker().getClass().getSimpleName()));
                                            SwingUtilities.invokeLater(() -> rf.getInvoker().errorOccurred(err));
                                        } else {
                                            log.debug("Call from " + r.getCallingClass().getSimpleName() + " to Remote Loader " + (r.getInvoker().getClass().getSimpleName().isEmpty() ? "anonymous Inner Class" : r.getInvoker().getClass().getSimpleName()));
                                            SwingUtilities.invokeLater(() -> rf.getInvoker().remoteObjectLoaded(node));
                                        }
                                    }
                                    if (err != null && r.getInvoker() == null) {
                                        log.error("Call from " + r.getCallingClass().getSimpleName() + "but no invoker is set ");
                                    }
                                }
                                Thread.yield();
                            }
                        }
                        catch (NoSuchElementException e) {
                            log.error("", (Throwable)e);
                            SwingUtilities.invokeLater(() -> InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Unexpected ERROR!!! Please restart CATIT.")}), "", (Component)mainFrame));
                            continue;
                        }
                        break;
                    }
                }
            };
            worker.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)ExceptionHandler.getHandler());
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)ExceptionHandler.getHandler());
            worker.start();
        }
    }

    private static synchronized void ensureWorker_create_new_thread_at_time() {
        if (worker == null) {
            worker = new Thread("Catit Workerthread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    isRunning = true;
                    try {
                        boolean goOn = false;
                        LinkedList linkedList = queue;
                        // MONITORENTER : linkedList
                        goOn = !queue.isEmpty();
                        // MONITOREXIT : linkedList
                        while (goOn) {
                            ThreadSafeExecutable r = null;
                            LinkedList linkedList2 = queue;
                            // MONITORENTER : linkedList2
                            r = (ThreadSafeExecutable)queue.poll();
                            // MONITOREXIT : linkedList2
                            if (r != null) {
                                currentExecutable = r;
                                ClientException error = null;
                                Node<?> n = null;
                                try {
                                    n = r.loadData();
                                }
                                catch (ClientException e) {
                                    error = e;
                                    if (e.getCause() != null) {
                                        e.getCause().printStackTrace();
                                    }
                                }
                                catch (Exception e) {
                                    error = new ClientException("", (Throwable)e);
                                    log.error("", (Throwable)e);
                                }
                                Node<?> node = n;
                                ClientException err = error;
                                currentExecutable = null;
                                ThreadSafeExecutable rf = r;
                                if (r.getInvoker() != null) {
                                    if (err != null) {
                                        log.debug("Call from " + r.getCallingClass().getSimpleName() + " to errorOccurred in " + (r.getInvoker().getClass().getSimpleName().isEmpty() ? "anonymous inner Class" : r.getInvoker().getClass().getSimpleName()));
                                        SwingUtilities.invokeLater(() -> rf.getInvoker().errorOccurred(err));
                                    } else {
                                        log.debug("Call from " + r.getCallingClass().getSimpleName() + " to Remote Loader " + (r.getInvoker().getClass().getSimpleName().isEmpty() ? "anonymous Inner Class" : r.getInvoker().getClass().getSimpleName()));
                                        SwingUtilities.invokeLater(() -> {
                                            try {
                                                rf.getInvoker().remoteObjectLoaded(node);
                                            }
                                            catch (Exception e) {
                                                log.error("", (Throwable)e);
                                            }
                                        });
                                    }
                                }
                                if (err != null && r.getInvoker() == null) {
                                    log.debug("Call from " + r.getCallingClass().getSimpleName() + "but no invoker is set ");
                                }
                            }
                            Thread.yield();
                            linkedList2 = queue;
                            // MONITORENTER : linkedList2
                            goOn = !queue.isEmpty();
                            // MONITOREXIT : linkedList2
                        }
                    }
                    catch (NoSuchElementException e) {
                        log.error("", (Throwable)e);
                        SwingUtilities.invokeLater(() -> InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Unexpected ERROR!!! Please restart CATIT.")}), "", (Component)mainFrame));
                    }
                    worker = null;
                    isRunning = false;
                }
            };
            worker.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)ExceptionHandler.getHandler());
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)ExceptionHandler.getHandler());
            worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(ThreadSafeExecutable run) {
        LinkedList<ThreadSafeExecutable> linkedList = queue;
        synchronized (linkedList) {
            queue.add(0, run);
        }
        ThreadSafeLoader.ensureWorker_create_new_thread_at_time();
    }

    static {
        queue = new LinkedList();
        rt = new ArrayBlockingQueue<Runnable>(10);
        currentBackgrounds = new ArrayList<ThreadSafeRun>();
        r = new ThreadPoolExecutor(3, 10, 5L, TimeUnit.SECONDS, rt);
    }
}

