/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.loaders;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;

public class InventoryLoader
extends ThreadSafeExecutable {
    private InventoryLight inventoryL;
    private RemoteLoader loader;
    private Node cn;

    public InventoryLoader(InventoryLight inventoryL, RemoteLoader loader, Node cn, Object caller) {
        super(caller);
        this.inventoryL = inventoryL;
        this.loader = loader;
        this.cn = cn;
        ThreadSafeLoader.run(this);
    }

    @Override
    public Node<?> loadData() throws Exception {
        try {
            if (this.cn.getValue(InventoryComplete.class) == null) {
                InventoryComplete a = InventoryLoader.loadInventory(this.inventoryL);
                this.cn.setValue((Object)a, 0L);
            }
            return this.cn;
        }
        catch (ClientGetFromServerException e) {
            ViewNode r = new ViewNode("Error");
            r.setValue((Object)e, 0L);
            return r;
        }
    }

    @Override
    public RemoteLoader getInvoker() {
        return this.loader;
    }

    @Override
    public long getID() {
        return 0L;
    }

    public static InventoryComplete loadInventory(InventoryLight l) throws ClientServerCallException {
        return (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).get(new InventoryReference(l.getId())).getValue();
    }
}

