/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.loaders;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.recipe.RecipeServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantReference;

public class RecipeVariantLoader
extends ThreadSafeExecutable {
    private RecipeVariantReference artL;
    private RemoteLoader loader;
    private Node cn;

    public RecipeVariantLoader(RecipeVariantReference artL, RemoteLoader loader, Node cn, Object caller) {
        super(caller);
        this.artL = artL;
        this.loader = loader;
        this.cn = cn;
        ThreadSafeLoader.run(this);
    }

    @Override
    public Node<?> loadData() throws Exception {
        try {
            RecipeVariantComplete a = RecipeVariantLoader.loadRecipe(this.artL);
            this.cn.setValue((Object)a, 0L);
            return this.cn;
        }
        catch (ClientGetFromServerException e) {
            ViewNode r = new ViewNode("Error");
            r.setValue((Object)e, 0L);
            return r;
        }
    }

    @Override
    public RemoteLoader getInvoker() {
        return this.loader;
    }

    @Override
    public long getID() {
        return 0L;
    }

    public static RecipeVariantComplete loadRecipe(RecipeVariantReference l) throws ClientServerCallException {
        RecipeVariantComplete recipeVariant = (RecipeVariantComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipeVariant(new RecipeVariantReference(l.getId())).getValue();
        if (recipeVariant.getRecipeId() != null && recipeVariant.getRecipe() == null) {
            RecipeComplete recipe = (RecipeComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipe(new RecipeReference(recipeVariant.getRecipeId())).getValue();
            recipeVariant.setRecipe(recipe);
        }
        return recipeVariant;
    }
}

