/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.GalleyComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.StowagePositionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.StowagePositionSpecificationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AlternativeStowagePositionTypePlacementComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentSystemComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StowagePositionTypeAlternativeConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StowagePositionTypeComplete;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;

public class AircraftToolkit {
    public static Node<StowagePositionSpecificationComplete> getNewStowagePosition(GalleyEquipmentSystemComplete system, Node<StowagePositionTypeComplete> orginal, GalleyEquipmentTypeComplete defaultType) {
        StowagePositionSpecificationComplete conf = new StowagePositionSpecificationComplete();
        conf.setClientOId(Long.valueOf(ADTO.getNextId()));
        StowagePositionComplete pos = new StowagePositionComplete();
        pos.setEquipmentSystem(system);
        pos.setClientOId(Long.valueOf(ADTO.getNextId()));
        pos.setDefaultGalleyEquipmentType(defaultType);
        pos.setType((StowagePositionTypeComplete)orginal.getValue());
        ArrayList<StowagePositionComplete> defaults = new ArrayList<StowagePositionComplete>();
        defaults.add(pos);
        conf.setDefaultPositions(defaults);
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)conf, false, false);
    }

    public static List<ScreenValidationObject> validateAircraft(AircraftComplete dto) {
        ArrayList<ScreenValidationObject> errors = new ArrayList<ScreenValidationObject>();
        for (GalleyComplete galley : dto.getGalleys()) {
            Area a = new Area();
            for (StowagePositionSpecificationComplete specs : galley.getStowagePositionSpecifications()) {
                for (StowagePositionComplete pos : specs.getDefaultPositions()) {
                    double x = 0.0;
                    double y = 0.0;
                    double w = 0.0;
                    double h = 0.0;
                    if (pos.getLocation() != null) {
                        x = pos.getLocation().getX();
                        y = pos.getLocation().getY();
                    }
                    if (pos.getDimension() != null) {
                        w = pos.getDimension().getWidth();
                        h = pos.getDimension().getHeight();
                    } else if (pos.getType().getSize() != null) {
                        w = pos.getType().getSize().getWidth();
                        h = pos.getType().getSize().getHeight();
                    }
                    Rectangle r = new Rectangle((int)(x *= 2.0), (int)(y *= 2.0), (int)(w *= 2.0), (int)(h *= 2.0));
                    if (a.intersects(x, y, w, h)) {
                        errors.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Position " + pos.getCode() + " is overlapping!"));
                    }
                    a.add(new Area(r));
                }
            }
        }
        return errors;
    }

    public static void splitStowagePosition(Node<StowagePositionSpecificationComplete> node, String frontName, GalleyEquipmentTypeComplete frontType, String rearName, GalleyEquipmentTypeComplete rearType) {
        if (!(node.getValue() instanceof StowagePositionSpecificationComplete)) {
            node = node.getParent().getParent();
        }
        Node sPos = node.getChildNamed(new String[]{"defaultPositions"}).getChildAt(0);
        Node altTypes = sPos.getChildNamed(new String[]{"type-alternatives"});
        if (altTypes.getChildCount() > 0) {
            Node alt = sPos.getParent().getParent().getChildNamed(new String[]{"alternativePositions"});
            Node pos = sPos.getParent().getParent().getChildNamed(new String[]{"defaultPositions"}).getChildAt(0);
            long id = System.currentTimeMillis();
            Node n = altTypes.getChildAt(0);
            StowagePositionComplete pos1 = new StowagePositionComplete();
            pos1.setCode(frontName);
            pos1.setEquipmentSystem((GalleyEquipmentSystemComplete)pos.getChildNamed(new String[]{"equipmentSystem"}).getValue());
            pos1.setClientOId(Long.valueOf(ADTO.getNextId()));
            pos1.setType(((AlternativeStowagePositionTypePlacementComplete)((StowagePositionTypeAlternativeConfigurationComplete)n.getValue()).getPlacedTypes().get(0)).getStowagePositionType());
            pos1.setDefaultGalleyEquipmentType(frontType);
            double xPos = (Double)pos.getChildNamed(new String[]{"location-x"}).getValue();
            double yPos = (Double)pos.getChildNamed(new String[]{"location-y"}).getValue();
            pos1.getLocation().setX(Double.valueOf(xPos));
            pos1.getLocation().setY(Double.valueOf(yPos));
            pos1.getLocation().setZ(((AlternativeStowagePositionTypePlacementComplete)((StowagePositionTypeAlternativeConfigurationComplete)n.getValue()).getPlacedTypes().get(0)).getLocation().getZ());
            StowagePositionComplete pos2 = new StowagePositionComplete();
            pos2.setClientOId(Long.valueOf(ADTO.getNextId()));
            pos2.setEquipmentSystem((GalleyEquipmentSystemComplete)pos.getChildNamed(new String[]{"equipmentSystem"}).getValue());
            pos2.setCode(rearName);
            pos2.setType(((AlternativeStowagePositionTypePlacementComplete)((StowagePositionTypeAlternativeConfigurationComplete)n.getValue()).getPlacedTypes().get(1)).getStowagePositionType());
            pos2.setDefaultGalleyEquipmentType(rearType);
            pos2.getLocation().setX(Double.valueOf(xPos));
            pos2.getLocation().setY(Double.valueOf(yPos));
            pos2.getLocation().setZ(((AlternativeStowagePositionTypePlacementComplete)((StowagePositionTypeAlternativeConfigurationComplete)n.getValue()).getPlacedTypes().get(1)).getLocation().getZ());
            Node posA = INodeCreator.getDefaultImpl().getNode4DTO((Object)pos1, true, false);
            alt.addChildSilent(posA, null, true, id);
            Node posB = INodeCreator.getDefaultImpl().getNode4DTO((Object)pos2, true, false);
            alt.addChild(posB, id);
        }
    }
}

