/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.converter.ArticleCategoryConverter;
import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter0Decimals;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter1Decimals;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter2Decimals;
import ch.icit.pegasus.client.converter.FormulaConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.QuantityConverter0Decimal;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.utils.StepPriceComparator;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.log.FieldMutationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderMoveComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPreparationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderRejectionComplete;
import ch.icit.pegasus.server.core.dtos.recipe.AllergenDeclarationComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticleHalalCertificationComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractEntryComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReturnsRateComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionTypeE;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.Component;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class ArticleToolkit {
    public static final int SUPPLIER_CONDITIONS = 3;
    public static final int STORE_CONDITIONS = 5;
    public static final int PRICE = 7;
    public static final int PACKAGING_TABLE = 11;
    public static final int CATEGORY = 13;
    public static final int ORDER_INTERVAL = 17;
    public static final int DELIVERY_TIME = 19;
    public static final int ARTICLE_YIELD = 23;
    public static final int USAGE_COMMENT = 29;
    public static final int CHARGES = 31;

    public static boolean isHAACPRelevant(BasicArticleLight article) {
        return ArticleToolkit.isArticleAllergenRelevant(article);
    }

    public static boolean isChilledArticle(BasicArticleLight article) {
        if (article == null) {
            return false;
        }
        return Boolean.TRUE.equals(article.getChilled());
    }

    public static boolean isFrozenArticle(BasicArticleLight article) {
        if (article == null) {
            return false;
        }
        return Boolean.TRUE.equals(article.getFrozen());
    }

    public static boolean isTemperatureCheck(BasicArticleLight article) {
        if (ArticleToolkit.isChilledArticle(article)) {
            return true;
        }
        return ArticleToolkit.isFrozenArticle(article);
    }

    public static ArticleHalalCertificationComplete getHalalCertification(BasicArticleComplete article, Timestamp validity) {
        for (ArticleHalalCertificationComplete halalCertification : article.getHalalCertifications()) {
            if (!halalCertification.getValidity().within(new Date(validity.getTime())).booleanValue()) continue;
            return halalCertification;
        }
        return null;
    }

    private static String ensureGMCValidity(String gmcCode) {
        String gmc = gmcCode;
        if (gmc == null) {
            gmc = "";
        }
        while (gmc.length() < 8) {
            gmc = gmc + "0";
        }
        while (gmc.length() > 8) {
            gmc = gmc.substring(0, gmc.length() - 1);
        }
        return gmc;
    }

    public static String getAllergenNotApprovedTextDescription() {
        return "Text is shown on Allergen Info Sheet if Article/Group/Product is not approved.<br/><ul><li>any Text</li><li>{a} = show all Allergens</li></ul>";
    }

    public static boolean isArticleAllergenRelevant(BasicArticleLight article) {
        for (ArticleCategoryLight cat = article.getCategory(); cat != null; cat = cat.getParent()) {
            if (!cat.getAllergenSheetRelevant().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static List<Node<UnitComplete>> getSelectableUnitsForArticle(Node<BasicArticleComplete> node) {
        Node variants;
        ArrayList<Node<UnitComplete>> prodList = new ArrayList<Node<UnitComplete>>();
        Node<BasicArticleComplete> article = node;
        if (article.getValue(BasicArticleComplete.class) != null && (variants = article.getChildNamed(BasicArticleComplete_.packingQuantitiesVariants)).getChildCount() > 0) {
            for (Node pak = variants.getChildAt(0).getChildNamed(PackagingQuantityBaseComplete_.packingQuantities).getChildAt(0); pak != null && pak.getValue() != null; pak = pak.getChildNamed(new String[]{"convertedQuantity"})) {
                Node unit = pak.getChildNamed(new String[]{"unit"});
                List<Node<UnitComplete>> list = UnitToolkit.generateUnitView((Node<UnitComplete>)unit, null, null, true);
                prodList.addAll(list);
            }
        }
        return prodList;
    }

    public static String getCustomsTariff(BasicArticleComplete article, ArticleCategoryLight category) {
        if (Boolean.TRUE.equals(article.getUseCustomsData())) {
            return article.getCustomsTariff();
        }
        while (category != null) {
            if (Boolean.TRUE.equals(category.getUseCustomsData())) {
                return category.getCustomsTariff();
            }
            category = category.getParent();
        }
        return null;
    }

    public static String getCustomsNumber(BasicArticleComplete article, ArticleCategoryLight category) {
        if (Boolean.TRUE.equals(article.getUseCustomsData())) {
            return article.getCustomsNumber();
        }
        while (category != null) {
            if (Boolean.TRUE.equals(category.getUseCustomsData())) {
                return category.getCustomsNumber();
            }
            category = category.getParent();
        }
        return null;
    }

    public static String getCustomsAdditionalEntry(BasicArticleComplete article, ArticleCategoryLight category) {
        if (Boolean.TRUE.equals(article.getUseCustomsData())) {
            return article.getCustomsAdditionalEntry();
        }
        while (category != null) {
            if (Boolean.TRUE.equals(category.getUseCustomsData())) {
                return category.getCustomsAdditionalEntry();
            }
            category = category.getParent();
        }
        return null;
    }

    public static String createPackingString(BasicArticleComplete article, SupplierLight s, Boolean useTaxZone, TaxZoneComplete taxZone, Timestamp validityDate) {
        List packagingQuantity = null;
        if (article.getSuppliers() != null && article.getSupplier((SupplierReference)s) != null) {
            List scccList = article.getSupplier((SupplierReference)s).getSupplierConditionCategory();
            for (SupplierConditionCategoryComplete sccc : scccList) {
                for (SupplierConditionComplete c : sccc.getConditions()) {
                    if (!Boolean.TRUE.equals(c.getUsePackingQuantity()) || c.getValidity().getStartDate().getTime() > validityDate.getTime() || c.getValidity().getEndDate().getTime() < validityDate.getTime() || !ArticleToolkit.isTaxZone(c.getCategoryTaxZone(), useTaxZone, taxZone)) continue;
                    packagingQuantity = c.getPackingQuantities();
                }
            }
        }
        String t = ArticleToolkit.getArticleInfoPopupString(article, validityDate, 11, true, null, packagingQuantity);
        return t;
    }

    private static boolean isTaxZone(TaxZoneComplete categoryTaxZone, Boolean useTaxZone, TaxZoneComplete tz) {
        TaxZoneComplete taxZone = null;
        if (useTaxZone != null && useTaxZone.booleanValue()) {
            taxZone = tz;
        }
        return categoryTaxZone == null && taxZone == null || categoryTaxZone != null && categoryTaxZone.equals((Object)taxZone);
    }

    public static SupplierConditionComplete getCheapestSupplier(BasicArticleComplete ac, Node<UnitComplete> unit, Node<Object> amount, Boolean useTaxZoneMatch, TaxZoneComplete taxZone, SystemSettingsComplete settings, Component invoker, CurrencyVariantAccessor accessor, Timestamp validityDate) {
        SupplierConditionComplete cscc = null;
        PriceComplete cp = null;
        if (ac == null) {
            return null;
        }
        for (SupplierConditionBaseComplete base : ac.getSuppliers()) {
            for (SupplierConditionCategoryComplete category : base.getSupplierConditionCategory()) {
                boolean taxZoneOk = false;
                if (Boolean.TRUE.equals(useTaxZoneMatch)) {
                    if (taxZone != null && taxZone.equals((Object)category.getTaxZone())) {
                        taxZoneOk = true;
                    }
                    if (taxZone == null && category.getTaxZone() == null) {
                        taxZoneOk = true;
                    }
                } else {
                    taxZoneOk = true;
                }
                if (!taxZoneOk) continue;
                for (SupplierConditionComplete c : category.getConditions()) {
                    double od;
                    if (c.getValidity().getStartDate().getTime() > validityDate.getTime() || c.getValidity().getEndDate().getTime() < validityDate.getTime()) continue;
                    if (unit == null || amount == null || c == null) {
                        return null;
                    }
                    if (cscc == null) {
                        cscc = c;
                        cp = ArticleToolkit.getArticlePrice(ac, unit, amount, (SupplierReference)c.getSupplier(), useTaxZoneMatch, category.getTaxZone(), settings, validityDate);
                        if (cp != null) {
                            if (cp.getCurrency() != null) {
                                try {
                                    CurrencyVariantComplete cv = (CurrencyVariantComplete)accessor.loadData((Object)cp.getCurrency(), validityDate);
                                    cp.setPrice(Double.valueOf(cp.getPrice() * cv.getExchangeRate()));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            cp.setCurrency(settings.getCurrency());
                            continue;
                        }
                        InnerPopupFactory.showErrorDialog("Supplier Price for Article " + ac.getNumber() + " - " + ac.getName() + " not found", invoker);
                        continue;
                    }
                    if (c == null) continue;
                    PriceComplete pp = ArticleToolkit.getArticlePrice(ac, unit, amount, (SupplierReference)c.getSupplier(), useTaxZoneMatch, taxZone, settings, validityDate);
                    double d = 0.0;
                    if (pp != null && pp.getPrice() != null && pp.getCurrency() != null) {
                        try {
                            CurrencyVariantComplete cv = (CurrencyVariantComplete)accessor.loadData((Object)pp.getCurrency(), validityDate);
                            d = pp.getPrice() * cv.getExchangeRate();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if ((od = cp.getPrice().doubleValue()) == 0.0) {
                        if (d == 0.0) continue;
                        cscc = c;
                        cp = pp;
                        cp.setPrice(Double.valueOf(d));
                        cp.setCurrency(settings.getCurrency());
                        continue;
                    }
                    if (d == 0.0 || !(d < od)) continue;
                    cscc = c;
                    cp = pp;
                    cp.setPrice(Double.valueOf(d));
                    cp.setCurrency(settings.getCurrency());
                }
            }
        }
        return cscc;
    }

    public static String getArticleInfoPopupString(BasicArticleComplete article, List<ArticleChargeBatchComplete> batches, int magicNr) {
        return ArticleToolkit.getArticleInfoPopupString(article, null, magicNr, true, null, false, null, batches);
    }

    public static String getArticleInfoPopupString(BasicArticleComplete article, Timestamp validityDate, int magicNr, List<PackagingQuantityComplete> packagingQuantity) {
        return ArticleToolkit.getArticleInfoPopupString(article, validityDate, magicNr, true, packagingQuantity);
    }

    public static String getArticleInfoPopupString(BasicArticleComplete article, Timestamp validityDate, int magicNr) {
        return ArticleToolkit.getArticleInfoPopupString(article, validityDate, magicNr, null);
    }

    public static String getArticleInfoPopupString(BasicArticleComplete article, Timestamp validityDate, int magicNr, boolean showArticleNo, List<PackagingQuantityComplete> packagingQuantity) {
        return ArticleToolkit.getArticleInfoPopupString(article, validityDate, magicNr, showArticleNo, (SupplierReference)null, packagingQuantity);
    }

    public static String getArticleInfoPopupString(BasicArticleComplete article, Timestamp validityDate, int magicNr, boolean showArticleNo) {
        return ArticleToolkit.getArticleInfoPopupString(article, validityDate, magicNr, showArticleNo, (List<PackagingQuantityComplete>)null);
    }

    public static String getArticleInfoPopupString(BasicArticleComplete article, Timestamp validityDate, int magicNr, boolean showArticleNo, SupplierReference supplier, List<PackagingQuantityComplete> packagingQuantity) {
        return ArticleToolkit.getArticleInfoPopupString(article, validityDate, magicNr, showArticleNo, supplier, false, packagingQuantity, null);
    }

    public static String getArticleInfoPopupString(BasicArticleComplete article, Timestamp validityDate, int magicNr, boolean showArticleNo, SupplierReference supplier) {
        return ArticleToolkit.getArticleInfoPopupString(article, validityDate, magicNr, showArticleNo, supplier, null);
    }

    public static String getArticleInfoPopupString(BasicArticleComplete article, Timestamp validityDate, int magicNr, boolean showArticleNo, SupplierReference supplier, boolean withTitle) {
        return ArticleToolkit.getArticleInfoPopupString(article, validityDate, magicNr, showArticleNo, supplier, withTitle, null, null);
    }

    public static String getArticleInfoPopupString(BasicArticleComplete article, Timestamp validityDate, int magicNr, boolean showArticleNo, SupplierReference supplier, boolean withTitle, List<PackagingQuantityComplete> packagingQuantity, List<ArticleChargeBatchComplete> batches) {
        String t;
        Timestamp validity;
        Converter category;
        String catText;
        Converter c3;
        Converter conv;
        Object tlop;
        String text = "";
        if (article == null) {
            return "Article not set";
        }
        if (withTitle && (tlop = (String)(conv = ConverterRegistry.getConverter(BasicArticleConverter.class)).convert((Object)article, null, new Object[0])) != null && !((String)tlop).isEmpty()) {
            text = text + "<b>" + (String)tlop + "</b><br/><hr/><br/>";
        }
        if (magicNr % 3 == 0) {
            text = text + "<b>" + Words.SUPPLIER + "</b> ";
            text = text + "<ul>";
            Iterator lastOne = null;
            for (SupplierConditionBaseComplete base : article.getSuppliers()) {
                if (supplier != null && !supplier.equals((Object)base.getSupplier())) continue;
                for (SupplierConditionCategoryComplete category2 : base.getSupplierConditionCategory()) {
                    Collections.sort(category2.getConditions());
                    for (SupplierConditionComplete c2 : category2.getConditions()) {
                        if (c2.getValidity().getStartDate().getTime() > validityDate.getTime() || c2.getValidity().getEndDate().getTime() < validityDate.getTime()) continue;
                        text = text + "<li>";
                        String supplierText = c2.getArticleNumber() != null ? c2.getArticleNumber() : "";
                        supplierText = supplierText + (Boolean.TRUE.equals(c2.getCategoryTaxZone() != null) ? ", " + c2.getCategoryTaxZone().getCode() : "");
                        supplierText = supplierText + (c2.getCategoryComment() != null && c2.getCategoryComment().isEmpty() ? ", " + c2.getCategoryComment() : "");
                        text = showArticleNo ? text + c2.getSupplier().getName() + " (" + supplierText + ")" : text + c2.getSupplier().getName();
                        if (c2.getStepPrice() != null) {
                            text = text + "<br/>";
                            Collections.sort(c2.getStepPrice().getSteps(), (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
                            Iterator it = c2.getStepPrice().getSteps().iterator();
                            boolean first = true;
                            while (it.hasNext()) {
                                StepPriceFunctionComplete s = (StepPriceFunctionComplete)it.next();
                                PriceConverter1 cc = (PriceConverter1)ConverterRegistry.getConverter(PriceConverter1.class);
                                QuantityConverter0Decimal qcd = (QuantityConverter0Decimal)ConverterRegistry.getConverter(QuantityConverter0Decimal.class);
                                String prefix = "to ";
                                if (!first) {
                                    text = text + "<br>";
                                } else {
                                    first = false;
                                }
                                String t2 = qcd.convert((Object)s.getUpperLimit(), null, new Object[0]);
                                if (!it.hasNext()) {
                                    t2 = "\u221e ";
                                }
                                text = text + prefix + t2 + " - " + cc.convert(s.getPrice(), null, new Object[0]) + "/" + article.getPriceUnit().getShortName();
                            }
                            if (Boolean.TRUE.equals(article.getMarkedAsContracted())) {
                                text = text + "<br/>!<i> Step Prices can differ from Contract Prices </i>!";
                            }
                        } else {
                            PriceConverter1 cc = (PriceConverter1)ConverterRegistry.getConverter(PriceConverter1.class);
                            text = text + "<br>" + cc.convert(((StepPriceFunctionComplete)c2.getStepPrice().getSteps().get(0)).getPrice(), null, new Object[0]) + "/" + c2.getOrderUnit().getShortName();
                        }
                        text = text + "</li>";
                    }
                }
            }
            text = text + "</ul>";
        }
        if (magicNr % 5 == 0) {
            text = text + "<b>" + Words.STORES + "</b> ";
            text = text + "<ul>";
            for (Converter c3 : article.getStoreConditions()) {
                if (c3.getPosition() == null) continue;
                if (c3.getPosition().getStore() != null) {
                    text = text + "<li>" + c3.getPosition().getStore().getName() + "</li>";
                    continue;
                }
                text = text + "<li>" + c3.getPosition().getStoreName() + "</li>";
            }
            text = text + "</ul>";
        }
        if (magicNr % 11 == 0) {
            if (packagingQuantity == null) {
                ArrayList packingQuantitiesVariants = new ArrayList(article.getPackingQuantitiesVariants());
                Collections.sort(packingQuantitiesVariants);
                Converter conv0 = ConverterRegistry.getConverter(FormattedDoubleConverter0Decimals.class);
                Converter conv1 = ConverterRegistry.getConverter(FormattedDoubleConverter1Decimals.class);
                Converter conv2 = ConverterRegistry.getConverter(FormattedDoubleConverter2Decimals.class);
                ArrayList selectedConversion = new ArrayList();
                for (PackagingQuantityBaseComplete conversion : packingQuantitiesVariants) {
                    if (!conversion.getValidityPeriod().within(new Date(validityDate.getTime())).booleanValue()) continue;
                    selectedConversion.addAll(conversion.getPackingQuantities());
                }
                text = text + "<b>" + Words.CONVERSION + "</b>";
                text = text + "<ul><li>";
                Collections.sort(selectedConversion);
                Object retString = "";
                double amount = 1.0;
                int currentNumber = -1;
                for (PackagingQuantityComplete conversion : selectedConversion) {
                    int dd = conversion.getAmount();
                    currentNumber = ArticleToolkit.getMaxNumbers("" + dd, currentNumber);
                    Object con = null;
                    if (currentNumber == -1 || currentNumber == 0) {
                        con = conv0;
                    } else if (currentNumber == 1) {
                        con = conv1;
                    } else if (currentNumber >= 2) {
                        con = conv2;
                    }
                    double d = (amount *= (double)dd) % 1.0;
                    String fr = (String)con.convert((Object)amount, null, new Object[0]);
                    retString = (String)retString + fr + " " + conversion.getUnit().getShortName() + " = ";
                }
                if (!StringUtil.isBlank((String)retString)) {
                    retString = ((String)retString).substring(0, ((String)retString).length() - 3);
                }
                text = text + (String)retString;
                text = text + "</li></ul>";
            } else {
                List<PackagingQuantityComplete> synchronizedPackagingQuantities = packagingQuantity;
                Collections.sort(synchronizedPackagingQuantities);
                Converter formulaConverter = ConverterRegistry.getConverter(FormulaConverter.class);
                Collections.sort(synchronizedPackagingQuantities);
                Node packN = INodeCreator.getDefaultImpl().createNodes(synchronizedPackagingQuantities, false, false);
                text = text + "<b>" + Words.CONVERSION + "</b>";
                text = text + "<ul><li>";
                text = text + formulaConverter.convert(null, packN, new Object[0]);
                text = text + "</li></ul>";
            }
        }
        if (magicNr % 29 == 0 && article.getUsageComment() != null) {
            text = text + "<b>Usage Comment</b>";
            text = text + "<ul><li>";
            text = text + article.getUsageComment();
            text = text + "</li></ul>";
        }
        if (magicNr % 23 == 0) {
            Converter dc = ConverterRegistry.getConverter(FormattedDoubleConverter2Decimals.class);
            text = ArticleToolkit.insertWastePart(article, true, text, dc);
            text = ArticleToolkit.insertWastePart(article, false, text, dc);
            if (article.getUseArticleReturnsRate().booleanValue()) {
                text = text + "<b>Waste</b>";
                text = text + "<li>";
                text = text + "Return Rate: ";
                text = text + dc.convert((Object)article.getReturnsRate(), null, new Object[0]) + "%";
                for (BasicArticleReturnsRateComplete crr : article.getCustomerReturnsRate()) {
                    text = text + ", " + crr.getCustomer().getCode() + " = " + dc.convert((Object)crr.getReturnsRate(), null, new Object[0]) + "%";
                }
                text = text + "</li>";
                text = text + "</ul>";
            }
        }
        if (magicNr % 13 == 0 && (catText = (String)(category = ConverterRegistry.getConverter(ArticleCategoryConverter.class)).convert((Object)article.getCategory(), null, new Object[0])) != null && !catText.equals("")) {
            text = text + "<b>" + Words.CATEGORY + "</b>";
            text = text + "<ul><li>" + catText + "</li></ul>";
        }
        if (magicNr % 17 == 0) {
            validity = new Timestamp(System.currentTimeMillis());
            c3 = ConverterRegistry.getConverter(FormattedDoubleConverter2Decimals.class);
            t = "<b>Min Order Intervals</b><ul>";
            for (SupplierConditionBaseComplete base : article.getSuppliers()) {
                if (supplier != null && !base.getSupplier().equals((Object)supplier)) continue;
                for (SupplierConditionCategoryComplete category3 : base.getSupplierConditionCategory()) {
                    ArrayList conditions = new ArrayList(category3.getConditions());
                    Collections.sort(conditions);
                    Iterator currentNumber = conditions.iterator();
                    while (currentNumber.hasNext()) {
                        SupplierConditionComplete conditionComplete = (SupplierConditionComplete)currentNumber.next();
                        if (conditionComplete.getValidity().getStartDate().getTime() <= validity.getTime() && conditionComplete.getValidity().getEndDate().getTime() >= validity.getTime()) {
                            String supplierText = conditionComplete.getArticleNumber() != null ? conditionComplete.getArticleNumber() : "";
                            supplierText = supplierText + (Boolean.TRUE.equals(conditionComplete.getCategoryTaxZone() != null) ? ", " + conditionComplete.getCategoryTaxZone().getCode() : "");
                            supplierText = supplierText + (conditionComplete.getCategoryComment() != null && conditionComplete.getCategoryComment().isEmpty() ? ", " + conditionComplete.getCategoryComment() : "");
                            t = supplier == null ? t + "<li>" + conditionComplete.getSupplier().getName() + " " : t + "<li>";
                            t = t + (String)c3.convert((Object)conditionComplete.getMinOrderAmount(), null, new Object[0]);
                            t = t + " " + conditionComplete.getOrderUnit().getShortName();
                            t = t + " (" + supplierText + ")</li>";
                        }
                        t = t + (String)c3.convert((Object)conditionComplete.getMinOrderAmount(), null, new Object[0]);
                        UnitComplete unit = conditionComplete.getMinOrderAmountUnit() != null ? conditionComplete.getMinOrderAmountUnit() : conditionComplete.getOrderUnit();
                        t = t + " " + unit.getShortName() + "</li>";
                    }
                }
            }
            t = t + "</ul>";
            text = text + t;
        }
        if (magicNr % 19 == 0) {
            validity = new Timestamp(System.currentTimeMillis());
            c3 = ConverterRegistry.getConverter(FormattedDoubleConverter2Decimals.class);
            t = "<ul>";
            for (SupplierConditionBaseComplete base : article.getSuppliers()) {
                if (supplier != null && !base.getSupplier().equals((Object)supplier)) continue;
                for (SupplierConditionCategoryComplete category4 : base.getSupplierConditionCategory()) {
                    try {
                        Collections.sort(category4.getConditions());
                        for (SupplierConditionComplete condition : category4.getConditions()) {
                            if (condition.getValidity().getStartDate().getTime() > validity.getTime() || condition.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                            String supplierText = condition.getArticleNumber() != null ? condition.getArticleNumber() : "";
                            supplierText = supplierText + (Boolean.TRUE.equals(condition.getCategoryTaxZone() != null) ? ", " + condition.getCategoryTaxZone().getCode() : "");
                            supplierText = supplierText + (condition.getCategoryComment() != null && condition.getCategoryComment().isEmpty() ? ", " + condition.getCategoryComment() : "");
                            t = supplier == null ? t + "<li>" + condition.getSupplier().getName() + ": " : t + "<li>";
                            t = condition.getDeliveryTime() == null ? t + " 0 Days" : t + condition.getDeliveryTime().toString() + " Days";
                            t = t + " (" + supplierText + ")</li>";
                        }
                    }
                    catch (Exception conditions) {
                    }
                }
            }
            t = t + "</ul>";
            text = text + "<b>Delivery Time</b>" + t;
        }
        if (magicNr % 7 == 0) {
            Converter priceConverter = ConverterRegistry.getConverter(PriceConverter1.class);
            PriceComplete p2 = ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)article, (Timestamp)new Timestamp(System.currentTimeMillis()), null, (boolean)false);
            UnitConverter uc = (UnitConverter)ConverterRegistry.getConverter(UnitConverter.class);
            text = text + "<b>" + Words.STANDARD_PRICE + " (productive)</b>";
            text = text + "<ul><li>" + priceConverter.convert((Object)p2, null, new Object[0]) + " / " + uc.convert(article.getPriceUnit(), null, new Object[0]) + "</li>";
            text = Boolean.TRUE.equals(article.getCustomerIsOwner()) ? text + "<li>Customer owned Articles always has a 0 price</li></ul>" : text + "</ul>";
        }
        if (magicNr % 31 == 0) {
            Iterator<ArticleChargeBatchComplete> iterator = batches.iterator();
            LinkedHashSet<String> batchesConversions = new LinkedHashSet<String>();
            for (ArticleChargeBatchComplete batch : batches) {
                List packingQuantities = batch.getCharge().getPackingQuantities();
                Converter formulaConverter = ConverterRegistry.getConverter(FormulaConverter.class);
                Node packN = INodeCreator.getDefaultImpl().createNodes(packingQuantities, false, false);
                String conversion = formulaConverter.convert(null, packN, new Object[0]).toString();
                batchesConversions.add(conversion);
            }
            Iterator it = batchesConversions.iterator();
            text = text + "<b>" + Words.CONVERSION + "</b>";
            while (it.hasNext()) {
                String conversion = (String)it.next();
                text = text + "<ul><li>";
                text = text + conversion;
                text = text + "</li></ul>";
            }
        }
        return text;
    }

    public static String insertWastePart(BasicArticleComplete article, boolean tender, String text, Converter dc) {
        text = text + "<b>Waste" + (tender ? " (Tender)" : "") + "</b>";
        text = text + "<ul><li>";
        text = text + "Purchase ";
        text = tender ? (article.getUseTenderPurchaseWaste().booleanValue() || Boolean.TRUE.equals(article.getIsNominated()) ? text + "(Article): " : text + "(Group): ") : (article.getUseArticlePurchaseWaste() != false || Boolean.TRUE.equals(article.getIsNominated()) ? text + "(Article): " : text + "(Group): ");
        text = text + dc.convert((Object)ArticlePriceCalculationToolkit.getArticlePurchaseWaste((BasicArticleComplete)article, (boolean)tender), null, new Object[0]) + "%";
        if (Boolean.TRUE.equals(article.getIsNominated())) {
            text = text + " (nominated)";
        }
        text = text + "</li>";
        text = text + "<li>";
        if (Boolean.TRUE.equals(article.getIsNominated())) {
            text = text + "Cooking (Article): 0% (nominated)";
        } else if (tender) {
            if (article.getUseTenderCookingWaste().booleanValue()) {
                text = text + "Cooking (Article): ";
                text = text + dc.convert((Object)article.getTenderCookingWaste(), null, new Object[0]) + "%";
            } else if (article.getCategory().getUseTenderWaste().booleanValue()) {
                text = text + "Cooking (Group): ";
                text = text + dc.convert((Object)article.getCategory().getDefaultTenderCookingWaste(), null, new Object[0]) + "%";
            } else if (article.getCategory().getParent() != null) {
                if (article.getCategory().getParent().getUseTenderWaste().booleanValue()) {
                    text = text + "Cooking (Group): ";
                    text = text + dc.convert((Object)article.getCategory().getParent().getDefaultTenderCookingWaste(), null, new Object[0]) + "%";
                } else if (article.getCategory().getParent().getParent() != null) {
                    if (article.getCategory().getParent().getParent().getUseTenderWaste().booleanValue()) {
                        text = text + "Cooking (Group): ";
                        text = text + dc.convert((Object)article.getCategory().getParent().getParent().getDefaultTenderCookingWaste(), null, new Object[0]) + "%";
                    } else if (article.getCategory().getParent().getParent().getParent() != null) {
                        if (article.getCategory().getParent().getParent().getParent().getUseTenderWaste().booleanValue()) {
                            text = text + "Cooking (Group): ";
                            text = text + dc.convert((Object)article.getCategory().getParent().getParent().getParent().getDefaultTenderCookingWaste(), null, new Object[0]) + "%";
                        } else if (article.getCategory().getParent().getParent().getParent().getParent() != null) {
                            if (article.getCategory().getParent().getParent().getParent().getParent().getUseTenderWaste().booleanValue()) {
                                text = text + "Cooking (Group): ";
                                text = text + dc.convert((Object)article.getCategory().getParent().getParent().getParent().getParent().getDefaultTenderCookingWaste(), null, new Object[0]) + "%";
                            } else {
                                text = text + "Cooking: 0%";
                            }
                        } else {
                            text = text + "Cooking: 0%";
                        }
                    } else {
                        text = text + "Cooking: 0%";
                    }
                } else {
                    text = text + "Cooking: 0%";
                }
            } else {
                text = text + "Cooking: 0%";
            }
        } else if (article.getUseArticleCookingWaste().booleanValue()) {
            text = text + "Cooking (Article): ";
            text = text + dc.convert((Object)article.getCookingWaste(), null, new Object[0]) + "%";
        } else if (article.getCategory().getUseTenderWaste().booleanValue()) {
            text = text + "Cooking (Group): ";
            text = text + dc.convert((Object)article.getCategory().getDefaultCookingWaste(), null, new Object[0]) + "%";
        } else if (article.getCategory().getParent() != null) {
            if (article.getCategory().getParent().getUseWaste().booleanValue()) {
                text = text + "Cooking (Group): ";
                text = text + dc.convert((Object)article.getCategory().getParent().getDefaultCookingWaste(), null, new Object[0]) + "%";
            } else if (article.getCategory().getParent().getParent() != null) {
                if (article.getCategory().getParent().getParent().getUseWaste().booleanValue()) {
                    text = text + "Cooking (Group): ";
                    text = text + dc.convert((Object)article.getCategory().getParent().getParent().getDefaultCookingWaste(), null, new Object[0]) + "%";
                } else if (article.getCategory().getParent().getParent().getParent() != null) {
                    if (article.getCategory().getParent().getParent().getParent().getUseWaste().booleanValue()) {
                        text = text + "Cooking (Group): ";
                        text = text + dc.convert((Object)article.getCategory().getParent().getParent().getParent().getDefaultCookingWaste(), null, new Object[0]) + "%";
                    } else if (article.getCategory().getParent().getParent().getParent().getParent() != null) {
                        if (article.getCategory().getParent().getParent().getParent().getParent().getUseWaste().booleanValue()) {
                            text = text + "Cooking (Group): ";
                            text = text + dc.convert((Object)article.getCategory().getParent().getParent().getParent().getParent().getDefaultCookingWaste(), null, new Object[0]) + "%";
                        } else {
                            text = text + "Cooking: 0%";
                        }
                    } else {
                        text = text + "Cooking: 0%";
                    }
                } else {
                    text = text + "Cooking: 0%";
                }
            } else {
                text = text + "Cooking: 0%";
            }
        } else {
            text = text + "Cooking: 0%";
        }
        text = text + "</li>";
        text = text + "</ul>";
        return text;
    }

    public static SupplierConditionComplete getSupplierConditionForContract(BasicArticleComplete art, SupplierReference supplier, Boolean useTaxZoneMatch, TaxZoneComplete taxZone, Timestamp validity) {
        SupplierConditionBaseComplete base = art.getSupplier(supplier);
        if (base != null) {
            for (SupplierConditionCategoryComplete cate : base.getSupplierConditionCategory()) {
                boolean taxMatch = false;
                if (Boolean.TRUE.equals(useTaxZoneMatch)) {
                    if (cate.getTaxZone() != null && cate.getTaxZone().equals((Object)taxZone)) {
                        taxMatch = true;
                    } else if (cate.getTaxZone() == null && taxZone == null) {
                        taxMatch = true;
                    }
                } else {
                    taxMatch = true;
                }
                if (!taxMatch) continue;
                for (SupplierConditionComplete supplierCondition : cate.getConditions()) {
                    if (supplierCondition.getValidity().getStartDate().getTime() > validity.getTime() || supplierCondition.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                    return supplierCondition;
                }
                Collections.sort(cate.getConditions());
                if (cate.getConditions().isEmpty()) {
                    return null;
                }
                return (SupplierConditionComplete)cate.getConditions().get(cate.getConditions().size() - 1);
            }
        }
        return null;
    }

    public static SupplierConditionComplete getSupplierCondition(BasicArticleComplete art, SupplierReference supplier, Boolean useTaxZoneMatch, TaxZoneComplete taxZone, Timestamp validity) {
        SupplierConditionBaseComplete base = art.getSupplier(supplier);
        if (base != null) {
            for (SupplierConditionCategoryComplete cate : base.getSupplierConditionCategory()) {
                boolean taxMatch = false;
                if (Boolean.TRUE.equals(useTaxZoneMatch)) {
                    if (cate.getTaxZone() != null && cate.getTaxZone().equals((Object)taxZone)) {
                        taxMatch = true;
                    } else if (cate.getTaxZone() == null && taxZone == null) {
                        taxMatch = true;
                    }
                } else {
                    taxMatch = true;
                }
                if (!taxMatch) continue;
                for (SupplierConditionComplete supplierCondition : cate.getConditions()) {
                    if (supplierCondition.getValidity().getStartDate().getTime() > validity.getTime() || supplierCondition.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                    return supplierCondition;
                }
            }
        }
        return null;
    }

    private static int getMaxNumbers(String value, int currentNumber) {
        int i = value.indexOf(".");
        if (i != -1) {
            int ci = value.length() - i - 1;
            String t = value.substring(i + 1, value.length());
            try {
                int a = Integer.valueOf(t);
                if (a == 0) {
                    ci -= t.length();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (currentNumber < ci) {
                return ci;
            }
        }
        return currentNumber;
    }

    public static PriceComplete getArticlePrice(BasicArticleComplete artC, Node un, Node an, SupplierReference injectedSupplier, Boolean useTaxZoneMatch, TaxZoneComplete taxZone, SystemSettingsComplete settings, Timestamp validity) {
        return ArticleToolkit.getArticlePrice(artC, un, an, injectedSupplier, useTaxZoneMatch, taxZone, null, settings, validity);
    }

    public static PriceComplete getArticlePrice(BasicArticleComplete artC, Node un, Node an, SupplierReference injectedSupplier, Boolean useTaxZoneMatch, TaxZoneComplete taxZone, SupplierConditionComplete condition, SystemSettingsComplete settings, Timestamp validity) {
        QuantityComplete q = new QuantityComplete();
        q.setUnit((UnitComplete)un.getValue());
        if (an.getValue() instanceof Integer) {
            q.setQuantity(Double.valueOf(((Integer)an.getValue()).doubleValue()));
        } else if (an.getValue() instanceof Long) {
            q.setQuantity(Double.valueOf(((Long)an.getValue()).doubleValue()));
        } else {
            q.setQuantity((Double)an.getValue());
        }
        SupplierConditionComplete scc = condition;
        if (scc == null) {
            scc = ArticleToolkit.getSupplierCondition(artC, injectedSupplier, useTaxZoneMatch, taxZone, validity);
        }
        if (scc == null) {
            if (artC != null) {
                System.err.println("Supplier Condition for given Order Position (Article = " + artC.getNumber() + " - " + artC.getName() + " and Supplier " + injectedSupplier.getId() + ") not found");
            }
            return new PriceComplete(settings.getCurrency(), Double.valueOf(0.0));
        }
        if (scc.getStepPrice() == null) {
            return new PriceComplete(scc.getSupplier().getPaymentCurrency(), Double.valueOf(0.0));
        }
        Collections.sort(scc.getStepPrice().getSteps(), (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        StepPriceCalculationComplete s = scc.getStepPrice();
        StepPriceFunctionComplete lastStep = null;
        for (StepPriceFunctionComplete step : s.getSteps()) {
            if (lastStep == null) {
                lastStep = step;
                continue;
            }
            QuantityComplete qq = step.getUpperLimit();
            double d2 = UnitConversionToolkit.convertUnit((UnitComplete)lastStep.getUpperLimit().getUnit(), (UnitComplete)q.getUnit(), (double)lastStep.getUpperLimit().getQuantity(), (BasicArticleLight)artC, (Timestamp)validity);
            if (!(q.getQuantity() > d2) && d2 != 0.0) continue;
            lastStep = step;
        }
        if (lastStep != null) {
            PriceComplete p = lastStep.getPrice();
            return new PriceComplete(p);
        }
        System.err.println("No price for given Article (" + artC.getNumber() + " - " + artC.getName() + ") and Supplier (" + injectedSupplier.getId() + ") found");
        return null;
    }

    public static String getScaleString(SupplierConditionComplete scc) {
        if (scc == null || scc.getSupplier() == null) {
            return "<b>" + Words.NO_SUPPLIER_SELECTED + "</b>";
        }
        String t = "<b>" + scc.getSupplier().getName() + "<br/><hr/></b>";
        String lastOne = null;
        if (scc.getStepPrice() != null) {
            Collections.sort(scc.getStepPrice().getSteps(), new StepPriceComparator());
            Iterator it = scc.getStepPrice().getSteps().iterator();
            while (it.hasNext()) {
                StepPriceFunctionComplete f = (StepPriceFunctionComplete)it.next();
                if (f.getUpperLimit() == null || f.getUpperLimit().getUnit() == null || f.getUpperLimit().getAmount() == null) continue;
                t = lastOne == null ? t + "0 " + f.getUpperLimit().getUnit().getShortName() : t + "> " + lastOne;
                t = t + " - ";
                if (f.getUpperLimit().getQuantity() == 0.0 || !it.hasNext()) {
                    lastOne = "\u221e " + f.getUpperLimit().getUnit().getShortName();
                } else {
                    Converter cc = ConverterRegistry.getConverter(QuantityConverter0Decimal.class);
                    lastOne = (String)cc.convert((Object)f.getUpperLimit(), null, new Object[0]);
                }
                t = t + lastOne;
                Converter ccc = ConverterRegistry.getConverter(PriceConverter1.class);
                t = t + " = " + ccc.convert((Object)f.getPrice(), null, new Object[0]);
                t = t + "<br/>";
            }
        }
        return t;
    }

    public static StepPriceFunctionComplete getScalePrice(SupplierConditionComplete scc, ArticlePriceContractEntryComplete value) {
        for (StepPriceFunctionComplete spfc : scc.getStepPrice().getSteps()) {
            if (value.getMaxScale().intValue() != spfc.getUpperLimit().getQuantity().intValue()) continue;
            return spfc;
        }
        return null;
    }

    public static StoreConditionComplete getFirstStoreCondition(BasicArticleComplete value) {
        for (StoreConditionComplete scc : value.getStoreConditions()) {
            if (scc.getPreference() != 0) continue;
            return scc;
        }
        if (value.getStoreConditions().isEmpty()) {
            return null;
        }
        return (StoreConditionComplete)value.getStoreConditions().get(0);
    }

    private static String createArticleCode(Node<ArticleCategoryLight> category) {
        String t = "";
        t = ((ArticleCategoryLight)category.getValue()).getCode() + t;
        Node p = category.getChildNamed(new String[]{"parent"});
        if (p != null && p.getValue() != null) {
            String tt = ArticleToolkit.createArticleCode((Node<ArticleCategoryLight>)p);
            t = tt + t;
        }
        return t;
    }

    public static SupplierConditionComplete getCheapestSupplierConditionByMinAmount(BasicArticleComplete bac, Boolean useTaxZone, TaxZoneComplete taxZone, Timestamp validity) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        PriceComplete bestPrice = null;
        SupplierConditionComplete cheapestSupplier = null;
        for (SupplierConditionBaseComplete base : bac.getSuppliers()) {
            for (SupplierConditionCategoryComplete category : base.getSupplierConditionCategory()) {
                boolean taxGroupMatch = false;
                if (Boolean.TRUE.equals(useTaxZone)) {
                    if (taxZone != null && taxZone.equals((Object)category.getTaxZone())) {
                        taxGroupMatch = true;
                    }
                    if (taxZone == null && category.getTaxZone() == null) {
                        taxGroupMatch = true;
                    }
                } else {
                    taxGroupMatch = true;
                }
                if (!taxGroupMatch) continue;
                for (SupplierConditionComplete condition : category.getConditions()) {
                    if (condition.getValidity().getStartDate().getTime() > validity.getTime() || condition.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                    SupplierConditionComplete sc = condition;
                    SupplierReference sr = new SupplierReference(sc.getSupplier().getId());
                    PriceComplete price = ArticleToolkit.getArticlePrice(bac, INodeCreator.getDefaultImpl().getNode4DTO((Object)sc.getOrderUnit(), false, false), INodeCreator.getDefaultImpl().getNode4DTO((Object)sc.getMinOrderAmount(), false, false), sr, useTaxZone, taxZone, sc, settings, validity);
                    if (bestPrice != null && price != null && !(price.getPrice() < bestPrice.getPrice())) continue;
                    cheapestSupplier = sc;
                    bestPrice = price;
                }
            }
        }
        return cheapestSupplier;
    }

    public static String getArticleCode(Node<ArticleCategoryLight> category) {
        return ArticleToolkit.createArticleCode(category);
    }

    public static int getAllArticleContractTypes() {
        return 3003;
    }

    public static Double getPurchaseWaste(BasicArticleComplete article, boolean tender) {
        return ArticlePriceCalculationToolkit.getArticlePurchaseWaste((BasicArticleComplete)article, (boolean)tender);
    }

    public static Double getCookingWaste(BasicArticleComplete article, CustomerReference customer, boolean tender) {
        return ArticlePriceCalculationToolkit.getCookingWaste((BasicArticleComplete)article, (CustomerReference)customer, (boolean)tender);
    }

    public static UnitComplete getLowestArticleUnit(BasicArticleComplete article) {
        Collections.sort(article.getPackingQuantitiesVariants());
        UnitComplete unit = null;
        for (PackagingQuantityBaseComplete baseComplete : article.getPackingQuantitiesVariants()) {
            Collections.sort(baseComplete.getPackingQuantities());
            for (PackagingQuantityComplete pak : baseComplete.getPackingQuantities()) {
                unit = pak.getUnit();
            }
        }
        while (unit.getSubUnit() != null && unit.getSubUnit().getDisplay().booleanValue()) {
            unit = unit.getSubUnit();
        }
        return unit;
    }

    public static String createInfoString(RequisitionOrderMoveComplete acDTO) {
        String t = "<b>Movement</b><br/>";
        t = t + "<ul>";
        t = t + "<li>ChargeNo: " + acDTO.getCharge().getNumber() + "</li>";
        t = t + "</ul>";
        return t;
    }

    public static String createInfoString(RequisitionOrderPreparationComplete acDTO) {
        String t = "<b>Preparation</b><br/>";
        t = t + "<ul>";
        t = t + "<li>ChargeNo: " + acDTO.getCharge().getNumber() + "</li>";
        t = t + "</ul>";
        return t;
    }

    public static String createInfoString(RequisitionOrderAcceptationComplete acDTO) {
        String t = "<b>Acceptation</b><br/>";
        t = t + "<ul>";
        t = t + "<li>ChargeNo: " + acDTO.getCharge().getNumber() + "</li>";
        t = t + "</ul>";
        return t;
    }

    public static String createInfoString(RequisitionOrderRejectionComplete acDTO) {
        String t = "<b>Acceptation</b><br/>";
        t = t + "<ul>";
        t = t + "<li>ChargeNo: " + acDTO.getCharge().getNumber() + "</li>";
        t = t + "</ul>";
        return t;
    }

    public static String createAllergenString(BasicArticleComplete article) {
        String t = "Allergen Codes: ";
        ArrayList declare = new ArrayList(article.getAllergenDeclarations());
        if (declare.isEmpty()) {
            t = t + "no allergens";
        } else {
            Collections.sort(declare);
            for (AllergenDeclarationComplete allergenDeclaration : declare) {
                t = t + allergenDeclaration.getCharacteristic().getCode();
                if (Boolean.TRUE.equals(allergenDeclaration.getContainsTraces())) {
                    t = t + "*";
                }
                t = t + ", ";
            }
            t = t.substring(0, t.length() - 2);
        }
        return t;
    }

    public static List<PackagingQuantityComplete> getPackagingTableFromArticle(BasicArticleLight article, Date orderDate) {
        Collections.sort(article.getPackingQuantitiesVariants());
        for (PackagingQuantityBaseComplete pack : article.getPackingQuantitiesVariants()) {
            if (orderDate.getTime() < pack.getValidityPeriod().getStartDate().getTime() || orderDate.getTime() > pack.getValidityPeriod().getEndDate().getTime()) continue;
            return pack.getPackingQuantities();
        }
        if (article.getPackingQuantitiesVariants().isEmpty()) {
            return new ArrayList<PackagingQuantityComplete>();
        }
        return ((PackagingQuantityBaseComplete)article.getPackingQuantitiesVariants().get(article.getPackingQuantitiesVariants().size() - 1)).getPackingQuantities();
    }

    public static String createExpiryChangeLog(List<FieldMutationComplete> mutations) {
        Collections.sort(mutations, (o1, o2) -> o1.getDate().compareTo(o2.getDate()));
        String info = "<b>Expiry Change Log</b><br/>";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        for (FieldMutationComplete mutation : mutations) {
            info = info + "@ " + simpleDateFormat.format(mutation.getDate());
            info = info + " changed from " + mutation.getOldValue() + " to " + mutation.getNewValue();
            info = info + "\n";
        }
        return info;
    }

    public static StoreConditionComplete getStoreCondition(BasicArticleComplete article, StoreConditionTypeE type) {
        for (StoreConditionComplete storeCondition : article.getStoreConditions()) {
            if (!storeCondition.getType().equals((Object)type)) continue;
            return storeCondition;
        }
        return null;
    }
}

