/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.converter.Converter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashtableToolkit {
    static Logger log = LoggerFactory.getLogger(HashtableToolkit.class);

    public static <K, V> Map<K, V> transpose(Map<V, K> map) {
        HashMap<K, V> newMap = new HashMap<K, V>();
        for (Map.Entry<V, K> e : map.entrySet()) {
            newMap.put(e.getValue(), e.getKey());
        }
        return newMap;
    }

    public static <K, V, N> Map<N, V> transformKey(Map<K, V> map, Converter<K, N> converter) {
        Hashtable<Object, V> newMap = new Hashtable<Object, V>();
        for (Map.Entry<K, V> e : map.entrySet()) {
            Object nKey = converter.convert(e.getKey(), null, new Object[0]);
            newMap.put(nKey, e.getValue());
        }
        return newMap;
    }

    public static <K, V, N> Map<K, N> transformValue(Map<K, V> map, Converter<V, N> converter) {
        Hashtable<K, Object> newMap = new Hashtable<K, Object>();
        for (Map.Entry<K, V> e : map.entrySet()) {
            Object nValue = converter.convert(e.getValue(), null, new Object[0]);
            newMap.put(e.getKey(), nValue);
        }
        return newMap;
    }

    public static void print(Map<?, ?> q) {
        log.debug("|------------------------ MAP ------------------------|");
        for (Object k : q.keySet()) {
            Object v = q.get(k);
            log.debug("|-- " + k.toString() + " -> " + v);
        }
        log.debug("|-----------------------------------------------------|");
    }
}

