/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.CateringServiceTypeConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.LegInfoConverter;
import ch.icit.pegasus.client.converter.LoadingGroupConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.formatter.FormatterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.SPMLMealTypeDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ServiceDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ACateringServiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartChoiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.IMealplanLegComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeComplete;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MealPlanToolkit {
    public static List<ScreenValidationObject> validateLoadingGroupMapping(Map<ALoadingGroupComplete, ALoadingGroupComplete> mt, List<ALoadingGroupComplete> sourceGroups, List<ALoadingGroupComplete> targetGroups) {
        return MealPlanToolkit.validateLoadingGroupMapping(mt, sourceGroups, targetGroups, false);
    }

    public static List<ScreenValidationObject> validateLoadingGroupMapping(Map<ALoadingGroupComplete, ALoadingGroupComplete> mt, List<ALoadingGroupComplete> sourceGroups, List<ALoadingGroupComplete> targetGroups, boolean isTargetOptional) {
        return MealPlanToolkit.validateLoadingGroupMapping(mt, sourceGroups, targetGroups, isTargetOptional, null);
    }

    public static List<ScreenValidationObject> validateLoadingGroupMapping(Map<ALoadingGroupComplete, ALoadingGroupComplete> mt, List<ALoadingGroupComplete> sourceGroups, List<ALoadingGroupComplete> targetGroups, boolean isTargetOptional, List<ALoadingGroupComplete> stowedGroups) {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        LoadingGroupConverter converter = (LoadingGroupConverter)ConverterRegistry.getConverter(LoadingGroupConverter.class);
        if (!isTargetOptional) {
            for (ALoadingGroupComplete t : targetGroups) {
                if (mt.containsValue(t)) continue;
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Target Loading Group " + converter.convert(t, null, new Object[0]) + " has not source"));
            }
        }
        for (ALoadingGroupComplete t : sourceGroups) {
            if (stowedGroups == null || !stowedGroups.contains(t) || mt.get(t) != null) continue;
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Source Loading Group " + converter.convert(t, null, new Object[0]) + " has not target"));
        }
        HashSet<ALoadingGroupComplete> controlSet = new HashSet<ALoadingGroupComplete>();
        for (Map.Entry<ALoadingGroupComplete, ALoadingGroupComplete> entry : mt.entrySet()) {
            if (controlSet.add(entry.getValue())) continue;
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Duplicate Target Loading Group " + converter.convert(entry.getValue(), null, new Object[0])));
        }
        return a;
    }

    public static String createPostfixServicePartString(CabinClassComplete cc, IMealplanLegComplete leg, ALoadingGroupComplete partType, CateringServiceTypeComplete type, boolean inList, CateringServicePartComplete pt) {
        String t;
        if (inList) {
            if (partType == null) {
                return "";
            }
            t = partType.getName();
        } else {
            t = MealPlanToolkit.createPrefixServicePartString(cc, leg, type);
            if (partType != null) {
                t = t + " " + partType.getName();
            }
        }
        if (partType != null && partType.getMealType() != null) {
            t = t + " (" + partType.getMealType().getCode() + ")";
        }
        if (pt != null) {
            String p = "";
            for (CateringServicePartChoiceComplete c : pt.getChoices()) {
                switch (c.getCalculationType()) {
                    case FIX: {
                        p = p + ", Fix " + c.getFixAmount();
                        break;
                    }
                    case RATIO: {
                        DecimalFormat f = FormatterRegistry.getDecimalFormat("0.##");
                        p = p + ", Ratio " + f.format(c.getRatio()) + "%";
                        break;
                    }
                    case STEP: {
                        p = p + ", Steps " + c.getSteps().size();
                    }
                }
            }
            if (!p.isEmpty()) {
                p = p.substring(2, p.length());
                t = t + " (" + p + ")";
            }
        }
        return t;
    }

    public static String createPostfixServicePartString(CabinClassComplete cc, List<? extends IMealplanLegComplete> legs, ALoadingGroupComplete partType, CateringServiceTypeComplete type, boolean inList, CateringServicePartComplete pt) {
        String t;
        if (inList) {
            if (partType == null) {
                return "";
            }
            t = partType.getName();
        } else {
            t = MealPlanToolkit.createPrefixServicePartString(cc, legs, type);
            if (partType != null) {
                t = t + " " + partType.getName();
            }
        }
        if (partType != null && partType.getMealType() != null) {
            t = t + " " + partType.getMealType().getCode();
        }
        if (pt != null) {
            String p = "";
            for (CateringServicePartChoiceComplete c : pt.getChoices()) {
                switch (c.getCalculationType()) {
                    case FIX: {
                        p = p + ", Fix " + c.getFixAmount();
                        break;
                    }
                    case RATIO: {
                        DecimalFormat f = FormatterRegistry.getDecimalFormat("0.##");
                        p = p + ", Ratio " + f.format(c.getRatio()) + "%";
                        break;
                    }
                    case STEP: {
                        p = p + ", Steps " + c.getSteps().size();
                    }
                }
            }
            if (!p.isEmpty()) {
                p = p.substring(2, p.length());
                t = t + " (" + p + ")";
            }
        }
        if (partType.getDeliverAlaCarte().booleanValue()) {
            t = "\u00b2 " + t;
        }
        if (partType.getDeliverSpml().booleanValue()) {
            t = "\u00b9 " + t;
        }
        if (t == null || t.isEmpty()) {
            t = "no name set (in Meal Plan Spec Group)";
        }
        return t;
    }

    public static String createPrefixServicePartString(CabinClassComplete cc, IMealplanLegComplete leg, CateringServiceTypeComplete type) {
        return cc.getCode() + " " + leg.getDepartureAirport().getCode() + " " + leg.getArrivalAirport().getCode() + " " + type.getCode();
    }

    public static String createPrefixServicePartString(CabinClassComplete cc, List<? extends IMealplanLegComplete> legs, CateringServiceTypeComplete type) {
        String t = cc.getCode();
        for (IMealplanLegComplete iMealplanLegComplete : legs) {
            t = t + ", " + iMealplanLegComplete.getDepartureAirport().getCode() + " " + iMealplanLegComplete.getArrivalAirport().getCode();
        }
        t = t + " " + type.getCode();
        return t;
    }

    public static String createMealTypeSPMLSpaceString(MealTypeComplete mealType) {
        return "SPML Space " + mealType.getCode();
    }

    public static String createMealTypealaCarteSpaceString(MealTypeComplete mealType) {
        return "a la Carte Space " + mealType.getCode();
    }

    public static String createServicePartString(Node<?> type, boolean inList) {
        if (type != null && type.getParent() != null && type.getParent().getValue() instanceof ServiceDeliverableComplete) {
            Node p = type.getParent();
            ServiceDeliverableComplete d = (ServiceDeliverableComplete)p.getValue();
            if (d.getLoadingGroup().getContainingService() instanceof CateringServiceScheduleVariantComplete) {
                CabinClassComplete cc = d.getLoadingGroup().getContainingService().getCabinClass();
                List leg = ((CateringServiceScheduleVariantComplete)d.getLoadingGroup().getContainingService()).getLegs();
                ALoadingGroupComplete partType = d.getLoadingGroup();
                CateringServicePartComplete cpt = null;
                CateringServiceScheduleVariantComplete cssc = (CateringServiceScheduleVariantComplete)d.getLoadingGroup().getContainingService();
                if (!cssc.getRotations().isEmpty()) {
                    for (CateringServicePartComplete pt : ((CateringServiceRotationComplete)cssc.getRotations().get(0)).getParts()) {
                        if (pt.getLoadingGroup() == null || !pt.getLoadingGroup().equals((Object)partType)) continue;
                        cpt = pt;
                    }
                }
                String t = MealPlanToolkit.createPostfixServicePartString(cc, leg, partType, d.getLoadingGroup().getContainingService().getType(), inList, cpt);
                if (Boolean.TRUE.equals(cssc.getBase().getExpire())) {
                    t = t + " - expired";
                }
                if (Boolean.TRUE.equals(cssc.getBase().getReplaceExpired())) {
                    t = t + " - replace expired";
                }
                return t;
            }
            if (d.getLoadingGroup().getContainingService() instanceof CateringServiceComplete) {
                CabinClassComplete cc = d.getLoadingGroup().getContainingService().getCabinClass();
                List leg = ((CateringServiceComplete)d.getLoadingGroup().getContainingService()).getLegs();
                ALoadingGroupComplete partType = d.getLoadingGroup();
                CateringServicePartComplete cpt = null;
                CateringServiceComplete csc = (CateringServiceComplete)d.getLoadingGroup().getContainingService();
                for (CateringServicePartComplete pt : csc.getParts()) {
                    if (pt.getLoadingGroup() == null && pt.getLoadingGroupId() != null) {
                        pt.afterUnmarshal(null, null);
                    }
                    if (pt.getLoadingGroup() == null) {
                        System.out.println("null Pointer");
                    }
                    if (!pt.getLoadingGroup().equals((Object)partType)) continue;
                    cpt = pt;
                }
                Object t = MealPlanToolkit.createPostfixServicePartString(cc, leg, partType, d.getLoadingGroup().getContainingService().getType(), inList, cpt);
                if (Boolean.TRUE.equals(csc.getExpire())) {
                    t = (String)t + " - expired";
                }
                if (Boolean.TRUE.equals(csc.getReplaceExpired())) {
                    t = (String)t + " - replace expired";
                }
                return t;
            }
        } else if (type.getParent() != null && type.getParent().getParent() != null && type.getParent().getParent().getParent() != null && type.getParent().getParent().getParent().getValue() instanceof ACateringServiceComplete) {
            ACateringServiceComplete ser = (ACateringServiceComplete)type.getParent().getParent().getParent().getValue();
            if (ser instanceof CateringServiceScheduleVariantComplete) {
                CabinClassComplete cc = ser.getCabinClass();
                List leg = ((CateringServiceScheduleVariantComplete)ser).getLegs();
                ALoadingGroupComplete partType = ((CateringServicePartComplete)type.getParent().getParent().getParent().getValue()).getLoadingGroup();
                CateringServicePartComplete cpt = null;
                CateringServiceScheduleVariantComplete cssc = (CateringServiceScheduleVariantComplete)ser;
                for (CateringServicePartComplete pt : ((CateringServiceRotationComplete)cssc.getRotations().get(0)).getParts()) {
                    if (!pt.getLoadingGroup().equals((Object)partType)) continue;
                    cpt = pt;
                }
                Object t = MealPlanToolkit.createPostfixServicePartString(cc, leg, partType, ser.getType(), inList, cpt);
                if (Boolean.TRUE.equals(cssc.getBase().getExpire())) {
                    t = (String)t + " - expired";
                }
                if (Boolean.TRUE.equals(cssc.getBase().getReplaceExpired())) {
                    t = (String)t + " - replace expired";
                }
                return t;
            }
            if (ser instanceof CateringServiceComplete) {
                CabinClassComplete cc = ser.getCabinClass();
                List leg = ((CateringServiceComplete)ser).getLegs();
                ALoadingGroupComplete partType = ((CateringServicePartComplete)type.getParent().getValue()).getLoadingGroup();
                CateringServicePartComplete cpt = null;
                CateringServiceComplete csc = (CateringServiceComplete)ser;
                for (CateringServicePartComplete pt : csc.getParts()) {
                    if (!pt.getLoadingGroup().equals((Object)partType)) continue;
                    cpt = pt;
                }
                Object t = MealPlanToolkit.createPostfixServicePartString(cc, leg, partType, ser.getType(), inList, cpt);
                if (Boolean.TRUE.equals(csc.getExpire())) {
                    t = (String)t + " - expired";
                }
                if (Boolean.TRUE.equals(csc.getReplaceExpired())) {
                    t = (String)t + " - replace expired";
                }
                return t;
            }
        } else {
            try {
                Node p = type.getParent().getParent().getParent().getParent().getParent().getChildNamed(CateringServiceScheduleVariantComplete_.base);
                CateringServiceScheduleComplete ser = (CateringServiceScheduleComplete)p.getValue(CateringServiceScheduleComplete.class);
                if (ser == null) {
                    return "n/a";
                }
                CabinClassComplete cc = ser.getCabinClass();
                List leg = ser.getLegs();
                ALoadingGroupComplete partType = (ALoadingGroupComplete)type.getValue();
                CateringServicePartComplete pt = (CateringServicePartComplete)type.getParent().getValue();
                String t = MealPlanToolkit.createPostfixServicePartString(cc, leg, partType, ser.getType(), inList, pt);
                if (ser != null) {
                    if (Boolean.TRUE.equals(ser.getExpire())) {
                        t = t + " - expired";
                    }
                    if (Boolean.TRUE.equals(ser.getReplaceExpired())) {
                        t = t + " - replace expired";
                    }
                }
                return t;
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public static String createServiceGroupString(CabinClassComplete cc, ALegComplete leg, CateringServiceTypeComplete type) {
        Converter ccConv = ConverterRegistry.getConverter(CabinClassConverter.class);
        Converter legConv = ConverterRegistry.getConverter(LegInfoConverter.class);
        Converter typeConv = ConverterRegistry.getConverter(CateringServiceTypeConverter.class);
        return (String)ccConv.convert((Object)cc, null, new Object[]{false}) + " " + (String)legConv.convert((Object)leg, null, new Object[0]) + " " + (String)typeConv.convert((Object)type, null, new Object[0]);
    }

    public static String createServiceGroupString(CabinClassComplete cc, List<? extends ALegComplete> leg, CateringServiceTypeComplete type) {
        Converter ccConv = ConverterRegistry.getConverter(CabinClassConverter.class);
        Converter legConv = ConverterRegistry.getConverter(LegInfoConverter.class);
        Converter typeConv = ConverterRegistry.getConverter(CateringServiceTypeConverter.class);
        String t = (String)ccConv.convert((Object)cc, null, new Object[]{false});
        for (ALegComplete aLegComplete : leg) {
            t = t + ", " + (String)legConv.convert((Object)aLegComplete, null, new Object[0]);
        }
        t = t + " " + (String)typeConv.convert((Object)type, null, new Object[0]);
        return t;
    }

    public static String createSPMLNameConfigInfoText() {
        String t = "<b>Define the Naming Format for Special Meals</b><br/>";
        t = t + "<ul>";
        t = t + "<li>{Leg} = Leg Type (I/O, Inbound/Outbound)</li>";
        t = t + "<li>{Class} = Cabin Class Code</li>";
        t = t + "<li>{Id} = Service Id (if defined in Meal Plan Service)</li>";
        t = t + "<li>{Type} = Service Type</li>";
        t = t + "<li>{SPML} = Special Meal Type Code</li>";
        t = t + "</ul>";
        t = t + "Arrange this Code Words to define the format of a SPML Delivery on Label/Delivery Slip/Invoice...<br/><br/>";
        t = t + "Example: {Leg},{Class},{Type},{SPML}<br/>";
        t = t + "= I Y LNCH KSML";
        return t;
    }

    public static String createReplacePartString(Node<DeliverableComplete> item) {
        SPMLMealTypeDeliverableComplete d = (SPMLMealTypeDeliverableComplete)item.getValue();
        return MealPlanToolkit.createReplacePartString(d);
    }

    public static String createReplacePartString(SPMLMealTypeDeliverableComplete item) {
        SPMLMealTypeDeliverableComplete d = item;
        if (d.getService() != null) {
            return (d.getSpml() != false ? "SPML" : "alaCarte") + " Space " + d.getMealType().getCode() + " " + d.getService().getType().getCode() + " " + d.getService().getCabinClass().getCode();
        }
        if (d.getServiceSchedule() != null) {
            return (d.getSpml() != false ? "SPML" : "alaCarte") + " Space " + d.getMealType().getCode() + " " + d.getServiceSchedule().getType().getCode() + " " + d.getServiceSchedule().getCabinClass().getCode();
        }
        return null;
    }
}

