/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.FormulaConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderPositionMutationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderRejectionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderTransactionComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class OrderToolkit {
    public static String createInfoInsert(PurchaseOrderComplete order) {
        String s = "";
        s = s + "<b>Order Nr. " + order.getNumber() + "<br/><hr/></b><br/>";
        s = s + "<b>Supplier</b><ul><li>" + order.getSupplier() + "</li></ul>";
        s = s + "<b>Orderstate</b><ul><li>" + order.getState() + "</li></ul>";
        s = s + "<b>Reviewstate</b><ul><li>" + order.getReviewState() + "</li></ul>";
        s = s + "<b>Order Date</b><ul><li>" + ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)order.getOrderDate(), null, new Object[0]) + "</li></ul>";
        s = s + "<b>Delivery Date</b><ul><li>" + ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)order.getDeliveryDate(), null, new Object[0]) + "</li></ul>";
        s = s + "<b>Department</b><ul><li>" + ((CostCenterConverter)ConverterRegistry.getConverter(CostCenterConverter.class)).convert(order.getCostCenter(), null, new Object[0]) + "</li></ul>";
        s = s + "<b>Estimated Costs</b><ul><li>" + ((PriceConverter2)ConverterRegistry.getConverter(PriceConverter2.class)).convert(order.getEstimatedCost(), null, new Object[0]) + "</li></ul>";
        s = s + "<b>Real Costs</b><ul><li>" + ((PriceConverter2)ConverterRegistry.getConverter(PriceConverter2.class)).convert(order.getRealCost(), null, new Object[0]) + "</li></ul>";
        return s;
    }

    public static String createInfoInsert(PurchaseOrderTransactionComplete order) {
        String s = "";
        s = s + "<b>Order Nr. " + order.getOrderNumber() + "<br/><hr/></b><br/>";
        s = s + "<b>Supplier</b><ul><li>" + order.getOrderSupplier() + "</li></ul>";
        s = s + "<b>Order State</b><ul><li>" + order.getOrderState() + "</li></ul>";
        s = s + "<b>Review State</b><ul><li>" + order.getReviewState() + "</li></ul>";
        s = s + "<b>Order Date</b><ul><li>" + ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)order.getOrderDate(), null, new Object[0]) + "</li></ul>";
        s = s + "<b>Delivery Date</b><ul><li>" + ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)order.getOrderDeliveryDate(), null, new Object[0]) + "</li></ul>";
        s = s + "<b>Department</b><ul><li>" + ((CostCenterConverter)ConverterRegistry.getConverter(CostCenterConverter.class)).convert(order.getDepartment(), null, new Object[0]) + "</li></ul>";
        s = s + "<b>Estimated Costs</b><ul><li>" + ((PriceConverter2)ConverterRegistry.getConverter(PriceConverter2.class)).convert(order.getEstimatedOrderPrice(), null, new Object[0]) + "</li></ul>";
        s = s + "<b>Real Costs</b><ul><li>" + ((PriceConverter2)ConverterRegistry.getConverter(PriceConverter2.class)).convert(order.getRealOrderCosts(), null, new Object[0]) + "</li></ul>";
        return s;
    }

    public static String createInfoInsert(List<PurchaseOrderAcceptationComplete> acceptions, PurchaseOrderComplete order, Table2RowModel model) {
        return OrderToolkit.createInfoInsert(acceptions, order, model, false);
    }

    public static String createInfoInsert(List<PurchaseOrderAcceptationComplete> acceptions, PurchaseOrderComplete order, Table2RowModel model, boolean withContract) {
        String t = "";
        BasicArticleComplete article = (BasicArticleComplete)model.getNode().getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class);
        if (article == null) {
            return "";
        }
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        PurchaseOrderPositionComplete pos = (PurchaseOrderPositionComplete)model.getNode().getValue();
        PurchaseOrderComplete o = order;
        SupplierConditionComplete sc = (SupplierConditionComplete)model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue();
        if (sc == null) {
            return "<b>Supplier Condition is inconsistent! This article hasn't any Supplier condition for " + o.getSupplier().getName() + "</b>";
        }
        Converter cc = ConverterRegistry.getConverter(PriceConverter1.class);
        Converter cc2 = ConverterRegistry.getConverter(UnitConverter.class);
        PriceComplete dayPrice = ArticleToolkit.getArticlePrice(article, model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}), model.getNode().getChildNamed(new String[]{"quantity-amount"}), (SupplierReference)sc.getSupplier(), order.getUseTaxZone(), order.getTaxZone(), settings, new Timestamp(order.getOrderDate().getTime()));
        t = "<b>" + article.getName() + "<br/><hr/></b><br/>";
        t = t + "<b>Order Details</b<ul>";
        if (dayPrice != null) {
            t = t + "<li>Current Price: " + cc.convert((Object)dayPrice, null, new Object[0]) + "/" + cc2.convert((Object)article.getPriceUnit(), null, new Object[0]);
            if (Boolean.TRUE.equals(article.getMarkedAsContracted())) {
                t = t + "<br/>!<i>Price can differ from Contract Price </i>!";
            }
            t = t + "</li>";
        }
        t = t + "<li>Ordered Price: " + cc.convert((Object)pos.getSupplierPrice(), null, new Object[0]) + "/" + cc2.convert((Object)pos.getPriceUnit(), null, new Object[0]) + "</li>";
        Date minExpDate = null;
        PriceComplete medianPrice = null;
        double currentCounter = 0.0;
        double currentDenominator = 0.0;
        for (PurchaseOrderAcceptationComplete accept : acceptions) {
            if (minExpDate == null) {
                minExpDate = accept.getCharge().getExpiryDate();
            } else if (accept.getCharge().getExpiryDate() != null && minExpDate.getTime() > accept.getCharge().getExpiryDate().getTime()) {
                minExpDate = accept.getCharge().getExpiryDate();
            }
            if (medianPrice == null) {
                medianPrice = new PriceComplete();
                medianPrice.setCurrency(accept.getCharge().getPrice().getCurrency());
            }
            Long w = accept.getAmount().getAmount();
            Double x = accept.getCharge().getPrice().getPrice();
            currentCounter += (double)w.longValue() * x;
            currentDenominator += (double)w.longValue();
        }
        double nP = currentCounter / currentDenominator;
        if (medianPrice != null) {
            medianPrice.setPrice(Double.valueOf(nP));
            t = t + "<li>Charge Price  " + ((PriceConverter1)ConverterRegistry.getConverter(PriceConverter1.class)).convert(medianPrice, null, new Object[0]) + "/" + ((UnitConverter)ConverterRegistry.getConverter(UnitConverter.class)).convert(pos.getArticle().getPriceUnit(), null, new Object[0]) + "</li>";
            t = t + "<li>" + Words.EXPIRY_POINT + "  " + ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)minExpDate, null, new Object[0]) + "</li>";
        } else {
            t = t + "<li>" + Words.NO_RECEIVINGS + "</li>";
        }
        StoreQuantityComplete q = (StoreQuantityComplete)model.getNode().getChildNamed(PurchaseOrderPositionComplete_.quantity).getValue();
        StoreQuantityComplete accept = new StoreQuantityComplete(Long.valueOf(0L), article.getMainStoreUnit());
        StoreQuantityComplete reject = new StoreQuantityComplete(Long.valueOf(0L), article.getMainStoreUnit());
        Node nn = model.getNode().getChildNamed(PurchaseOrderPositionComplete_.transactions);
        Iterator it = nn.getChilds();
        while (it.hasNext()) {
            double dd;
            boolean isSmaller;
            Node no = (Node)it.next();
            if (no.getValue() instanceof PurchaseOrderAcceptationComplete) {
                PurchaseOrderAcceptationComplete acc = (PurchaseOrderAcceptationComplete)no.getValue();
                if (accept == null) {
                    accept = acc.getAmount();
                    continue;
                }
                isSmaller = UnitToolkit.isSmaller(acc.getAmount().getUnit(), accept.getUnit(), article);
                if (isSmaller) {
                    dd = UnitConversionToolkit.convertUnit((UnitComplete)accept.getUnit(), (UnitComplete)acc.getAmount().getUnit(), (double)accept.getAmount().longValue(), (BasicArticleLight)article, (Timestamp)acc.getCharge().getCreationDate());
                    accept.setAmount(Long.valueOf((long)(dd + (double)acc.getAmount().getAmount().longValue())));
                    accept.setUnit(acc.getAmount().getUnit());
                    continue;
                }
                dd = UnitConversionToolkit.convertUnit((UnitComplete)acc.getAmount().getUnit(), (UnitComplete)accept.getUnit(), (double)acc.getAmount().getAmount().longValue(), (BasicArticleLight)((BasicArticleComplete)model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class)), (Timestamp)(acc.getCharge().getCreationDate() != null ? acc.getCharge().getCreationDate() : new Timestamp(order.getOrderDate().getTime())));
                accept.setAmount(Long.valueOf((long)(dd + (double)accept.getAmount().longValue())));
                accept.setUnit(accept.getUnit());
                continue;
            }
            if (no.getValue() instanceof PurchaseOrderRejectionComplete) {
                PurchaseOrderRejectionComplete rej = (PurchaseOrderRejectionComplete)no.getValue();
                if (reject == null) {
                    reject = rej.getAmount();
                    continue;
                }
                isSmaller = UnitToolkit.isSmaller(rej.getAmount().getUnit(), reject.getUnit(), (BasicArticleComplete)model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class));
                if (isSmaller) {
                    dd = UnitConversionToolkit.convertUnit((UnitComplete)reject.getUnit(), (UnitComplete)rej.getAmount().getUnit(), (double)reject.getAmount().longValue(), (BasicArticleLight)((BasicArticleComplete)model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class)), (Timestamp)rej.getDate());
                    accept.setAmount(Long.valueOf((long)(dd + (double)rej.getAmount().getAmount().longValue())));
                    accept.setUnit(rej.getAmount().getUnit());
                    continue;
                }
                dd = UnitConversionToolkit.convertUnit((UnitComplete)rej.getAmount().getUnit(), (UnitComplete)reject.getUnit(), (double)rej.getAmount().getAmount().longValue(), (BasicArticleLight)((BasicArticleComplete)model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class)), (Timestamp)rej.getDate());
                accept.setAmount(Long.valueOf((long)(dd + (double)reject.getAmount().longValue())));
                accept.setUnit(reject.getUnit());
                continue;
            }
            if (!(no.getValue() instanceof PurchaseOrderPositionMutationComplete)) continue;
        }
        UnitComplete smallestUnit = null;
        smallestUnit = UnitToolkit.isSmaller(q.getUnit(), accept.getUnit(), article) ? (UnitToolkit.isSmaller(q.getUnit(), reject.getUnit(), article) ? q.getUnit() : reject.getUnit()) : (UnitToolkit.isSmaller(accept.getUnit(), reject.getUnit(), article) ? accept.getUnit() : reject.getUnit());
        Timestamp validity = new Timestamp(order.getOrderDate().getTime());
        double d = UnitConversionToolkit.convertUnit((UnitComplete)q.getUnit(), (UnitComplete)smallestUnit, (double)q.getAmount().longValue(), (BasicArticleLight)article, (Timestamp)validity);
        q.setAmount(Long.valueOf((long)d));
        q.setUnit(smallestUnit);
        d = UnitConversionToolkit.convertUnit((UnitComplete)accept.getUnit(), (UnitComplete)smallestUnit, (double)accept.getAmount().longValue(), (BasicArticleLight)article, (Timestamp)validity);
        accept.setAmount(Long.valueOf((long)d));
        accept.setUnit(smallestUnit);
        d = UnitConversionToolkit.convertUnit((UnitComplete)reject.getUnit(), (UnitComplete)smallestUnit, (double)reject.getAmount().longValue(), (BasicArticleLight)article, (Timestamp)validity);
        reject.setAmount(Long.valueOf((long)d));
        reject.setUnit(smallestUnit);
        t = t + "</ul>";
        t = t + "<b>Exact Quantity</b><ul>";
        t = t + "<li>Ordered: " + q.getAmount() + " " + q.getUnit().getShortName() + "</li>";
        t = t + "<li>Received: " + accept.getAmount() + " " + accept.getUnit().getShortName() + "</li>";
        t = t + "<li>Rejected: " + reject.getAmount() + " " + reject.getUnit().getShortName() + "</li>";
        t = t + "</ul>";
        Converter formualConverter = ConverterRegistry.getConverter(FormulaConverter.class);
        List<PackagingQuantityComplete> pack = null;
        List<Object> list = pack = sc != null && Boolean.TRUE.equals(sc.getUsePackingQuantity()) ? sc.getPackingQuantities() : null;
        if (pack == null || pack.isEmpty()) {
            pack = ArticleToolkit.getPackagingTableFromArticle((BasicArticleLight)article, order.getOrderDate());
        }
        String u = (String)formualConverter.convert(pack, INodeCreator.getDefaultImpl().createNodes(pack, false, false), new Object[0]);
        t = t + "<b>Conversion</b><ul>";
        t = t + "<li>" + u + "</li></ul>";
        if (withContract && ((PurchaseOrderPositionComplete)model.getNode().getValue()).getContractEntry() != null) {
            PurchaseOrderPositionComplete p = (PurchaseOrderPositionComplete)model.getNode().getValue();
            t = t + "<b>Article Contract No</b><ul>";
            t = t + "<li>" + p.getContractEntry().getContract().getNumber() + "</li>";
            t = t + "</ul>";
        }
        if (Boolean.TRUE.equals(((PurchaseOrderPositionComplete)model.getNode().getValue()).getNotDelivered())) {
            t = t + "<b>Article is not delivered</b>";
        }
        return t;
    }

    public static Date getMinDeliveryDate(BasicArticleComplete artC, SupplierReference supplier, Boolean useTaxZoneMatch, TaxZoneComplete taxZone, Timestamp validity) {
        if (artC == null) {
            return new Date(System.currentTimeMillis());
        }
        SupplierConditionBaseComplete base = artC.getSupplier(supplier);
        if (base != null) {
            for (SupplierConditionCategoryComplete category : base.getSupplierConditionCategory()) {
                boolean taxZoneOk = false;
                if (Boolean.TRUE.equals(useTaxZoneMatch)) {
                    if (category.getTaxZone() != null && category.getTaxZone().equals((Object)taxZone)) {
                        taxZoneOk = true;
                    }
                    if (category.getTaxZone() == null && taxZone == null) {
                        taxZoneOk = true;
                    }
                } else {
                    taxZoneOk = true;
                }
                if (!taxZoneOk) continue;
                for (SupplierConditionComplete c : category.getConditions()) {
                    if (c.getValidity().getStartDate().getTime() > validity.getTime() || c.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                    long i = c.getDeliveryTime().intValue();
                    i = i * 1000L * 60L * 60L * 24L;
                    Calendar ca = TimeUtil.createCalendar();
                    ca.setTimeInMillis(System.currentTimeMillis());
                    ca.set(13, 0);
                    ca.set(12, 0);
                    ca.set(11, 0);
                    return new Date(ca.getTimeInMillis() + i);
                }
            }
        }
        Calendar ca = TimeUtil.createCalendar();
        ca.setTimeInMillis(System.currentTimeMillis());
        ca.set(13, 0);
        ca.set(12, 0);
        ca.set(11, 0);
        return new Date(ca.getTimeInMillis());
    }

    public static Boolean getMinOrderAmountMandatory(BasicArticleComplete artC, SupplierReference supplier, Boolean useTaxZoneMatch, TaxZoneComplete taxZone, Timestamp validity) {
        if (artC == null) {
            return null;
        }
        SupplierConditionBaseComplete base = artC.getSupplier(supplier);
        if (base != null) {
            for (SupplierConditionCategoryComplete category : base.getSupplierConditionCategory()) {
                boolean taxZoneOk = false;
                if (Boolean.TRUE.equals(useTaxZoneMatch)) {
                    if (category.getTaxZone() != null && category.getTaxZone().equals((Object)taxZone)) {
                        taxZoneOk = true;
                    }
                    if (category.getTaxZone() == null && taxZone == null) {
                        taxZoneOk = true;
                    }
                } else {
                    taxZoneOk = true;
                }
                if (!taxZoneOk) continue;
                for (SupplierConditionComplete condition : category.getConditions()) {
                    if (condition.getValidity().getStartDate().getTime() > validity.getTime() || condition.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                    return condition.getMinOrderAmountIsMandatory();
                }
            }
        }
        return null;
    }

    public static Date shiftDeliveryDate2MidNight(Date deliveryDate) {
        Calendar ca = TimeUtil.createCalendar();
        ca.setTimeInMillis(deliveryDate.getTime());
        ca.set(13, 59);
        ca.set(12, 59);
        ca.set(11, 23);
        return new Date(ca.getTimeInMillis());
    }

    public static PriceComplete getDeliveryCosts(SupplierComplete value, PriceComplete price, SystemSettingsComplete settings, CurrencyVariantAccessor currencyAccessor, Timestamp validityDate) {
        if (value != null && value.getCostType() != null) {
            switch (value.getCostType()) {
                case FIX: {
                    return UnitConversionToolkit.convertPrice((CurrencyComplete)settings.getCurrency(), (PriceComplete)value.getDeliveryCost(), (CurrencyVariantAccessor)currencyAccessor, (Timestamp)validityDate);
                }
                case MINAMOUNT: {
                    PriceComplete min = UnitConversionToolkit.convertPrice((CurrencyComplete)settings.getCurrency(), (PriceComplete)value.getMinOrderValue(), (CurrencyVariantAccessor)currencyAccessor, (Timestamp)validityDate);
                    if (price != null) {
                        if (min.getPrice() > price.getPrice()) {
                            return UnitConversionToolkit.convertPrice((CurrencyComplete)settings.getCurrency(), (PriceComplete)value.getDeliveryCost(), (CurrencyVariantAccessor)currencyAccessor, (Timestamp)validityDate);
                        }
                        return new PriceComplete(settings.getCurrency(), Double.valueOf(0.0));
                    }
                    return UnitConversionToolkit.convertPrice((CurrencyComplete)settings.getCurrency(), (PriceComplete)value.getDeliveryCost(), (CurrencyVariantAccessor)currencyAccessor, (Timestamp)validityDate);
                }
                case NONE: {
                    return new PriceComplete(settings.getCurrency(), Double.valueOf(0.0));
                }
            }
        }
        return new PriceComplete(settings.getCurrency(), Double.valueOf(0.0));
    }

    public static PriceComplete getArticleCost(SupplierConditionComplete ccc, Integer quantity, UnitComplete unit, BasicArticleComplete article) {
        StepPriceCalculationComplete c = ccc.getStepPrice();
        Collections.sort(c.getSteps(), (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        Integer amount = quantity;
        StepPriceFunctionComplete lastStep = null;
        Iterator it = c.getSteps().iterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            StepPriceFunctionComplete spfc = (StepPriceFunctionComplete)it.next();
            QuantityComplete q = spfc.getUpperLimit();
            double a = q.getQuantity();
            if (q.getUnit() != unit) {
                a = UnitConversionToolkit.convertUnit((UnitComplete)q.getUnit(), (UnitComplete)unit, (double)q.getQuantity(), (BasicArticleLight)article, (Timestamp)new Timestamp(System.currentTimeMillis()));
            }
            if (lastStep == null) {
                lastStep = spfc;
                continue;
            }
            if ((double)amount.intValue() > a) {
                lastStep = spfc;
                continue;
            }
            found = true;
        }
        if (lastStep != null) {
            return lastStep.getPrice();
        }
        return new PriceComplete(ccc.getSupplier().getPaymentCurrency(), Double.valueOf(0.0));
    }

    public static PriceComplete getArticleCost(SupplierConditionComplete ccc, Node childNamed, BasicArticleComplete article) {
        return OrderToolkit.getArticleCost(ccc, ((Double)childNamed.getChildNamed(new String[]{"quantity"}).getValue()).intValue(), (UnitComplete)childNamed.getChildNamed(new String[]{"unit"}).getValue(), article);
    }
}

