/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.i18n.Words;

public class SupplierScreenToolkit {
    public static String getSupplierConditionString(SupplierComplete c) {
        String t = "";
        t = "<b>" + c.getName() + "<br/><hr/></b><br/>";
        t = t + "<b>" + Words.DELIVERY_COSTS + "</b><br/>";
        t = t + "<ul>";
        t = t + "<li>" + SupplierScreenToolkit.getDeliveryCostString(c) + "</li>";
        t = t + "</ul>";
        t = t + "<b>" + Words.ADDITIONAL_DELIVERY_CONDITIONS + "</b><br/>";
        t = t + "<ul>";
        t = c.getDeliveryConditions() == null || c.getDeliveryConditions().isEmpty() ? t + "<li>" + Words.NONE + "</li>" : t + "<li>" + c.getDeliveryConditions() + "</li>";
        t = t + "</ul>";
        return t;
    }

    private static String getDeliveryCostString(SupplierComplete c) {
        switch (c.getCostType()) {
            case FIX: {
                Converter con = ConverterRegistry.getConverter(PriceConverter2.class);
                return (String)con.convert((Object)c.getDeliveryCost(), null, new Object[0]);
            }
            case MINAMOUNT: {
                Converter con = ConverterRegistry.getConverter(PriceConverter2.class);
                String t = Words.ORDERS_WITH_AMOUNT_SMALLER + " " + con.convert((Object)c.getMinOrderValue(), null, new Object[0]);
                t = t + " " + Words.SPACE_COST_SPACE + " " + con.convert((Object)c.getDeliveryCost(), null, new Object[0]);
                return t;
            }
            case NONE: {
                return Words.NONE;
            }
        }
        return "";
    }
}

