/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits.nodebased;

import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.toolkits.nodebased.NodeInterpolationStepCompleteComparator;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.recipe.ICompoundIngredient;
import ch.icit.pegasus.server.core.dtos.recipe.IIngredient;
import ch.icit.pegasus.server.core.dtos.recipe.IRecipe;
import ch.icit.pegasus.server.core.dtos.recipe.ISimpleIngredient;
import ch.icit.pegasus.server.core.dtos.recipe.InterpolationStepComplete;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantReference;
import ch.icit.pegasus.server.core.dtos.recipe.StepQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.DTOUtilException;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.recipe.CalculatedBasicArticleIngredient;
import ch.icit.pegasus.server.core.dtos.utils.recipe.CalculatedRecipe;
import ch.icit.pegasus.server.core.dtos.utils.recipe.CalculatedRecipeIngredient;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class NodeBasedRecipeCalculationToolkit {
    private static Comparator<Node<?>> interPolationStepComparator;

    private static QuantityComplete createTempQuantity(Node<QuantityComplete> q) {
        QuantityComplete qq = new QuantityComplete();
        qq.setQuantity((Double)q.getChildNamed(new String[]{"quantity"}).getValue());
        qq.setUnit((UnitComplete)q.getChildNamed(new String[]{"unit"}).getValue());
        return qq;
    }

    public static CalculatedRecipe calculateRecipeIngredients(Node<IRecipe> recipe, Node<QuantityComplete> targetQuantity, Node<CurrencyComplete> targetCurrency, CustomerReference customer, RecipeVariantAccessor variantAccessor, CurrencyVariantAccessor currencyAccessor) throws Exception {
        CalculatedRecipe calcRecipe = new CalculatedRecipe();
        calcRecipe.setRecipeVariant((IRecipe)recipe.getValue());
        QuantityComplete qq = NodeBasedRecipeCalculationToolkit.createTempQuantity(targetQuantity);
        calcRecipe.setQuantity(qq);
        double recipePrice = 0.0;
        ArrayList<CalculatedBasicArticleIngredient> calcIngredients = new ArrayList<CalculatedBasicArticleIngredient>();
        Iterator it = recipe.getChildNamed(new String[]{"ingredients"}).getChilds();
        while (it.hasNext()) {
            CalculatedBasicArticleIngredient calcIngredient;
            Node ingredient = (Node)it.next();
            QuantityComplete ingredientQuantity = UnitConversionToolkit.normalizeQuantity((QuantityComplete)NodeBasedRecipeCalculationToolkit.getIngredientQuantity((Node<IIngredient>)ingredient, (Node<QuantityComplete>)recipe.getChildNamed(new String[]{"yield"}), targetQuantity));
            EmbeddedDTONode nn = new EmbeddedDTONode();
            nn.setValue((Object)ingredientQuantity, 0L);
            PriceComplete price = new PriceComplete((CurrencyComplete)targetCurrency.getValue(), Double.valueOf(NodeBasedRecipeCalculationToolkit.getIngredientPrice((Node<IIngredient>)ingredient, (Node<QuantityComplete>)nn, (CurrencyComplete)targetCurrency.getValue(), customer, true, variantAccessor, currencyAccessor)));
            if (ingredient.getValue() instanceof ISimpleIngredient) {
                BasicArticleComplete article = (BasicArticleComplete)ingredient.getChildNamed(new String[]{"article"}).getValue();
                CalculatedBasicArticleIngredient cbai = new CalculatedBasicArticleIngredient();
                cbai.setArticle((BasicArticleLight)article);
                calcIngredient = cbai;
            } else if (ingredient.getValue() instanceof ICompoundIngredient) {
                CalculatedRecipeIngredient cri = new CalculatedRecipeIngredient();
                IRecipe r = (IRecipe)ingredient.getChildNamed(new String[]{"recipe"}).getValue();
                EmbeddedDTONode nn2 = new EmbeddedDTONode();
                nn2.setValue((Object)ingredientQuantity, 0L);
                cri.setRecipe(NodeBasedRecipeCalculationToolkit.calculateRecipeIngredients((Node<IRecipe>)ingredient.getChildNamed(new String[]{"recipe"}), (Node<QuantityComplete>)nn2, targetCurrency, customer, variantAccessor, currencyAccessor));
                calcIngredient = cri;
            } else {
                throw new DTOUtilException("Invalid Ingredient type: " + ingredient.getClass().getSimpleName());
            }
            calcIngredient.setQuantity(ingredientQuantity);
            calcIngredient.setPrice(price);
            calcIngredient.setIngredient((IIngredient)ingredient.getValue());
            calcIngredients.add(calcIngredient);
            recipePrice += price.getPrice().doubleValue();
        }
        calcRecipe.setIngredients(calcIngredients);
        calcRecipe.setPrice(new PriceComplete((CurrencyComplete)targetCurrency.getValue(), Double.valueOf(recipePrice)));
        return calcRecipe;
    }

    public static PriceComplete getPrice(Node<RecipeVariantComplete> recipe, Node<QuantityComplete> targetQuantity, CurrencyComplete targetCurrency, CustomerReference customer, RecipeVariantAccessor variantAccessor, CurrencyVariantAccessor currencyAccessor) throws Exception {
        return new PriceComplete(targetCurrency, Double.valueOf(NodeBasedRecipeCalculationToolkit.getRecipePrice(recipe, targetQuantity, targetCurrency, customer, variantAccessor, currencyAccessor)));
    }

    private static double getRecipePrice(Node<RecipeVariantComplete> recipeVariant, Node<QuantityComplete> targetQuantity, CurrencyComplete targetCurrency, CustomerReference customer, RecipeVariantAccessor variantAccessor, CurrencyVariantAccessor currencyAccessor) throws Exception {
        double value = 0.0;
        if (recipeVariant.getValue(RecipeVariantComplete.class) == null) {
            RecipeVariantComplete comp = variantAccessor.getComplete(new RecipeVariantReference(((RecipeVariantLight)recipeVariant.getValue(RecipeVariantLight.class)).getId()));
            recipeVariant.removeExistingValues();
            recipeVariant.setValue((Object)comp, 0L);
        }
        if (recipeVariant.getChildNamed(RecipeVariantComplete_.ingredients) != null) {
            Iterator it = recipeVariant.getChildNamed(RecipeVariantComplete_.ingredients).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node ingredient = (Node)it.next();
                QuantityComplete ingredientQuantity = NodeBasedRecipeCalculationToolkit.getIngredientQuantity((Node<IIngredient>)ingredient, (Node<QuantityComplete>)recipeVariant.getChildNamed(RecipeVariantLight_.yield), targetQuantity);
                if (ingredientQuantity == null) continue;
                EmbeddedDTONode nn = new EmbeddedDTONode();
                nn.setValue((Object)ingredientQuantity, 0L);
                value += NodeBasedRecipeCalculationToolkit.getIngredientPrice((Node<IIngredient>)ingredient, (Node<QuantityComplete>)nn, targetCurrency, customer, true, variantAccessor, currencyAccessor);
            }
        }
        return value;
    }

    public static QuantityComplete getIngredientQuantity(Node<IIngredient> ingredient, Node<QuantityComplete> yieldQuantity, Node<QuantityComplete> targetRecipeQuantity) throws DTOUtilException {
        Node quantityInterpolation = ingredient.getChildNamed(new String[]{"quantity"});
        if (quantityInterpolation.getValue() instanceof LinearQuantityInterpolationComplete) {
            QuantityComplete q = NodeBasedRecipeCalculationToolkit.createTempQuantity((Node<QuantityComplete>)quantityInterpolation.getChildNamed(new String[]{"resultingQuantity"}));
            if (targetRecipeQuantity == null) {
                return q;
            }
            if (yieldQuantity == null) {
                return new QuantityComplete(Double.valueOf(q.getQuantity() * (Double)targetRecipeQuantity.getChildNamed(new String[]{"quantity"}).getValue()), q.getUnit());
            }
            double targetValue = (Double)targetRecipeQuantity.getChildNamed(new String[]{"quantity"}).getValue();
            double recipeValue = UnitConversionToolkit.convertUnit((UnitComplete)((UnitComplete)yieldQuantity.getChildNamed(new String[]{"unit"}).getValue()), (UnitComplete)((UnitComplete)targetRecipeQuantity.getChildNamed(new String[]{"unit"}).getValue()), (double)((Double)yieldQuantity.getChildNamed(new String[]{"quantity"}).getValue()), null, (Timestamp)new Timestamp(System.currentTimeMillis()));
            if (recipeValue == 0.0) {
                recipeValue = 1.0;
            }
            if (q.getQuantity() == null) {
                q.setQuantity(Double.valueOf(1.0));
            }
            double factor = targetValue / recipeValue;
            return new QuantityComplete(Double.valueOf(q.getQuantity() * factor), q.getUnit());
        }
        if (quantityInterpolation.getValue() instanceof StepQuantityInterpolationComplete) {
            Node steps = quantityInterpolation.getChildNamed(new String[]{"steps"});
            return NodeBasedRecipeCalculationToolkit.resolveStep((Node<List<InterpolationStepComplete>>)steps, targetRecipeQuantity);
        }
        throw new DTOUtilException("Invalid QuantityInterpolation type: " + quantityInterpolation.getClass().getSimpleName());
    }

    public static double getIngredientPrice(Node<IIngredient> ingredient, Node<QuantityComplete> ingredientQuantity, CurrencyComplete targetCurrency, CustomerReference customer, boolean isRecipe, RecipeVariantAccessor variantAccessor, CurrencyVariantAccessor currencyAccessor) throws Exception {
        if (ingredient.getValue() instanceof ISimpleIngredient) {
            BasicArticleComplete article = (BasicArticleComplete)ingredient.getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class);
            if (article == null) {
                return 0.0;
            }
            PriceComplete articlePrice = null;
            articlePrice = Boolean.TRUE.equals(article.getCustomerIsOwner()) || Boolean.TRUE.equals(article.getExcludeFromMaterialCostCalculations()) ? new PriceComplete(targetCurrency, Double.valueOf(0.0)) : ArticlePriceCalculationToolkit.getBruttoForQuantity((BasicArticleComplete)article, (QuantityComplete)NodeBasedRecipeCalculationToolkit.createTempQuantity(ingredientQuantity), (Timestamp)new Timestamp(System.currentTimeMillis()), null, (boolean)false);
            if (!isRecipe) {
                double returnsRate = (100.0 - ArticlePriceCalculationToolkit.getArticleReturnsRate((BasicArticleComplete)article, (CustomerReference)customer)) / 100.0;
                articlePrice.setPrice(Double.valueOf(articlePrice.getPrice() / ((100.0 - ArticlePriceCalculationToolkit.getCookingWaste((BasicArticleComplete)article, (CustomerReference)customer, (boolean)false)) / 100.0)));
                articlePrice.setPrice(Double.valueOf(articlePrice.getPrice() * returnsRate));
            }
            return UnitConversionToolkit.getPriceIn((CurrencyComplete)targetCurrency, (PriceComplete)articlePrice, (CurrencyVariantAccessor)currencyAccessor, (Timestamp)new Timestamp(System.currentTimeMillis()));
        }
        if (ingredient.getValue() instanceof ICompoundIngredient) {
            return NodeBasedRecipeCalculationToolkit.getRecipePrice((Node<RecipeVariantComplete>)ingredient.getChildNamed(new String[]{"recipe", "currentVariant"}), ingredientQuantity, targetCurrency, customer, variantAccessor, currencyAccessor);
        }
        throw new DTOUtilException("Invalid Ingredient type: " + ingredient.getClass().getSimpleName());
    }

    private static void ensureComparator() {
        if (interPolationStepComparator == null) {
            interPolationStepComparator = new NodeInterpolationStepCompleteComparator();
        }
    }

    public static QuantityComplete resolveStep(Node<List<InterpolationStepComplete>> steps, Node<QuantityComplete> targetYield) throws DTOUtilException {
        if (targetYield == null) {
            throw new DTOUtilException("Failed to resolve interpolation step (target quantity is null)!");
        }
        NodeBasedRecipeCalculationToolkit.ensureComparator();
        steps.sortChilds(interPolationStepComparator);
        QuantityComplete q = new QuantityComplete();
        double lastBound = 0.0;
        Double tyq = (Double)targetYield.getChildNamed(new String[]{"quantity"}).getValue();
        if (tyq == lastBound && steps.getChildCount() >= 1) {
            Node step = steps.getChildAt(0);
            q.setClientOId(Long.valueOf(q.getNextId()));
            q = NodeBasedRecipeCalculationToolkit.createTempQuantity((Node<QuantityComplete>)step.getChildNamed(new String[]{"resultingQuantity"}));
            return q;
        }
        int c = 0;
        Iterator it = steps.getChilds();
        while (it.hasNext()) {
            Node step = (Node)it.next();
            double upBound = UnitConversionToolkit.convertUnit((UnitComplete)((UnitComplete)step.getChildNamed(new String[]{"upperBound-unit"}).getValue()), (UnitComplete)((UnitComplete)targetYield.getChildNamed(new String[]{"unit"}).getValue()), (double)((Double)step.getChildNamed(new String[]{"upperBound-quantity"}).getValue()), null, (Timestamp)new Timestamp(System.currentTimeMillis()));
            if (tyq > lastBound && tyq <= upBound) {
                q.setClientOId(Long.valueOf(q.getNextId()));
                q = NodeBasedRecipeCalculationToolkit.createTempQuantity((Node<QuantityComplete>)step.getChildNamed(new String[]{"resultingQuantity"}));
                return q;
            }
            if (++c != steps.getChildCount()) continue;
            q.setClientOId(Long.valueOf(q.getNextId()));
            q = NodeBasedRecipeCalculationToolkit.createTempQuantity((Node<QuantityComplete>)step.getChildNamed(new String[]{"resultingQuantity"}));
            return q;
        }
        return null;
    }
}

