/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.utils;

import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ManMinutesOverflowComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.product.CateringPointCostComplete;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.CompoundComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerPriceComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductPriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.DepartmentManHoursCostComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.PriceQuantityCombination;
import ch.icit.pegasus.server.core.dtos.utils.ProductRecipeAmountCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.util.Tuple;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class ProductPriceCalculationToolkit {
    public static PriceComplete getProductMaterialPrice(ProductVariantComplete product, int count, ModificationStateE state, SystemSettingsComplete settings, Timestamp validityDate, RecipeVariantAccessor accessor, CurrencyVariantAccessor currencyAccessor) throws Exception {
        Map<BasicArticleComplete, PriceQuantityCombination> map = ProductRecipeAmountCalculationToolkit.getAmount4Product(product, count, state, validityDate, accessor, currencyAccessor);
        PriceComplete price = new PriceComplete();
        price.setPrice(Double.valueOf(0.0));
        CurrencyComplete defaultCurrency = settings.getCurrency();
        price.setCurrency(defaultCurrency);
        Set<Map.Entry<BasicArticleComplete, PriceQuantityCombination>> set = map.entrySet();
        for (Map.Entry<BasicArticleComplete, PriceQuantityCombination> entry : set) {
            PriceComplete articlePrice = ArticlePriceCalculationToolkit.getBruttoForQuantity(entry.getKey(), entry.getValue().getQuantity(), entry.getValue().getPrice(), null, true, true, (CustomerReference)product.getProduct().getCustomer(), validityDate, product.getTenderVariant());
            CurrencyVariantComplete cv = (CurrencyVariantComplete)currencyAccessor.loadData(articlePrice.getCurrency(), validityDate);
            price.setPrice(Double.valueOf(articlePrice.getPrice() * cv.getExchangeRate() + price.getPrice()));
        }
        return price;
    }

    public static PriceComplete getProductPrice(ProductVariantLight product, CustomerLight customer) {
        if (customer == null) {
            return new PriceComplete(product.getSalesPrice());
        }
        for (ProductCustomerPriceComplete priceComplete : product.getCustomerPrice()) {
            if (!customer.equals((Object)priceComplete.getCustomer())) continue;
            return new PriceComplete(priceComplete.getPrice());
        }
        return new PriceComplete(product.getSalesPrice());
    }

    public static double getCookingWaste(SimpleComponentComplete comp, ModificationStateE state, CustomerReference customer, boolean tender) {
        switch (state) {
            case ACCEPTED: 
            case DRAFT: {
                return ArticlePriceCalculationToolkit.getCookingWaste(comp.getArticle(), customer, tender);
            }
        }
        return 0.0;
    }

    public static double getCookingWaste(CompoundComponentComplete comp, boolean tender, Date validity) {
        if (tender) {
            return ArticlePriceCalculationToolkit.getRecipeGroupTenderCookingWaste(comp.getRecipe().getCurrentVariant(), validity);
        }
        return ArticlePriceCalculationToolkit.getRecipeGroupProductiveCookingWaste(comp.getRecipe().getCurrentVariant(), validity);
    }

    public static PriceComplete getPrice4QuantityMap(Map<BasicArticleComplete, QuantityComplete> map, SystemSettingsComplete settings, CustomerReference customer, CurrencyVariantAccessor accessor, Timestamp validityDate, boolean useTender) {
        PriceComplete price = new PriceComplete();
        price.setPrice(Double.valueOf(0.0));
        CurrencyComplete defaultCurrency = settings.getCurrency();
        price.setCurrency(defaultCurrency);
        for (Map.Entry<BasicArticleComplete, QuantityComplete> entry : map.entrySet()) {
            PriceComplete articlePrice = ArticlePriceCalculationToolkit.getBruttoForQuantity(entry.getKey(), entry.getValue(), null, customer, validityDate, useTender);
            try {
                CurrencyVariantComplete cv = (CurrencyVariantComplete)accessor.loadData(articlePrice.getCurrency(), validityDate);
                price.setPrice(Double.valueOf(articlePrice.getPrice() * cv.getExchangeRate() + price.getPrice()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return price;
    }

    public static double getOverflowFactor(CateringPointCostComplete cpc, double count, SystemSettingsComplete settings) {
        List overflow = null;
        overflow = cpc == null || cpc.getCostCenter() == null || cpc.getCostCenter().getManMinutesOverFlow() == null || cpc.getCostCenter().getManMinutesOverFlow().isEmpty() ? settings.getManMinutesOverFlow() : cpc.getCostCenter().getManMinutesOverFlow();
        if (cpc == null || (double)cpc.getToAmount().intValue() >= count || cpc.getToAmount() == 0) {
            return 0.0;
        }
        int diff = (int)(count - (double)cpc.getToAmount().intValue());
        double difPercent = (double)diff / (double)cpc.getToAmount().intValue();
        for (ManMinutesOverflowComplete ov : overflow) {
            if (!((double)ov.getDifferenceLowerBound().intValue() <= difPercent) || !((double)ov.getDifferenceUpperBound().intValue() > difPercent)) continue;
            return ov.getTimeDiscount() / 100.0;
        }
        return 0.0;
    }

    public static void aggregateProcessCosts(Map<CostCenterComplete, Double> processCosts, ProductVariantComplete variant, int amount, Timestamp validity, RecipeVariantAccessor accessor, SystemSettingsComplete settings) throws Exception {
        ProductPriceCalculationToolkit.calcManSeconds(variant.getCateringPointCosts(), processCosts, Double.valueOf(amount), settings, validity);
        if (variant instanceof ComplexProductVariantComplete) {
            ComplexProductVariantComplete cp = (ComplexProductVariantComplete)variant;
            for (SimpleProductComponentGroupComplete g : cp.getProductComponentGroups()) {
                ProductPriceCalculationToolkit.calcManSeconds(g.getCateringPointCosts(), processCosts, Double.valueOf(amount), settings, validity);
                for (ProductComponentComplete pcc : g.getComponents()) {
                    List<CateringPointCostComplete> points = ProductPriceCalculationToolkit.readCateringPoints(pcc, amount, validity, accessor);
                    ProductPriceCalculationToolkit.calcManSeconds(points, processCosts, Double.valueOf(amount), settings, validity);
                }
            }
        }
    }

    public static List<CateringPointCostComplete> readCateringPoints(ProductComponentComplete pcc, int amount, Timestamp validity, RecipeVariantAccessor accessor) throws Exception {
        CateringPointCostComplete cateringPointCostComplete;
        Tuple key;
        if (pcc instanceof SimpleComponentComplete) {
            return pcc.getCateringPointCosts();
        }
        HashMap<Tuple, CateringPointCostComplete> map = new HashMap<Tuple, CateringPointCostComplete>();
        CompoundComponentComplete ccc = (CompoundComponentComplete)pcc;
        RecipeVariantComplete rv = (RecipeVariantComplete)accessor.loadData(ccc.getRecipe(), validity);
        for (CateringPointCostComplete cc : pcc.getCateringPointCosts()) {
            key = new Tuple((Object)cc.getCostCenter(), (Object)cc.getCabinClass());
            cateringPointCostComplete = (CateringPointCostComplete)map.get(key);
            if (cateringPointCostComplete != null || !ProductPriceCalculationToolkit.useManMinute(amount, cc)) continue;
            map.put(key, cc);
        }
        for (CateringPointCostComplete cc : rv.getCateringPointCosts()) {
            key = new Tuple((Object)cc.getCostCenter(), (Object)cc.getCabinClass());
            cateringPointCostComplete = (CateringPointCostComplete)map.get(key);
            if (cateringPointCostComplete != null || !ProductPriceCalculationToolkit.useManMinute(amount, cc)) continue;
            map.put(key, cc);
        }
        ArrayList<CateringPointCostComplete> costs = new ArrayList<CateringPointCostComplete>();
        costs.addAll(map.values());
        return costs;
    }

    public static boolean useManMinute(double amount, CateringPointCostComplete cpc) {
        if (cpc.getFromAmount() == 0 && cpc.getToAmount() == 0) {
            return true;
        }
        return amount >= (double)cpc.getFromAmount().intValue() && (amount <= (double)cpc.getToAmount().intValue() || cpc.getToAmount() == 0);
    }

    public static PriceComplete getHandlingProcessCosts(HandlingCostComplete product, int amount, SystemSettingsComplete settings) {
        CurrencyComplete currency = settings.getCurrency();
        PriceComplete p = new PriceComplete(currency, Double.valueOf(0.0));
        PriceComplete pp = ProductPriceCalculationToolkit.calculateCateringPoints(product.getCurrentVariant().getCateringPointCosts(), settings.getCurrency(), amount, settings);
        p.setPrice(Double.valueOf(pp.getPrice() * (double)amount));
        return p;
    }

    public static double getManMinutes(HandlingCostVariantComplete product, double amount, SystemSettingsComplete settings, Timestamp validity) {
        double p = ProductPriceCalculationToolkit.calculateManMinutes(product.getCateringPointCosts(), (int)amount, settings, validity);
        return p *= amount;
    }

    public static double getManHours(HandlingCostVariantComplete product, double amount, SystemSettingsComplete settings, Timestamp validity) {
        double p = ProductPriceCalculationToolkit.getManMinutes(product, amount, settings, validity);
        return p /= 60.0;
    }

    public static Map<CostCenterComplete, Double> getManHoursByDepartment(HandlingCostVariantComplete product, double amount, SystemSettingsComplete settings, Timestamp validity) {
        HashMap<CostCenterComplete, Double> manMinutes = new HashMap<CostCenterComplete, Double>();
        ProductPriceCalculationToolkit.calcManHours(product.getCateringPointCosts(), manMinutes, amount, settings, validity);
        return manMinutes;
    }

    public static double getManMinutes(ProductVariantComplete product, int amount, Timestamp validity, RecipeVariantAccessor accessor, SystemSettingsComplete settings) throws Exception {
        double p = 0.0;
        if (product instanceof ComplexProductVariantComplete) {
            ComplexProductVariantComplete cp = (ComplexProductVariantComplete)product;
            for (SimpleProductComponentGroupComplete g : cp.getProductComponentGroups()) {
                double pp = ProductPriceCalculationToolkit.calculateManMinutes(g.getCateringPointCosts(), amount, settings, validity);
                p += pp;
                for (ProductComponentComplete pcc : g.getComponents()) {
                    pp = ProductPriceCalculationToolkit.calculateManMinutes(pcc, amount, validity, accessor, settings);
                    p += pp;
                }
            }
        }
        double pp = ProductPriceCalculationToolkit.calculateManMinutes(product.getCateringPointCosts(), amount, settings, validity);
        p += pp;
        return p *= (double)amount;
    }

    public static double getManHours(ProductVariantComplete product, int amount, Timestamp validity, RecipeVariantAccessor accessor, SystemSettingsComplete settings) throws Exception {
        double p = ProductPriceCalculationToolkit.getManMinutes(product, amount, validity, accessor, settings);
        return p /= 60.0;
    }

    private static double calculateManMinutes(ProductComponentComplete comp, int amount, Timestamp validity, RecipeVariantAccessor accessor, SystemSettingsComplete settings) throws Exception {
        List<CateringPointCostComplete> newPoints = ProductPriceCalculationToolkit.readCateringPoints(comp, amount, validity, accessor);
        double pp = ProductPriceCalculationToolkit.calculateManMinutes(newPoints, amount, settings, validity);
        return pp;
    }

    private static double calculateManHour(List<CateringPointCostComplete> points, int amount, SystemSettingsComplete settings, Timestamp validityDate) {
        double d = ProductPriceCalculationToolkit.calculateManMinutes(points, amount, settings, validityDate);
        return d /= 60.0;
    }

    private static double calculateManMinutes(List<CateringPointCostComplete> points, int amount, SystemSettingsComplete settings, Timestamp validityDate) {
        double d = ProductPriceCalculationToolkit.calculateManSeconds(points, amount, settings, validityDate);
        return d /= 60.0;
    }

    private static double calculateManSeconds(List<CateringPointCostComplete> points, int amount, SystemSettingsComplete settings, Timestamp validityDate) {
        double d = 0.0;
        HashMap indexMap = new HashMap();
        for (CateringPointCostComplete cateringPointCostComplete : points) {
            Tuple key = new Tuple((Object)cateringPointCostComplete.getCostCenter(), (Object)cateringPointCostComplete.getCabinClass());
            List list = (List)indexMap.get(key);
            if (list == null) {
                list = new ArrayList();
                indexMap.put(key, list);
            }
            list.add(cateringPointCostComplete);
        }
        for (Map.Entry entry : indexMap.entrySet()) {
            Collections.sort((List)entry.getValue());
            CateringPointCostComplete found = null;
            for (CateringPointCostComplete t : (List)entry.getValue()) {
                if (!ProductPriceCalculationToolkit.useManMinute(amount, t)) continue;
                found = t;
            }
            if (found == null) {
                found = (CateringPointCostComplete)((List)entry.getValue()).get(((List)entry.getValue()).size() - 1);
            }
            PriceComplete pricePerManHour = found.getCostCenter().resolveBestPrice(validityDate);
            if (found.getPoints() == null || pricePerManHour == null) continue;
            double seconds = found.getPoints();
            double overflow = ProductPriceCalculationToolkit.getOverflowFactor(found, amount, settings);
            double dif = seconds * overflow;
            double minutes = seconds -= dif;
            if (found.getLoadFactor() != null) {
                minutes *= found.getLoadFactor().doubleValue();
            }
            d += minutes;
        }
        return d;
    }

    public static PriceComplete getProductProcessCosts(ProductVariantComplete product, int amount, SystemSettingsComplete settings, Date valididy, RecipeVariantAccessor accessor) throws Exception {
        return ProductPriceCalculationToolkit.getProductProcessCosts(product, amount, settings, null, valididy, false, accessor);
    }

    public static PriceComplete getProductProcessCosts(ProductVariantComplete product, int amount, SystemSettingsComplete settings, CustomerComplete customer, Date validity, boolean tender, RecipeVariantAccessor accessor) throws Exception {
        CurrencyComplete currency = settings.getCurrency();
        PriceComplete p = new PriceComplete(currency, Double.valueOf(0.0));
        if (product instanceof ComplexProductVariantComplete) {
            ComplexProductVariantComplete cp = (ComplexProductVariantComplete)product;
            for (SimpleProductComponentGroupComplete g : cp.getProductComponentGroups()) {
                PriceComplete pp = ProductPriceCalculationToolkit.calculateCateringPoints(g.getCateringPointCosts(), currency, customer, validity, tender, amount, settings);
                p.setPrice(Double.valueOf(p.getPrice() + pp.getPrice() * (double)amount));
                for (ProductComponentComplete pcc : g.getComponents()) {
                    pp = ProductPriceCalculationToolkit.calculateProductComponentProcessCosts(pcc, currency, amount, new Timestamp(validity.getTime()), accessor, settings);
                    p.setPrice(Double.valueOf(p.getPrice() + pp.getPrice()));
                }
            }
        }
        PriceComplete pp = ProductPriceCalculationToolkit.calculateCateringPoints(product.getCateringPointCosts(), currency, amount, settings);
        p.setPrice(Double.valueOf(p.getPrice() + pp.getPrice() * (double)amount));
        return p;
    }

    public static PriceComplete calculateProductComponentProcessCosts(ProductComponentComplete productComponent, CurrencyComplete currency, int count, Timestamp validity, RecipeVariantAccessor accessor, SystemSettingsComplete settings) throws Exception {
        return ProductPriceCalculationToolkit.calculateProductComponentProcessCosts(productComponent, currency, count, null, validity, false, accessor, settings);
    }

    public static PriceComplete calculateProductComponentProcessCosts(ProductComponentComplete productComponent, CurrencyComplete currency, int count, CustomerComplete customer, Timestamp validity, boolean tender, RecipeVariantAccessor accessor, SystemSettingsComplete settings) throws Exception {
        List<CateringPointCostComplete> newPoints = ProductPriceCalculationToolkit.readCateringPoints(productComponent, count, validity, accessor);
        PriceComplete pp = ProductPriceCalculationToolkit.calculateCateringPoints(newPoints, currency, customer, new Date(validity.getTime()), tender, count, settings);
        pp.setPrice(Double.valueOf(pp.getPrice() * (double)count));
        return pp;
    }

    public static PriceComplete calculateProductComponentGroupProcessCosts(SimpleProductComponentGroupComplete productComponent, CurrencyComplete currency, int count, SystemSettingsComplete settings) {
        return ProductPriceCalculationToolkit.calculateProductComponentGroupProcessCosts(productComponent, currency, count, null, null, false, settings);
    }

    public static PriceComplete calculateProductComponentGroupProcessCosts(SimpleProductComponentGroupComplete productComponent, CurrencyComplete currency, int count, CustomerComplete customer, Date validity, boolean tender, SystemSettingsComplete settings) {
        PriceComplete pp = ProductPriceCalculationToolkit.calculateCateringPoints(productComponent.getCateringPointCosts(), currency, customer, validity, tender, count, settings);
        pp.setPrice(Double.valueOf(pp.getPrice() * (double)count));
        return pp;
    }

    public static PriceComplete calculateCateringPoints(List<CateringPointCostComplete> cateringPoints, CurrencyComplete currency, CustomerComplete customer, Date validity, boolean tender, int count, SystemSettingsComplete settings) {
        PriceComplete p = new PriceComplete(currency, Double.valueOf(0.0));
        HashMap<Tuple, ArrayList<CateringPointCostComplete>> indexMap = new HashMap<Tuple, ArrayList<CateringPointCostComplete>>();
        for (CateringPointCostComplete cateringPointCostComplete : cateringPoints) {
            Tuple key = new Tuple((Object)cateringPointCostComplete.getCostCenter(), (Object)cateringPointCostComplete.getCabinClass());
            ArrayList<CateringPointCostComplete> list = (ArrayList<CateringPointCostComplete>)indexMap.get(key);
            if (list == null) {
                list = new ArrayList<CateringPointCostComplete>();
                indexMap.put(key, list);
            }
            list.add(cateringPointCostComplete);
        }
        for (Map.Entry entry : indexMap.entrySet()) {
            Collections.sort((List)entry.getValue());
            CateringPointCostComplete found = null;
            for (CateringPointCostComplete cppcc : (List)entry.getValue()) {
                if (!ProductPriceCalculationToolkit.useManMinute(count, cppcc)) continue;
                PriceComplete price = cppcc.getCostCenter().resolveBestPrice(validity);
                if (cppcc.getPoints() == null || price == null) continue;
                found = cppcc;
            }
            if (found == null) {
                found = (CateringPointCostComplete)((List)entry.getValue()).get(((List)entry.getValue()).size() - 1);
            }
            ProductPriceCalculationToolkit.doCalculateCateringPoints(customer, validity, tender, p, found, count, settings);
        }
        return p;
    }

    private static void doCalculateCateringPoints(CustomerComplete customer, Date validity, boolean tender, PriceComplete p, CateringPointCostComplete cppcc, int count, SystemSettingsComplete settings) {
        double points = cppcc.getPoints();
        double overflow = ProductPriceCalculationToolkit.getOverflowFactor(cppcc, count, settings);
        double dif = points * overflow;
        points -= dif;
        points /= 3600.0;
        double pricePerPoint = 0.0;
        if (tender) {
            for (DepartmentManHoursCostComplete c : customer.getManHourCosts()) {
                if (!c.getDepartment().equals((Object)cppcc.getCostCenter()) || c.getValidity().getStartDate().getTime() > validity.getTime() || c.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                pricePerPoint = c.getManHourCost().getPrice();
            }
        } else {
            pricePerPoint = cppcc.getCostCenter().resolveBestPrice(validity).getPrice();
        }
        double d = points * pricePerPoint * cppcc.getLoadFactor();
        p.setPrice(Double.valueOf(p.getPrice() + d));
    }

    public static PriceComplete calculateCateringPoints(List<CateringPointCostComplete> cateringPoints, CurrencyComplete currency, int amount, SystemSettingsComplete settings) {
        return ProductPriceCalculationToolkit.calculateCateringPoints(cateringPoints, currency, null, null, false, amount, settings);
    }

    public static PriceComplete getAdditionalCosts(ProductVariantComplete pv, PriceComplete matPrice, PriceComplete proPrice, SystemSettingsComplete settings, Date validity, RecipeVariantAccessor accessor) throws Exception {
        PriceComplete production = new PriceComplete(proPrice.getCurrency(), Double.valueOf(proPrice.getPrice() + matPrice.getPrice()));
        double additional = 0.0;
        for (ProductPriceFactorComplete a : pv.getProductPriceFactors()) {
            if (Boolean.TRUE.equals(a.getFixPrice())) {
                additional += a.getFactor().doubleValue();
                continue;
            }
            additional += production.getPrice() * (a.getFactor() / 100.0);
        }
        return new PriceComplete(production.getCurrency(), Double.valueOf(additional));
    }

    public static Map<CostCenterComplete, Double> getManHoursByDepartment(ProductVariantComplete product, Integer count, Date validity, RecipeVariantAccessor accessor, SystemSettingsComplete setttings) throws Exception {
        HashMap<CostCenterComplete, Double> manMinutes = new HashMap<CostCenterComplete, Double>();
        ProductPriceCalculationToolkit.calcManHours(product.getCateringPointCosts(), manMinutes, count.doubleValue(), setttings, new Timestamp(validity.getTime()));
        if (product instanceof ComplexProductVariantComplete) {
            ComplexProductVariantComplete cp = (ComplexProductVariantComplete)product;
            for (SimpleProductComponentGroupComplete g : cp.getProductComponentGroups()) {
                ProductPriceCalculationToolkit.calcManHours(g.getCateringPointCosts(), manMinutes, count.doubleValue(), setttings, new Timestamp(validity.getTime()));
                for (ProductComponentComplete c : g.getComponents()) {
                    List<CateringPointCostComplete> newPoints = ProductPriceCalculationToolkit.readCateringPoints(c, count, new Timestamp(validity.getTime()), accessor);
                    ProductPriceCalculationToolkit.calcManHours(newPoints, manMinutes, count.doubleValue(), setttings, new Timestamp(validity.getTime()));
                }
            }
        }
        return manMinutes;
    }

    private static void calcManHours(List<CateringPointCostComplete> points, Map<CostCenterComplete, Double> manMinutes, Double count, SystemSettingsComplete settings, Timestamp validity) {
        HashMap<CostCenterComplete, Double> newMap = new HashMap<CostCenterComplete, Double>();
        ProductPriceCalculationToolkit.calcManSeconds(points, newMap, count, settings, validity);
        for (CostCenterComplete key : newMap.keySet()) {
            Double double1 = manMinutes.get(key);
            Double double2 = (Double)newMap.get(key);
            if (double1 == null) {
                double1 = 0.0;
            }
            if (double2 == null) {
                double2 = 0.0;
            }
            double2 = double2 / 3600.0;
            manMinutes.put(key, double1 + double2);
        }
    }

    private static void calcManMinutes(List<CateringPointCostComplete> points, Map<CostCenterComplete, Double> manMinutes, Double count, SystemSettingsComplete settings, Timestamp validity) {
        HashMap<CostCenterComplete, Double> newMap = new HashMap<CostCenterComplete, Double>();
        ProductPriceCalculationToolkit.calcManSeconds(points, newMap, count, settings, validity);
        for (CostCenterComplete key : newMap.keySet()) {
            Double double1 = manMinutes.get(key);
            Double double2 = (Double)newMap.get(key);
            if (double1 == null) {
                double1 = 0.0;
            }
            if (double2 == null) {
                double2 = 0.0;
            }
            double2 = double2 / 60.0;
            manMinutes.put(key, double1 + double2);
        }
    }

    private static void calcManSeconds(List<CateringPointCostComplete> points, Map<CostCenterComplete, Double> manMinutes, Double count, SystemSettingsComplete settings, Timestamp validity) {
        HashMap indexMap = new HashMap();
        for (CateringPointCostComplete cateringPointCostComplete : points) {
            Tuple key = new Tuple((Object)cateringPointCostComplete.getCostCenter(), (Object)cateringPointCostComplete.getCabinClass());
            List list = (List)indexMap.get(key);
            if (list == null) {
                list = new ArrayList();
                indexMap.put(key, list);
            }
            list.add(cateringPointCostComplete);
        }
        for (Map.Entry entry : indexMap.entrySet()) {
            Double double1;
            Collections.sort((List)entry.getValue());
            CateringPointCostComplete found = null;
            for (CateringPointCostComplete t : (List)entry.getValue()) {
                if (!ProductPriceCalculationToolkit.useManMinute(count, t)) continue;
                found = t;
            }
            if (found == null) {
                found = (CateringPointCostComplete)((List)entry.getValue()).get(((List)entry.getValue()).size() - 1);
            }
            PriceComplete price = found.getCostCenter().resolveBestPrice(validity);
            if (found.getPoints() == null || price == null) continue;
            double seconds = found.getPoints();
            double overflow = ProductPriceCalculationToolkit.getOverflowFactor(found, count, settings);
            double dif = seconds * overflow;
            double hours = seconds -= dif;
            if (found.getLoadFactor() != null) {
                hours *= found.getLoadFactor().doubleValue();
            }
            if ((double1 = manMinutes.get(found.getCostCenter())) == null) {
                double1 = 0.0;
            }
            double1 = double1 + hours;
            manMinutes.put((CostCenterComplete)found.getCostCenter(), double1);
        }
    }
}

