/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.utils;

import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.CateringPointCostComplete;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.CompoundComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerDiscountsComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerPriceComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerTaxRatesComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductPriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.SoBProductConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.CompoundIngredientComplete;
import ch.icit.pegasus.server.core.dtos.recipe.IngredientComplete;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.QuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.SimpleIngredientComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RecipeProductConversionToolkit {
    public static IngredientComplete convertToIngredient(BasicArticleComplete article, UnitComplete kgUnit, UnitComplete stUnit, int nr, Timestamp validity) {
        SimpleIngredientComplete ic = new SimpleIngredientComplete();
        ic.setClientOId(Long.valueOf(ADTO.getNextId()));
        ic.setArticle(article);
        ic.setSequenceNumber(Integer.valueOf(nr));
        QuantityComplete qc = new QuantityComplete();
        qc.setClientOId(Long.valueOf(qc.getNextId()));
        qc.setQuantity(Double.valueOf(0.0));
        QuantityComplete qc2 = new QuantityComplete();
        qc2.setClientOId(Long.valueOf(qc2.getNextId()));
        qc2.setQuantity(Double.valueOf(0.0));
        PackagingQuantityBaseComplete base = UnitConversionToolkit.getPackingQuantity((BasicArticleLight)article, validity);
        Collections.sort(base.getPackingQuantities());
        PackagingQuantityComplete cq = (PackagingQuantityComplete)base.getPackingQuantities().get(base.getPackingQuantities().size() - 1);
        UnitComplete usedUnit = cq.getUnit();
        int convertible = UnitConversionToolkit.isUnitContaining(article.getPriceUnit(), stUnit, (BasicArticleLight)article, validity);
        if (convertible != 11) {
            usedUnit = stUnit;
        } else {
            convertible = UnitConversionToolkit.isUnitContaining(article.getPriceUnit(), kgUnit, (BasicArticleLight)article, validity);
            if (convertible != 11) {
                usedUnit = kgUnit;
            }
        }
        qc2.setUnit(usedUnit);
        qc.setUnit(usedUnit);
        LinearQuantityInterpolationComplete lq = new LinearQuantityInterpolationComplete();
        lq.setClientOId(Long.valueOf(ADTO.getNextId()));
        lq.setResultingQuantity(qc);
        LinearQuantityInterpolationComplete lq2 = new LinearQuantityInterpolationComplete();
        lq2.setClientOId(Long.valueOf(ADTO.getNextId()));
        lq2.setResultingQuantity(qc2);
        ic.setQuantity((QuantityInterpolationComplete)lq);
        ic.setNettoQuantity((QuantityInterpolationComplete)lq2);
        return ic;
    }

    public static IngredientComplete convertToIngredient(RecipeVariantComplete recipeVariant, int nr) {
        CompoundIngredientComplete ic = new CompoundIngredientComplete();
        ic.setClientOId(Long.valueOf(ADTO.getNextId()));
        ic.setRecipe(recipeVariant.getRecipe());
        ic.setSequenceNumber(Integer.valueOf(nr));
        QuantityComplete qc = new QuantityComplete();
        qc.setClientOId(Long.valueOf(qc.getNextId()));
        qc.setQuantity(Double.valueOf(0.0));
        qc.setUnit(recipeVariant.getYield().getUnit());
        LinearQuantityInterpolationComplete lq = new LinearQuantityInterpolationComplete();
        lq.setClientOId(Long.valueOf(ADTO.getNextId()));
        lq.setResultingQuantity(qc);
        ic.setQuantity((QuantityInterpolationComplete)lq);
        QuantityComplete qc2 = new QuantityComplete();
        qc2.setClientOId(Long.valueOf(qc2.getNextId()));
        qc2.setQuantity(Double.valueOf(0.0));
        qc2.setUnit(recipeVariant.getYield().getUnit());
        LinearQuantityInterpolationComplete lq2 = new LinearQuantityInterpolationComplete();
        lq2.setClientOId(Long.valueOf(ADTO.getNextId()));
        lq2.setResultingQuantity(qc2);
        ic.setNettoQuantity((QuantityInterpolationComplete)lq2);
        return ic;
    }

    public static ProductComponentComplete convertToProductComponent(BasicArticleComplete article, QuantityInterpolationComplete brutto, QuantityInterpolationComplete netto, UnitComplete stUnit, UnitComplete kgUnit, Timestamp validityDate, CustomerReference customer, boolean useTender) {
        QuantityComplete qc;
        LinearQuantityInterpolationComplete lq;
        SimpleComponentComplete sc = new SimpleComponentComplete();
        if (article.getDefaultProductionDepartment() instanceof InternalCostCenterComplete) {
            sc.setCostCenter((InternalCostCenterComplete)article.getDefaultProductionDepartment());
        }
        PriceComplete p = new PriceComplete();
        p.setClientOId(Long.valueOf(p.getNextId()));
        PriceComplete p3 = ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)article, validityDate, customer, useTender);
        p.setPrice(p3.getPrice());
        p.setCurrency(p3.getCurrency());
        sc.setClientOId(Long.valueOf(ADTO.getNextId()));
        sc.setArticle(article);
        UnitComplete usedUnit = article.getBaseUnit();
        if (brutto == null) {
            lq = new LinearQuantityInterpolationComplete();
            lq.setClientOId(Long.valueOf(ADTO.getNextId()));
            qc = new QuantityComplete();
            qc.setClientOId(Long.valueOf(qc.getNextId()));
            qc.setQuantity(Double.valueOf(0.0));
            qc.setUnit(usedUnit);
            lq.setResultingQuantity(qc);
            sc.setQuantity((QuantityInterpolationComplete)lq);
        } else {
            sc.setQuantity(CopyTemplateToolkit.copyQuantityInterpolation(brutto));
        }
        if (netto == null) {
            lq = new LinearQuantityInterpolationComplete();
            lq.setClientOId(Long.valueOf(ADTO.getNextId()));
            qc = new QuantityComplete();
            qc.setClientOId(Long.valueOf(qc.getNextId()));
            qc.setQuantity(Double.valueOf(0.0));
            qc.setUnit(usedUnit);
            lq.setResultingQuantity(qc);
            sc.setNettoQuantity((QuantityInterpolationComplete)lq);
        } else {
            sc.setNettoQuantity(CopyTemplateToolkit.copyQuantityInterpolation(netto));
        }
        return sc;
    }

    public static ProductComponentComplete convertToProductComponent(RecipeVariantComplete recipeVariant, QuantityInterpolationComplete brutto, QuantityInterpolationComplete netto, Timestamp validityDate, RecipeVariantAccessor accessor, UnitComplete stUnit, UnitComplete kgUnit, CustomerReference customer, boolean useTender) throws Exception {
        QuantityComplete qc;
        LinearQuantityInterpolationComplete lq;
        CompoundComponentComplete cc = new CompoundComponentComplete();
        cc.setClientOId(Long.valueOf(ADTO.getNextId()));
        cc.setRecipe(recipeVariant.getRecipe());
        if (recipeVariant.getDefaultCostCenter() instanceof InternalCostCenterComplete) {
            cc.setCostCenter((InternalCostCenterComplete)recipeVariant.getDefaultCostCenter());
        }
        if (brutto == null) {
            lq = new LinearQuantityInterpolationComplete();
            lq.setClientOId(Long.valueOf(ADTO.getNextId()));
            qc = new QuantityComplete();
            qc.setClientOId(Long.valueOf(qc.getNextId()));
            qc.setQuantity(Double.valueOf(0.0));
            qc.setUnit(recipeVariant.getYield().getUnit());
            lq.setResultingQuantity(qc);
            cc.setQuantity((QuantityInterpolationComplete)lq);
            lq.setResultingQuantity(qc);
        } else {
            cc.setQuantity(CopyTemplateToolkit.copyQuantityInterpolation(brutto));
        }
        if (netto == null) {
            lq = new LinearQuantityInterpolationComplete();
            lq.setClientOId(Long.valueOf(ADTO.getNextId()));
            qc = new QuantityComplete();
            qc.setClientOId(Long.valueOf(qc.getNextId()));
            qc.setQuantity(Double.valueOf(0.0));
            qc.setUnit(recipeVariant.getYield().getUnit());
            lq.setResultingQuantity(qc);
            cc.setNettoQuantity((QuantityInterpolationComplete)lq);
            lq.setResultingQuantity(qc);
        } else {
            cc.setNettoQuantity(CopyTemplateToolkit.copyQuantityInterpolation(netto));
        }
        ArrayList<ProductComponentComplete> components = new ArrayList<ProductComponentComplete>();
        for (IngredientComplete ing : recipeVariant.getIngredients()) {
            ProductComponentComplete nIng = null;
            if (ing instanceof SimpleIngredientComplete) {
                SimpleIngredientComplete sIng = (SimpleIngredientComplete)ing;
                nIng = RecipeProductConversionToolkit.convertToProductComponent(sIng.getArticle(), sIng.getQuantity(), sIng.getNettoQuantity(), stUnit, kgUnit, validityDate, customer, useTender);
                nIng.setNumber(ing.getSequenceNumber());
            } else if (ing instanceof CompoundIngredientComplete) {
                CompoundIngredientComplete cIng = (CompoundIngredientComplete)ing;
                RecipeVariantComplete variant = (RecipeVariantComplete)accessor.loadData(cIng.getUnderlyingRecipe(), validityDate);
                nIng = RecipeProductConversionToolkit.convertToProductComponent(variant, cIng.getQuantity(), cIng.getNettoQuantity(), validityDate, accessor, stUnit, kgUnit, customer, useTender);
                nIng.setNumber(ing.getSequenceNumber());
            }
            if (nIng instanceof SimpleComponentComplete) {
                ((SimpleComponentComplete)nIng).setAutoCalculateBrutto(Boolean.valueOf(false));
            }
            components.add(nIng);
        }
        return cc;
    }

    public static ProductVariantComplete copyProductVariant(ProductVariantComplete source, ProductVariantComplete destination) {
        destination.setClientOId(Long.valueOf(ADTO.getNextId()));
        destination.setUseMasterDataForProductGroupTypes(source.getUseMasterDataForProductGroupTypes());
        destination.setName(source.getName());
        destination.setExcludeFromAutoTaxing(source.getExcludeFromAutoTaxing());
        destination.setDeliveryUnit(source.getDeliveryUnit());
        destination.setCustomerProductNumber(source.getCustomerProductNumber());
        destination.setLabelName(source.getLabelName());
        destination.setFlightCheckerName(source.getFlightCheckerName());
        destination.setProduct(source.getProduct());
        destination.setShowOnDailyOpsSheet(source.getShowOnDailyOpsSheet());
        destination.setPriceComment(source.getPriceComment());
        destination.setDepartment(source.getDepartment());
        destination.setCalculateBrutto(source.getCalculateBrutto());
        destination.setCalculateNetto(source.getCalculateNetto());
        destination.setNettoWeight(source.getNettoWeight());
        destination.setBruttoWeight(source.getBruttoWeight());
        destination.setSapNumber(source.getSapNumber());
        destination.setCreateRetailInMotionTransactions(source.getCreateRetailInMotionTransactions());
        destination.setPaxMealType(source.getPaxMealType());
        destination.setIngredientText(source.getIngredientText());
        destination.setBarCode(source.getBarCode());
        destination.setCommission(source.getCommission());
        destination.setPackSize(source.getPackSize());
        destination.setProductsPerLabel(source.getProductsPerLabel());
        destination.setLongIngredientText(source.getLongIngredientText());
        destination.setDefaultDeliveryNumber(source.getDefaultDeliveryNumber());
        destination.setStandardProduct(source.getStandardProduct());
        destination.setAlaCarteProduct(source.getAlaCarteProduct());
        destination.setSpmlProduct(source.getSpmlProduct());
        destination.setMenuTypes(source.getMenuTypes());
        destination.setHideOnLabel(source.getHideOnLabel());
        destination.setHandlingCosts(source.getHandlingCosts());
        destination.setAdditional(source.getAdditional());
        destination.setAircraftType(source.getAircraftType());
        destination.setBoundDirection(source.getBoundDirection());
        destination.setCabinClasses(source.getCabinClasses());
        destination.setFixedPrice(source.getFixedPrice());
        destination.setCategory(source.getCategory());
        destination.setState(ModificationStateE.DRAFT);
        destination.setProductCycle(source.getProductCycle());
        destination.setAdditionalComment(source.getAdditionalComment());
        destination.setInternalVariantComment(source.getInternalVariantComment());
        destination.setAlwaysOnDeliverySlip(source.getAlwaysOnDeliverySlip());
        destination.setMealType(source.getMealType());
        destination.setProductType(source.getProductType());
        destination.setProductToMealMultiplier(source.getProductToMealMultiplier());
        destination.setPaxName(source.getPaxName());
        destination.setTenderVariant(source.getTenderVariant());
        destination.setDefaultLabelColor(source.getDefaultLabelColor());
        destination.setDefaultInsertType(source.getDefaultInsertType());
        destination.setHaulTypes(source.getHaulTypes());
        destination.setMaterialPrice(RecipeProductConversionToolkit.copyPrice(source.getMaterialPrice()));
        destination.setValidityPeriod(RecipeProductConversionToolkit.copyPeriod(source.getValidityPeriod()));
        if (source.getSobConfiguration() != null && source.getProduct().getSalesOnBoard().booleanValue()) {
            destination.setSobConfiguration(RecipeProductConversionToolkit.copySobProductConfiguration(source.getSobConfiguration()));
        }
        for (ProductCustomerPriceComplete priceComplete : source.getCustomerPrice()) {
            ProductCustomerPriceComplete newPrice = new ProductCustomerPriceComplete();
            newPrice.setCustomer(priceComplete.getCustomer());
            newPrice.setPrice(new PriceComplete(priceComplete.getPrice()));
            destination.getCustomerPrice().add(newPrice);
        }
        for (ProductCustomerDiscountsComplete productCustomerDiscountsComplete : source.getCustomerDiscounts()) {
            ProductCustomerDiscountsComplete newDiscount = new ProductCustomerDiscountsComplete();
            newDiscount.setCustomer(productCustomerDiscountsComplete.getCustomer());
            newDiscount.setDiscount(productCustomerDiscountsComplete.getDiscount());
            destination.getCustomerDiscounts().add(newDiscount);
        }
        for (Object productCustomerTaxRatesComplete : source.getCustomerTaxRates()) {
            ProductCustomerTaxRatesComplete taxRatesComplete = new ProductCustomerTaxRatesComplete();
            taxRatesComplete.setCustomer(productCustomerTaxRatesComplete.getCustomer());
            taxRatesComplete.setTaxRate(productCustomerTaxRatesComplete.getTaxRate());
            destination.getCustomerTaxRates().add(taxRatesComplete);
        }
        destination.setSalesPrice(RecipeProductConversionToolkit.copyPrice(source.getSalesPrice()));
        destination.setSeason(source.getSeason());
        destination.setServiceTypes(source.getServiceTypes());
        destination.setMenuTypes(source.getMenuTypes());
        List cateringPoints = destination.getCateringPointCosts();
        for (CateringPointCostComplete c : source.getCateringPointCosts()) {
            CateringPointCostComplete nc = RecipeProductConversionToolkit.copyCateringPointCost(c);
            if (nc == null) continue;
            cateringPoints.add(nc);
        }
        List factors = destination.getProductPriceFactors();
        for (ProductPriceFactorComplete f : source.getProductPriceFactors()) {
            ProductPriceFactorComplete nf = RecipeProductConversionToolkit.copyProductPriceFactor(f);
            if (nf == null) continue;
            factors.add(nf);
        }
        destination.setDiscounts(source.getDiscounts());
        destination.setTaxRates(source.getTaxRates());
        destination.setCrewPrice(RecipeProductConversionToolkit.copyPrice(source.getCrewPrice()));
        return destination;
    }

    private static SoBProductConfigurationComplete copySobProductConfiguration(SoBProductConfigurationComplete o) {
        if (o == null) {
            return null;
        }
        SoBProductConfigurationComplete destination = new SoBProductConfigurationComplete();
        destination.setClientOId(Long.valueOf(ADTO.getNextId()));
        destination.setComplimentary(o.getComplimentary());
        destination.setConversionFactor(o.getConversionFactor());
        destination.setCrew(o.getCrew());
        destination.setNormal(o.getNormal());
        destination.setReceiptRequired(o.getReceiptRequired());
        destination.setSobPrice(RecipeProductConversionToolkit.copyPrice(o.getSobPrice()));
        destination.setSobUnit(o.getSobUnit());
        destination.setStockCheck(o.getStockCheck());
        destination.setUpliftable(o.getUpliftable());
        return destination;
    }

    private static PeriodComplete copyPeriod(PeriodComplete period) {
        PeriodComplete copy = new PeriodComplete();
        copy.setClientOId(Long.valueOf(ADTO.getNextId()));
        copy.setEndDate(period.getEndDate());
        copy.setStartDate(period.getStartDate());
        return copy;
    }

    private static ProductPriceFactorComplete copyProductPriceFactor(ProductPriceFactorComplete sp) {
        if (sp == null) {
            return null;
        }
        ProductPriceFactorComplete np = new ProductPriceFactorComplete();
        np.setClientOId(Long.valueOf(ADTO.getNextId()));
        np.setFactor(sp.getFactor());
        np.setFixPrice(sp.getFixPrice());
        np.setPrint(sp.getPrint());
        np.setSalesPriceFactor(sp.getSalesPriceFactor());
        return np;
    }

    private static CateringPointCostComplete copyCateringPointCost(CateringPointCostComplete source) {
        if (source == null) {
            return null;
        }
        CateringPointCostComplete c = new CateringPointCostComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        c.setCostCenter(source.getCostCenter());
        c.setPoints(source.getPoints());
        c.setLoadFactor(source.getLoadFactor());
        c.setCabinClass(source.getCabinClass());
        c.setFromAmount(source.getFromAmount());
        c.setToAmount(source.getToAmount());
        return c;
    }

    private static PriceComplete copyPrice(PriceComplete p) {
        if (p == null) {
            return null;
        }
        PriceComplete np = new PriceComplete();
        np.setClientOId(Long.valueOf(np.getNextId()));
        np.setPrice(p.getPrice());
        np.setCurrency(p.getCurrency());
        return np;
    }

    public static SimpleProductVariantComplete convertToSimpleProduct(ProductVariantComplete source) {
        SimpleProductVariantComplete destination = new SimpleProductVariantComplete();
        if (source == null) {
            return destination;
        }
        RecipeProductConversionToolkit.copyProductVariant(source, (ProductVariantComplete)destination);
        return destination;
    }

    public static ComplexProductVariantComplete convertToComplexProduct(ProductVariantComplete source) {
        ComplexProductVariantComplete destination = new ComplexProductVariantComplete();
        if (source == null) {
            return destination;
        }
        RecipeProductConversionToolkit.copyProductVariant(source, (ProductVariantComplete)destination);
        return destination;
    }
}

