/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.utils;

import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.LocationStoreAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreTypeE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class StoreToolkit {
    public static Map<StorePositionLight, StoreQuantityComplete> filter(Map<StorePositionLight, StoreQuantityComplete> map, TransactionType type, UserComplete user, SystemSettingsComplete settings) {
        HashMap<StorePositionLight, StoreQuantityComplete> filteredMap = new HashMap<StorePositionLight, StoreQuantityComplete>();
        if (map == null) {
            return filteredMap;
        }
        for (Map.Entry<StorePositionLight, StoreQuantityComplete> next : map.entrySet()) {
            if (!StoreToolkit.isAllowed(next.getKey().getStore(), type, user, settings)) continue;
            filteredMap.put(next.getKey(), next.getValue());
        }
        return filteredMap;
    }

    public static UnitComplete getStoreUnit(BasicArticleLight article, StoreLight store) {
        return StoreToolkit.getInventoryUnit(article, store);
    }

    public static UnitComplete getInventoryUnit(BasicArticleLight article, StoreLight store) {
        if (store == null) {
            return article.getFloatStoreUnit();
        }
        return Boolean.TRUE.equals(store.getMainStore()) ? article.getMainStoreUnit() : article.getFloatStoreUnit();
    }

    public static String validate(BasicArticleLight article, Timestamp validity, TransactionType type, StoreLight origin, StoreLight destination, UserComplete user, SystemSettingsComplete settings) {
        Allowance allowance = StoreToolkit.validate(origin, destination, type, user, settings);
        return allowance.getWarning();
    }

    public static List<UnitComplete> getPossibleUnits(ArticleChargeComplete charge, TransactionType type, UserComplete currentUser, StoreLight origin, StoreLight destination, SystemSettingsComplete settings) {
        Allowance allowance = StoreToolkit.validate(origin, destination, type, currentUser, settings);
        boolean allowed = allowance.getAllowed();
        boolean anyUnitAllowed = allowance.getAnyUnitAllowed();
        ArrayList<UnitComplete> units = new ArrayList<UnitComplete>();
        if (!allowed || charge == null) {
            return units;
        }
        if (!anyUnitAllowed) {
            return StoreToolkit.getAllowedUnits(null, null, charge, type, origin, destination, settings);
        }
        ArrayList copy = new ArrayList(charge.getPackingQuantities());
        Collections.sort(copy);
        for (PackagingQuantityComplete currentConversion : copy) {
            UnitComplete unit = currentConversion.getUnit();
            units.addAll(UnitConversionToolkit.getAllUnits(unit));
        }
        return units;
    }

    public static List<UnitComplete> getPossibleUnits(BasicArticleLight article, SupplierConditionComplete condition, Timestamp validity, TransactionType type, UserComplete currentUser, StoreLight origin, StoreLight destination, SystemSettingsComplete settings) {
        Allowance allowance = StoreToolkit.validate(origin, destination, type, currentUser, settings);
        ArrayList<UnitComplete> units = new ArrayList<UnitComplete>();
        boolean allowed = allowance.getAllowed();
        boolean anyUnitAllowed = allowance.getAnyUnitAllowed();
        if (!allowed || article == null) {
            return units;
        }
        if (type == TransactionType.REQUISITION && Boolean.TRUE.equals(settings.getCreateRequisitionInMainStoreUnitOnly())) {
            if (article.getMainStoreUnit().getUnitSystem() != null) {
                for (UnitComplete unit = article.getMainStoreUnit().getUnitSystem().getMaxUnit(); unit != null; unit = unit.getSubUnit()) {
                    units.add(unit);
                }
            }
            return units;
        }
        if (type == TransactionType.PURCHASE || type == TransactionType.PURCHASE_RECEIVE) {
            if (article.getMainStoreUnit().getUnitSystem() != null) {
                for (UnitComplete unit = article.getMainStoreUnit().getUnitSystem().getMaxUnit(); unit != null; unit = unit.getSubUnit()) {
                    units.add(unit);
                }
            }
            return units;
        }
        if (!anyUnitAllowed) {
            return StoreToolkit.getAllowedUnits(article, condition, null, type, origin, destination, settings);
        }
        PackagingQuantityBaseComplete base = UnitConversionToolkit.getPackingQuantity(article, validity);
        ArrayList copy = new ArrayList(base.getPackingQuantities());
        Collections.sort(copy);
        for (PackagingQuantityComplete currentConversion : copy) {
            UnitComplete unit = currentConversion.getUnit();
            units.addAll(UnitConversionToolkit.getAllUnits(unit));
        }
        return units;
    }

    public static boolean isAllowed(StoreLight store, TransactionType type, UserComplete user, SystemSettingsComplete settings) {
        switch (type) {
            case CHECK_IN: {
                return StoreToolkit.validate(null, store, type, user, settings).getAllowed();
            }
            case CHECK_OUT: {
                return StoreToolkit.validate(store, null, type, user, settings).getAllowed();
            }
            case MOVE_IN: {
                return StoreToolkit.validate(null, store, TransactionType.MOVEMENT, user, settings).getAllowed();
            }
            case MOVE_OUT: {
                return StoreToolkit.validate(store, null, TransactionType.MOVEMENT, user, settings).getAllowed();
            }
            case INVENTORY: {
                return StoreToolkit.validate(store, store, type, user, settings).getAllowed();
            }
            case REQUISITION_RECEIVE: {
                return StoreToolkit.validate(null, store, type, user, settings).getAllowed();
            }
            case REQUISITION_DELIVER: {
                return StoreToolkit.validate(store, null, type, user, settings).getAllowed();
            }
            case PURCHASE_RECEIVE: {
                return StoreToolkit.validate(null, store, type, user, settings).getAllowed();
            }
            case INTERNAL_CONSUMPTION: {
                return StoreToolkit.validate(store, store, type, user, settings).getAllowed();
            }
        }
        return false;
    }

    private static List<UnitComplete> getAllowedUnits(BasicArticleLight article, SupplierConditionComplete supplierCondition, ArticleChargeComplete charge, TransactionType type, StoreLight origin, StoreLight destination, SystemSettingsComplete settings) {
        BasicArticleLight basicArticle;
        ArrayList<UnitComplete> units = new ArrayList<UnitComplete>();
        BasicArticleLight basicArticleLight = basicArticle = charge != null ? charge.getBasicArticle() : article;
        if (TransactionType.INTERNAL_CONSUMPTION.equals((Object)type)) {
            units.addAll(UnitConversionToolkit.getAllUnits(basicArticle.getBaseUnit()));
        } else if (TransactionType.PURCHASE.equals((Object)type) || TransactionType.PURCHASE_RECEIVE.equals((Object)type)) {
            if (Boolean.TRUE.equals(settings.getUseDifferentPurchaseOrderUnits()) && supplierCondition != null) {
                units.add(supplierCondition.getMinOrderAmountUnit());
            }
            units.add(basicArticle.getMainStoreUnit());
        } else if (origin != null && destination != null) {
            if (destination.getMainStore().booleanValue() || origin.getMainStore().booleanValue()) {
                units.add(basicArticle.getMainStoreUnit());
            } else {
                units.add(basicArticle.getFloatStoreUnit());
            }
        } else if (origin != null) {
            if (origin.getMainStore().booleanValue()) {
                units.add(basicArticle.getMainStoreUnit());
            } else {
                units.add(basicArticle.getFloatStoreUnit());
            }
        } else if (destination != null) {
            if (destination.getMainStore().booleanValue()) {
                units.add(basicArticle.getMainStoreUnit());
            } else {
                units.add(basicArticle.getFloatStoreUnit());
            }
        } else if (TransactionType.REQUISITION.equals((Object)type)) {
            units.add(basicArticle.getMainStoreUnit());
            units.add(basicArticle.getFloatStoreUnit());
        } else if (TransactionType.INTERNAL_CONSUMPTION.equals((Object)type) || TransactionType.IN_RECIPE.equals((Object)type) || TransactionType.IN_PRODUCT.equals((Object)type) || TransactionType.IN_HANDLING.equals((Object)type) || TransactionType.IN_STOWING_LIST.equals((Object)type)) {
            units.addAll(UnitConversionToolkit.getAllUnits(basicArticle.getBaseUnit()));
        }
        return units;
    }

    private static Allowance validate(StoreLight origin, StoreLight destination, TransactionType type, UserComplete currentUser, SystemSettingsComplete settings) {
        Allowance allowance = new Allowance(true, true);
        if (Boolean.TRUE.equals(settings.getAccessRightsForMovementRestrictionsActive())) {
            boolean storeAccessRightFound = false;
            allowance.setAllowed(false);
            allowance.setAnyUnitAllowed(false);
            if (settings.getStoreAccessRightsForMovementRestrictionsActive().booleanValue()) {
                for (LocationStoreAccessRightComplete accessRight : currentUser.getStoreConfigurations()) {
                    if (!accessRight.getStore().equals((Object)destination)) continue;
                    allowance.invoke(accessRight, type, origin, destination, settings);
                    storeAccessRightFound = true;
                    break;
                }
            }
            if (!storeAccessRightFound) {
                LocationStoreAccessRightComplete accessRight = currentUser.getDefaultStoreConfiguration();
                allowance.invoke(accessRight, type, origin, destination, settings);
            }
        }
        return allowance;
    }

    private static class Allowance {
        private LocationStoreAccessRightComplete access;
        private BasicArticleLight article;
        private boolean allowed = true;
        private boolean anyUnitAllowed = true;
        private String warning;

        public Allowance(LocationStoreAccessRightComplete access, BasicArticleLight article) {
            this.access = access;
            this.article = article;
        }

        public Allowance(boolean allowed, boolean anyUnitAllowed) {
            this.allowed = allowed;
            this.anyUnitAllowed = anyUnitAllowed;
        }

        public boolean getAllowed() {
            return this.allowed;
        }

        public boolean getAnyUnitAllowed() {
            return this.anyUnitAllowed;
        }

        public String getWarning() {
            return this.warning;
        }

        public void setWarning(String warning) {
            this.warning = warning;
        }

        public void setAllowed(boolean allowed) {
            this.allowed = allowed;
        }

        public void setAnyUnitAllowed(boolean anyUnitAllowed) {
            this.anyUnitAllowed = anyUnitAllowed;
        }

        public void invoke(LocationStoreAccessRightComplete defaultStoreConfiguration, TransactionType type, StoreLight origin, StoreLight destination, SystemSettingsComplete settingsComplete) {
            switch (type) {
                case INTERNAL_CONSUMPTION: {
                    this.allowed = Boolean.TRUE.equals(settingsComplete.getStoreAccessRightsForMovementRestrictionsActive()) ? (origin != null ? (origin.getMainStore().booleanValue() ? (defaultStoreConfiguration.getCanConsumeFromMainStore() != null ? defaultStoreConfiguration.getCanConsumeFromMainStore() : false) : (defaultStoreConfiguration.getCanConsumeFromFloatStore() != null ? defaultStoreConfiguration.getCanConsumeFromFloatStore() : false)) : true) : true;
                    this.anyUnitAllowed = true;
                    break;
                }
                case IN_STOWING_LIST: {
                    this.allowed = true;
                    this.anyUnitAllowed = defaultStoreConfiguration.getCanStowInAnyUnit() != null ? defaultStoreConfiguration.getCanStowInAnyUnit() : false;
                    break;
                }
                case IN_HANDLING: {
                    this.allowed = true;
                    this.anyUnitAllowed = defaultStoreConfiguration.getCanUseInHandlingInAnyUnit() != null ? defaultStoreConfiguration.getCanUseInHandlingInAnyUnit() : false;
                    break;
                }
                case IN_PRODUCT: {
                    this.allowed = true;
                    this.anyUnitAllowed = defaultStoreConfiguration.getCanUseInProductInAnyUnit() != null ? defaultStoreConfiguration.getCanUseInProductInAnyUnit() : false;
                    break;
                }
                case IN_RECIPE: {
                    this.allowed = true;
                    this.anyUnitAllowed = defaultStoreConfiguration.getCanUseInRecipeInAnyUnit() != null ? defaultStoreConfiguration.getCanUseInRecipeInAnyUnit() : false;
                    break;
                }
                case REQUISITION: {
                    this.allowed = true;
                    this.anyUnitAllowed = false;
                    break;
                }
                case REQUISITION_DELIVER: {
                    if (Boolean.TRUE.equals(settingsComplete.getStoreAccessRightsForMovementRestrictionsActive())) {
                        if (origin != null) {
                            this.allowed = origin.getMainStore().booleanValue() ? (defaultStoreConfiguration.getCanDeliverFromMainStore() != null ? defaultStoreConfiguration.getCanDeliverFromMainStore() : false) : (defaultStoreConfiguration.getCanDeliverFromFloatStore() != null ? defaultStoreConfiguration.getCanDeliverFromFloatStore() : false);
                        }
                    } else {
                        this.allowed = true;
                    }
                    this.anyUnitAllowed = defaultStoreConfiguration.getCanDeliverRequisitionInAnyUnit() != null ? defaultStoreConfiguration.getCanDeliverRequisitionInAnyUnit() : false;
                    break;
                }
                case REQUISITION_RECEIVE: {
                    if (Boolean.TRUE.equals(settingsComplete.getStoreAccessRightsForMovementRestrictionsActive())) {
                        if (destination != null) {
                            this.allowed = destination.getMainStore().booleanValue() ? (defaultStoreConfiguration.getCanReceiveToMainStore() != null ? defaultStoreConfiguration.getCanReceiveToMainStore() : false) : (defaultStoreConfiguration.getCanReceiveToFloatStore() != null ? defaultStoreConfiguration.getCanReceiveToFloatStore() : false);
                        }
                    } else {
                        this.allowed = true;
                    }
                    this.anyUnitAllowed = defaultStoreConfiguration.getCanReceiveRequisitionInAnyUnit() != null ? defaultStoreConfiguration.getCanReceiveRequisitionInAnyUnit() : false;
                    break;
                }
                case PURCHASE: {
                    this.allowed = true;
                    this.anyUnitAllowed = false;
                    break;
                }
                case PURCHASE_RECEIVE: {
                    this.allowed = Boolean.TRUE.equals(settingsComplete.getStoreAccessRightsForMovementRestrictionsActive()) ? (destination != null ? (destination.getMainStore().booleanValue() ? (defaultStoreConfiguration.getCanReceivePurchaseOrderToMainStore() != null ? defaultStoreConfiguration.getCanReceivePurchaseOrderToMainStore() : false) : (defaultStoreConfiguration.getCanReceivePurchaseOrderToFloatStore() != null ? defaultStoreConfiguration.getCanReceivePurchaseOrderToFloatStore() : false)) : (defaultStoreConfiguration.getCanReceivePurchaseOrderToMainStore() != null ? defaultStoreConfiguration.getCanReceivePurchaseOrderToMainStore() : false)) : true;
                    this.anyUnitAllowed = defaultStoreConfiguration.getCanReceivePurchaseInAnyUnit() != null ? defaultStoreConfiguration.getCanReceivePurchaseInAnyUnit() : false;
                    break;
                }
                case INVENTORY: {
                    if (destination != null) {
                        this.allowed = Boolean.TRUE.equals(settingsComplete.getStoreAccessRightsForMovementRestrictionsActive()) ? (destination.getMainStore().booleanValue() ? (defaultStoreConfiguration.getCanCountInventoryInMainStore() != null ? defaultStoreConfiguration.getCanCountInventoryInMainStore() : false) : (defaultStoreConfiguration.getCanCountInventoryInFloatStore() != null ? defaultStoreConfiguration.getCanCountInventoryInFloatStore() : false)) : true;
                        this.anyUnitAllowed = defaultStoreConfiguration.getCanCountInventoryInAnyUnit() != null ? defaultStoreConfiguration.getCanCountInventoryInAnyUnit() : false;
                        break;
                    }
                    if (origin == null) break;
                    this.allowed = Boolean.TRUE.equals(settingsComplete.getStoreAccessRightsForMovementRestrictionsActive()) ? (origin.getMainStore().booleanValue() ? (defaultStoreConfiguration.getCanCountInventoryInMainStore() != null ? defaultStoreConfiguration.getCanCountInventoryInMainStore() : false) : (defaultStoreConfiguration.getCanCountInventoryInFloatStore() != null ? defaultStoreConfiguration.getCanCountInventoryInFloatStore() : false)) : true;
                    this.anyUnitAllowed = defaultStoreConfiguration.getCanCountInventoryInAnyUnit() != null ? defaultStoreConfiguration.getCanCountInventoryInAnyUnit() : false;
                    break;
                }
                case CHECK_IN: {
                    if (destination == null) break;
                    this.allowed = Boolean.TRUE.equals(settingsComplete.getStoreAccessRightsForMovementRestrictionsActive()) ? (destination.getMainStore().booleanValue() ? (defaultStoreConfiguration.getCanCheckinToMainStore() != null ? defaultStoreConfiguration.getCanCheckinToMainStore() : false) : (defaultStoreConfiguration.getCanCheckinToFloatStore() != null ? defaultStoreConfiguration.getCanCheckinToFloatStore() : false)) : true;
                    this.anyUnitAllowed = defaultStoreConfiguration.getCanCheckinInAnyUnit() != null ? defaultStoreConfiguration.getCanCheckinInAnyUnit() : false;
                    break;
                }
                case CHECK_OUT: {
                    if (origin == null) break;
                    this.allowed = Boolean.TRUE.equals(settingsComplete.getStoreAccessRightsForMovementRestrictionsActive()) ? (origin.getMainStore().booleanValue() ? (defaultStoreConfiguration.getCanCheckoutFromMainStore() != null ? defaultStoreConfiguration.getCanCheckoutFromMainStore() : false) : (defaultStoreConfiguration.getCanCheckoutFromFloatStore() != null ? defaultStoreConfiguration.getCanCheckoutFromFloatStore() : false)) : true;
                    this.anyUnitAllowed = defaultStoreConfiguration.getCanCheckoutInAnyUnit() != null ? defaultStoreConfiguration.getCanCheckinInAnyUnit() : false;
                    break;
                }
                case MOVEMENT: {
                    boolean originAllowed = false;
                    boolean originAnyAllowed = false;
                    boolean destinationAllowed = false;
                    boolean destinationAnyAllowed = false;
                    boolean wasteDestinationAllowed = true;
                    if (origin != null) {
                        originAllowed = Boolean.TRUE.equals(settingsComplete.getStoreAccessRightsForMovementRestrictionsActive()) ? (origin.getMainStore().booleanValue() ? (defaultStoreConfiguration.getCanMoveFromMainStore() != null ? defaultStoreConfiguration.getCanMoveFromMainStore() : false) : (defaultStoreConfiguration.getCanMoveFromFloatStore() != null ? defaultStoreConfiguration.getCanMoveFromFloatStore() : false)) : true;
                        boolean bl = originAnyAllowed = defaultStoreConfiguration.getCanMoveInAnyUnit() != null ? defaultStoreConfiguration.getCanMoveInAnyUnit() : false;
                    }
                    if (destination != null) {
                        destinationAllowed = Boolean.TRUE.equals(settingsComplete.getStoreAccessRightsForMovementRestrictionsActive()) ? (destination.getMainStore().booleanValue() ? (defaultStoreConfiguration.getCanMoveToMainStore() != null ? defaultStoreConfiguration.getCanMoveToMainStore() : false) : (defaultStoreConfiguration.getCanMoveToFloatStore() != null ? defaultStoreConfiguration.getCanMoveToFloatStore() : false)) : true;
                        StoreTypeE storeType = destination.getStoreType();
                        if (StoreTypeE.CONSUMPTION.equals((Object)storeType) || StoreTypeE.WASTE_WITH_CONSUMPTION.equals((Object)storeType) || StoreTypeE.WASTE_WITHOUT_CONSUMPTION.equals((Object)storeType)) {
                            wasteDestinationAllowed = defaultStoreConfiguration.getCanMoveFromMainStoreToWaste() != null ? defaultStoreConfiguration.getCanMoveFromMainStoreToWaste() : false;
                        }
                        boolean bl = destinationAnyAllowed = defaultStoreConfiguration.getCanMoveInAnyUnit() != null ? defaultStoreConfiguration.getCanMoveInAnyUnit() : false;
                    }
                    if (origin != null && destination != null) {
                        this.allowed = originAllowed && destinationAllowed && wasteDestinationAllowed;
                        this.anyUnitAllowed = originAnyAllowed && destinationAnyAllowed;
                        break;
                    }
                    if (origin != null) {
                        this.allowed = originAllowed;
                        this.anyUnitAllowed = originAnyAllowed;
                        break;
                    }
                    if (destination == null) break;
                    this.allowed = destinationAllowed && wasteDestinationAllowed;
                    this.anyUnitAllowed = destinationAnyAllowed;
                    break;
                }
                case MOVE_OUT: {
                    LoggerFactory.getLogger(StoreToolkit.class).warn("Entered illegal switch case in StoreToolkit.invoke()");
                    break;
                }
                case MOVE_IN: {
                    LoggerFactory.getLogger(StoreToolkit.class).warn("Entered illegal switch case in StoreToolkit.invoke()");
                }
            }
            this.setAllowed(this.allowed);
            this.setAnyUnitAllowed(this.anyUnitAllowed);
        }
    }
}

