/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.flightschedule;

import ch.icit.pegasus.server.core.dtos.ADTO;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StowagePositionIdentifier
extends ADTO
implements Serializable,
Comparable<StowagePositionIdentifier> {
    @XmlAttribute
    private String galleyCode;
    @XmlAttribute
    private String positionCode;
    private boolean isHold;

    public StowagePositionIdentifier() {
    }

    public StowagePositionIdentifier(String galleyCode, String positionCode, boolean isHold) {
        this();
        this.galleyCode = galleyCode;
        this.positionCode = positionCode;
        this.isHold = isHold;
    }

    @Override
    public int compareTo(StowagePositionIdentifier o) {
        if (this.galleyCode.equals(o.getGalleyCode())) {
            if (this.positionCode.equals(o.getPositionCode())) {
                return new Boolean(this.isHold).compareTo(o.getIsHold());
            }
            return this.positionCode.compareTo(o.getPositionCode());
        }
        return this.galleyCode.compareTo(o.getGalleyCode());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.galleyCode == null ? 0 : this.galleyCode.hashCode());
        result = 31 * result + (this.isHold ? 1231 : 1237);
        result = 31 * result + (this.positionCode == null ? 0 : this.positionCode.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StowagePositionIdentifier other = (StowagePositionIdentifier)obj;
        if (this.galleyCode == null ? other.galleyCode != null : !this.galleyCode.equals(other.galleyCode)) {
            return false;
        }
        if (this.isHold != other.isHold) {
            return false;
        }
        return !(this.positionCode == null ? other.positionCode != null : !this.positionCode.equals(other.positionCode));
    }

    @Override
    public String toString() {
        return this.galleyCode + " - " + this.positionCode + " - " + (this.isHold ? "HOLD" : "CABINE");
    }

    public String getPositionCode() {
        return this.positionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }

    public String getGalleyCode() {
        return this.galleyCode;
    }

    public void setGalleyCode(String galleyCode) {
        this.galleyCode = galleyCode;
    }

    public boolean getIsHold() {
        return this.isHold;
    }

    public void setIsHold(boolean isHold) {
        this.isHold = isHold;
    }
}

