/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.flightschedule.stowing;

import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.EquipmentDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSpecificationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.FieldOrder;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.stowing.StowingListTemplateVariant")
@FieldOrder(value={"legs", "galleyEquipmentSets"}, otherFields=FieldOrder.Order.AFTER)
public class StowingListTemplateVariantComplete
extends StowingListTemplateVariantLight
implements IStowingListComplete {
    @DTOField(maxStringLength=0x7FFFFFFF)
    @XmlAttribute
    private String comment;
    private Collection<DeliverableComplete> deliverables;
    private Collection<GalleyEquipmentSetComplete> galleyEquipmentSets;
    @IgnoreField
    private List<String> warnings;
    private List<String> mealPlanWarnings = new ArrayList<String>();
    private List<String> stowageWarnings = new ArrayList<String>();

    public StowingListTemplateVariantComplete() {
        this.deliverables = new ArrayList<DeliverableComplete>();
        this.galleyEquipmentSets = new ArrayList<GalleyEquipmentSetComplete>();
        this.warnings = new ArrayList<String>();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<String> getMealPlanWarnings() {
        return this.mealPlanWarnings;
    }

    public void setMealPlanWarnings(List<String> mealPlanWarnings) {
        this.mealPlanWarnings = mealPlanWarnings;
    }

    public List<String> getStowageWarnings() {
        return this.stowageWarnings;
    }

    public void setStowageWarnings(List<String> stowageWarnings) {
        this.stowageWarnings = stowageWarnings;
    }

    @Override
    public Collection<DeliverableComplete> getDeliverables() {
        return this.deliverables;
    }

    @Override
    public void setDeliverables(Collection<DeliverableComplete> deliverables) {
        this.deliverables = deliverables;
    }

    @Override
    public Collection<GalleyEquipmentSetComplete> getGalleyEquipmentSets() {
        return this.galleyEquipmentSets;
    }

    @Override
    public void setGalleyEquipmentSets(Collection<GalleyEquipmentSetComplete> galleyEquipmentSets) {
        this.galleyEquipmentSets = galleyEquipmentSets;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object o) {
        super.afterUnmarshal(u, o);
        this.refreshStowingAfterMarshal(this);
    }

    private void refreshStowingAfterMarshal(StowingListTemplateVariantComplete l) {
        for (GalleyEquipmentSetComplete galleyEquipmentSet : l.getGalleyEquipmentSets()) {
            galleyEquipmentSet.afterMarshal(null, l);
            for (GalleyEquipmentSpecificationComplete spec : galleyEquipmentSet.getGalleyEquipmentSpecifications()) {
                this.refreshSpecification(galleyEquipmentSet, spec);
            }
            this.refreshSpecification(galleyEquipmentSet, galleyEquipmentSet.getLooseEquipment());
            this.refreshDistributions(galleyEquipmentSet.getGalleyDistributionRules());
        }
        for (DeliverableComplete deliverable : l.getDeliverables()) {
            this.refreshDistributions(deliverable.getDeliveryInstruction().getGalleyDistributionRules());
        }
    }

    private void refreshDistributions(List<GalleyDistributionRuleComplete> gdrs) {
        for (GalleyDistributionRuleComplete gdr : gdrs) {
            gdr.afterUnmarshal(null, null);
            this.refreshEqDistribution(gdr, gdr.getEquipmentDistributionRules());
        }
    }

    private void refreshEqDistribution(GalleyDistributionRuleComplete gdr, List<EquipmentDistributionRuleComplete> edrs) {
        for (EquipmentDistributionRuleComplete edr : edrs) {
            edr.afterUnmarshal(null, gdr);
            this.refreshSpaceDistribution(edr, edr.getInsertDistributionRule());
        }
    }

    private void refreshSpaceDistribution(EquipmentDistributionRuleComplete edr, List<DeliverySpaceDistributionRuleComplete> idrs) {
        for (DeliverySpaceDistributionRuleComplete idr : idrs) {
            idr.afterUnmarshal(null, edr);
        }
    }

    private void refreshSpecification(GalleyEquipmentSetComplete galleyEquipmentSet, GalleyEquipmentSpecificationComplete spec) {
        this.refreshEq(galleyEquipmentSet, spec.getUsedGalleyEquipment());
        this.refreshEq(galleyEquipmentSet, spec.getAlternativeEquipment());
    }

    private void refreshEq(GalleyEquipmentSetComplete galleyEquipmentSet, List<GalleyEquipmentComplete> eqs) {
        for (GalleyEquipmentComplete eq : eqs) {
            eq.afterUnmarshal(null, galleyEquipmentSet);
            this.refreshEqDistribution(null, eq.getEquipmentDistributionRules());
            for (DeliverySpaceComplete deliverySpace : eq.getDeliverySpaces()) {
                deliverySpace.afterUnmarshal(null, eq);
                this.refreshSpaceDistribution(null, deliverySpace.getDistributionRules());
            }
        }
    }
}

