/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.product;

import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentInsertTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.BoundDirectionE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerPriceComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductPriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductType;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryLight;
import ch.icit.pegasus.server.core.dtos.util.VariantLight;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.DTOImplementations;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@DTO(target="ch.icit.pegasus.server.core.entities.product.ProductVariant")
@DTOImplementations(value={ProductVariantComplete.class})
public class ProductVariantLight
extends ProductVariantReference
implements VariantLight,
Comparable<ProductVariantLight> {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(ProductVariantLight.class);
    private PeriodComplete validityPeriod;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<HaulTypeComplete> haulTypes;
    private BoundDirectionE boundDirection;
    @XmlAttribute
    private Boolean tenderVariant = false;
    @DTOField(readonly=true)
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private ProductComplete product;
    @XmlAttribute
    @IgnoreField
    private Long productId;
    @IgnoreField
    @XmlAttribute
    private Integer productNumber;
    @IgnoreField
    @XmlAttribute
    private String productCustomer;
    @XmlAttribute
    private Boolean useExpiryDate;
    @XmlAttribute
    private Integer defaultExpiryDate;
    @IgnoreField
    @XmlAttribute
    private Long productCustomerId;
    @IgnoreField
    @XmlAttribute
    private Boolean productDeleted;
    @DTOField(nullable=false, empty=false)
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String customerProductNumber;
    @XmlAttribute
    private String labelName;
    private ColorComplete defaultLabelColor;
    @XmlAttribute
    private String paxName;
    @XmlAttribute
    private Boolean excludeFromCanBeUseFromOtherCustomers;
    @XmlAttribute
    private Boolean useMasterDataForProductGroupTypes;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private GalleyEquipmentInsertTypeComplete defaultInsertType;
    @IgnoreField(nullable=false)
    private PriceComplete salesPrice;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ProductCategoryLight category;
    @IgnoreField(readonly=true)
    private ProductType type;
    private PegasusFileComplete imageReference;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<CateringServiceTypeComplete> serviceTypes = new ArrayList<CateringServiceTypeComplete>();
    private ModificationStateE state;
    @XmlAttribute
    private String productCycle;
    @XmlAttribute
    private Boolean labeled = false;
    @XmlAttribute
    private String additionalComment;
    @IgnoreField
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ProductPriceFactorComplete selectedFactor;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<CabinClassComplete> cabinClasses = new ArrayList<CabinClassComplete>();
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private MealTypeComplete mealType;
    @XmlAttribute
    private Boolean invoiceForCanceledFlights = true;
    @XmlAttribute
    private Boolean excludeFromReporting = false;
    @XmlAttribute
    private Boolean nominated = false;
    @XmlAttribute
    private Boolean showOnDailyOpsSheet = true;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ProductTypeComplete productType;
    @XmlAttribute
    private Integer productToMealMultiplier = 0;
    @XmlAttribute
    private String internalVariantComment;
    @XmlAttribute
    private Boolean standardProduct = true;
    @XmlAttribute
    private Boolean spmlProduct = false;
    @XmlAttribute
    private Boolean alaCarteProduct = false;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<AMenuTypeComplete> menuTypes = new ArrayList<AMenuTypeComplete>();
    @XmlAttribute
    private Boolean hideOnLabel;
    private List<ProductCustomerPriceComplete> customerPrice = new ArrayList<ProductCustomerPriceComplete>();
    @XmlAttribute
    private String defaultDeliveryNumber;
    @XmlAttribute
    private String productEanCode;

    public ProductVariantLight() {
        this.haulTypes = new ArrayList<HaulTypeComplete>();
    }

    public Boolean getUseMasterDataForProductGroupTypes() {
        return this.useMasterDataForProductGroupTypes;
    }

    public void setUseMasterDataForProductGroupTypes(Boolean useMasterDataForProductGroupTypes) {
        this.useMasterDataForProductGroupTypes = useMasterDataForProductGroupTypes;
    }

    public List<HaulTypeComplete> getHaulTypes() {
        return this.haulTypes;
    }

    public void setHaulTypes(List<HaulTypeComplete> haulTypes) {
        this.haulTypes = haulTypes;
    }

    @Override
    public int compareTo(ProductVariantLight o) {
        return this.validityPeriod.getStartDate().compareTo(o.getValidityPeriod().getStartDate());
    }

    public Boolean getInvoiceForCanceledFlights() {
        return this.invoiceForCanceledFlights;
    }

    public void setInvoiceForCanceledFlights(Boolean invoiceForCanceledFlights) {
        this.invoiceForCanceledFlights = invoiceForCanceledFlights;
    }

    public List<CabinClassComplete> getCabinClasses() {
        return this.cabinClasses;
    }

    public void setCabinClasses(List<CabinClassComplete> cabinClasses) {
        this.cabinClasses = cabinClasses;
    }

    public MealTypeComplete getMealType() {
        return this.mealType;
    }

    public BoundDirectionE getBoundDirection() {
        return this.boundDirection;
    }

    public void setBoundDirection(BoundDirectionE boundDirection) {
        this.boundDirection = boundDirection;
    }

    public void setMealType(MealTypeComplete mealType) {
        this.mealType = mealType;
    }

    public String getAdditionalComment() {
        return this.additionalComment;
    }

    public void setAdditionalComment(String additionalComment) {
        this.additionalComment = additionalComment;
    }

    @Override
    public PeriodComplete getValidityPeriod() {
        return this.validityPeriod;
    }

    @Override
    public void setValidityPeriod(PeriodComplete validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public ProductComplete getProduct() {
        return this.product;
    }

    public void setProduct(ProductComplete product) {
        this.product = product;
    }

    public PriceComplete getSalesPrice() {
        return this.salesPrice;
    }

    public void setSalesPrice(PriceComplete salesPrice) {
        this.salesPrice = salesPrice;
    }

    public ProductCategoryLight getCategory() {
        return this.category;
    }

    public void setCategory(ProductCategoryLight category) {
        this.category = category;
    }

    public GalleyEquipmentInsertTypeComplete getDefaultInsertType() {
        return this.defaultInsertType;
    }

    public void setDefaultInsertType(GalleyEquipmentInsertTypeComplete defaultInsertType) {
        this.defaultInsertType = defaultInsertType;
    }

    public ProductType getType() {
        return this.type;
    }

    public void setType(ProductType type) {
        this.type = type;
    }

    public PegasusFileComplete getImageReference() {
        return this.imageReference;
    }

    public void setImageReference(PegasusFileComplete imageReference) {
        this.imageReference = imageReference;
    }

    public List<CateringServiceTypeComplete> getServiceTypes() {
        return this.serviceTypes;
    }

    public void setServiceTypes(List<CateringServiceTypeComplete> serviceTypes) {
        this.serviceTypes = serviceTypes;
    }

    public ModificationStateE getState() {
        return this.state;
    }

    public void setState(ModificationStateE state) {
        this.state = state;
    }

    public String getProductCycle() {
        return this.productCycle;
    }

    public void setProductCycle(String productCycle) {
        this.productCycle = productCycle;
    }

    public Boolean getLabeled() {
        return this.labeled;
    }

    public void setLabeled(Boolean labeled) {
        this.labeled = labeled;
    }

    @Override
    public String toString() {
        return this.validityPeriod + ": " + this.salesPrice;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public ProductPriceFactorComplete getSelectedFactor() {
        return this.selectedFactor;
    }

    public void setSelectedFactor(ProductPriceFactorComplete selectedFactor) {
        this.selectedFactor = selectedFactor;
    }

    public String getCustomerProductNumber() {
        return this.customerProductNumber;
    }

    public void setCustomerProductNumber(String customerProductNumber) {
        this.customerProductNumber = customerProductNumber;
    }

    public Boolean getExcludeFromReporting() {
        return this.excludeFromReporting;
    }

    public void setExcludeFromReporting(Boolean excludeFromReporting) {
        this.excludeFromReporting = excludeFromReporting;
    }

    public String getPaxName() {
        return this.paxName;
    }

    public void setPaxName(String paxName) {
        this.paxName = paxName;
    }

    public ProductTypeComplete getProductType() {
        return this.productType;
    }

    public void setProductType(ProductTypeComplete productType) {
        this.productType = productType;
    }

    public Integer getProductToMealMultiplier() {
        return this.productToMealMultiplier;
    }

    public void setProductToMealMultiplier(Integer productToMealMultiplier) {
        this.productToMealMultiplier = productToMealMultiplier;
    }

    public Boolean getNominated() {
        return this.nominated;
    }

    public void setNominated(Boolean nominated) {
        this.nominated = nominated;
    }

    public Boolean getShowOnDailyOpsSheet() {
        return this.showOnDailyOpsSheet;
    }

    public void setShowOnDailyOpsSheet(Boolean showOnDailyOpsSheet) {
        this.showOnDailyOpsSheet = showOnDailyOpsSheet;
    }

    public Boolean getTenderVariant() {
        return this.tenderVariant;
    }

    public void setTenderVariant(Boolean tenderVariant) {
        this.tenderVariant = tenderVariant;
    }

    public String getInternalVariantComment() {
        return this.internalVariantComment;
    }

    public void setInternalVariantComment(String internalVariantComment) {
        this.internalVariantComment = internalVariantComment;
    }

    public List<AMenuTypeComplete> getMenuTypes() {
        return this.menuTypes;
    }

    public void setMenuTypes(List<AMenuTypeComplete> menuTypes) {
        this.menuTypes = menuTypes;
    }

    public Boolean getStandardProduct() {
        return this.standardProduct;
    }

    public void setStandardProduct(Boolean standardProduct) {
        this.standardProduct = standardProduct;
    }

    public Boolean getSpmlProduct() {
        return this.spmlProduct;
    }

    public void setSpmlProduct(Boolean spmlProduct) {
        this.spmlProduct = spmlProduct;
    }

    public Boolean getAlaCarteProduct() {
        return this.alaCarteProduct;
    }

    public void setAlaCarteProduct(Boolean alaCarteProduct) {
        this.alaCarteProduct = alaCarteProduct;
    }

    public Boolean getHideOnLabel() {
        return this.hideOnLabel;
    }

    public void setHideOnLabel(Boolean hideOnLabel) {
        this.hideOnLabel = hideOnLabel;
    }

    public List<ProductCustomerPriceComplete> getCustomerPrice() {
        return this.customerPrice;
    }

    public void setCustomerPrice(List<ProductCustomerPriceComplete> customerPrice) {
        this.customerPrice = customerPrice;
    }

    public Boolean getExcludeFromCanBeUseFromOtherCustomers() {
        return this.excludeFromCanBeUseFromOtherCustomers;
    }

    public void setExcludeFromCanBeUseFromOtherCustomers(Boolean excludeFromCanBeUseFromOtherCustomers) {
        this.excludeFromCanBeUseFromOtherCustomers = excludeFromCanBeUseFromOtherCustomers;
    }

    public ColorComplete getDefaultLabelColor() {
        return this.defaultLabelColor;
    }

    public void setDefaultLabelColor(ColorComplete defaultLabelColor) {
        this.defaultLabelColor = defaultLabelColor;
    }

    public Long getProductId() {
        return this.productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Integer getProductNumber() {
        return this.productNumber;
    }

    public void setProductNumber(Integer productNumber) {
        this.productNumber = productNumber;
    }

    public String getProductCustomer() {
        return this.productCustomer;
    }

    public void setProductCustomer(String productCustomer) {
        this.productCustomer = productCustomer;
    }

    public Boolean getProductDeleted() {
        return this.productDeleted;
    }

    public void setProductDeleted(Boolean productDeleted) {
        this.productDeleted = productDeleted;
    }

    public void beforeMarshal(Marshaller m) {
        try {
            if (this.getProduct() != null) {
                this.setProductId(this.getProduct().getCacheId());
                this.setProductNumber(this.getProduct().getNumber());
                this.setProductCustomer(this.getProduct().getCustomer().getNumber() + " - " + this.getProduct().getCustomer().getName());
                this.setProductDeleted(this.getProduct().getIsDeleted());
                this.setProductCustomerId(this.getProduct().getCustomer().getCacheId());
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    public void afterUnmarshal(Unmarshaller u, Object product) {
        if (product instanceof ProductComplete) {
            this.setProduct((ProductComplete)product);
        } else if (this.getProductId() != null && XmlCache.getXmlCache().get(this.getProductId()) != null) {
            this.setProduct((ProductComplete)XmlCache.getXmlCache().get(this.getProductId()));
        }
    }

    public Long getProductCustomerId() {
        return this.productCustomerId;
    }

    public void setProductCustomerId(Long productCustomerId) {
        this.productCustomerId = productCustomerId;
    }

    public String getDefaultDeliveryNumber() {
        return this.defaultDeliveryNumber;
    }

    public void setDefaultDeliveryNumber(String defaultDeliveryNumber) {
        this.defaultDeliveryNumber = defaultDeliveryNumber;
    }

    public Integer getDefaultExpiryDate() {
        return this.defaultExpiryDate;
    }

    public void setDefaultExpiryDate(Integer defaultExpiryDate) {
        this.defaultExpiryDate = defaultExpiryDate;
    }

    public Boolean getUseExpiryDate() {
        return this.useExpiryDate;
    }

    public void setUseExpiryDate(Boolean useExpiryDate) {
        this.useExpiryDate = useExpiryDate;
    }

    public String getProductEanCode() {
        return this.productEanCode;
    }

    public void setProductEanCode(String productEanCode) {
        this.productEanCode = productEanCode;
    }
}

