/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.supply;

import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryLight;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.masterdata.ProductCategory")
public class ProductCategoryComplete
extends ProductCategoryLight {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(ProductCategoryComplete.class);
    private List<ProductCategoryComplete> subCategories = new ArrayList<ProductCategoryComplete>();
    @XmlAttribute
    private Boolean customerRestriction;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<CustomerLight> allowedCustomers = new ArrayList<CustomerLight>();

    public List<ProductCategoryComplete> getSubCategories() {
        return this.subCategories;
    }

    public void setSubCategories(List<ProductCategoryComplete> subCategories) {
        this.subCategories = subCategories;
    }

    public List<CustomerLight> getAllowedCustomers() {
        return this.allowedCustomers;
    }

    public void setAllowedCustomers(List<CustomerLight> allowedCustomers) {
        this.allowedCustomers = allowedCustomers;
    }

    public Boolean getCustomerRestriction() {
        return this.customerRestriction;
    }

    public void setCustomerRestriction(Boolean customerRestriction) {
        this.customerRestriction = customerRestriction;
    }

    @Override
    public void beforeMarshal(Marshaller m) {
        try {
            super.beforeMarshal(m);
            this.subCategories.forEach(productCategoryComplete -> productCategoryComplete.beforeMarshal(m));
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        try {
            XmlCache.getXmlCache().put(this.getCacheId(), this);
            super.afterUnmarshal(u, parent);
            for (ProductCategoryComplete subCategory : this.subCategories) {
                subCategory.afterUnmarshal(u, parent);
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }
}

