/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.flightschedule;

import ch.icit.pegasus.server.core.dtos.BasicLogComplete;
import ch.icit.pegasus.server.core.dtos.LoggedComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete;
import ch.icit.pegasus.server.dtos.annotations.Bidirectional;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.FieldOrder;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.flight.FlightSchedule")
@FieldOrder(value={"stowingLists", "legs"})
public class FlightScheduleComplete
extends FlightScheduleLight
implements LoggedComplete {
    @XmlAttribute
    private Integer returnDay;
    @Bidirectional(target="flightSchedule")
    private List<StowingListConfigurationComplete> stowingLists = new ArrayList<StowingListConfigurationComplete>();
    @DTOField(readonly=true)
    private BasicLogComplete log;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<HandlingCostComplete> handlingCosts = new ArrayList<HandlingCostComplete>();
    @XmlAttribute
    private Boolean upliftCount = false;
    @XmlAttribute
    private String defaultGate;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private AirportComplete deliveryAirport;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ReportFileComplete labelLayout;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ReportFileComplete specialMealLayout;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ReportFileComplete deliverySlipSheet;
    @XmlAttribute
    private String crewRemark;
    @Bidirectional(target="flightSchedule")
    private List<AdditionalOrderTemplateComplete> additionalOrders = new ArrayList<AdditionalOrderTemplateComplete>();
    @XmlAttribute
    private Boolean fillUpTrays = true;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private HaulTypeComplete haulType;
    @XmlAttribute
    private Boolean loadFlightToHandheld = false;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ContactComplete deliveryContact;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private FlightScheduleLegComplete staLeg;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private FlightScheduleLegComplete stdLeg;
    @IgnoreField
    @XmlAttribute
    private Long staLegId;
    @IgnoreField
    @XmlAttribute
    private Long stdLegId;
    @XmlAttribute
    private Boolean fillEmptyEquipments = false;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ReportFileComplete sealLabelLayout;
    @XmlAttribute
    private Boolean transitDelivery;
    @XmlAttribute
    private Boolean ignoreCustomerLabelConfig;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private RestaurantComplete restaurant;

    public RestaurantComplete getRestaurant() {
        return this.restaurant;
    }

    public void setRestaurant(RestaurantComplete restaurant) {
        this.restaurant = restaurant;
    }

    public Boolean getIgnoreCustomerLabelConfig() {
        return this.ignoreCustomerLabelConfig;
    }

    public void setIgnoreCustomerLabelConfig(Boolean ignoreCustomerLabelConfig) {
        this.ignoreCustomerLabelConfig = ignoreCustomerLabelConfig;
    }

    public HaulTypeComplete getHaulType() {
        return this.haulType;
    }

    public void setHaulType(HaulTypeComplete haulType) {
        this.haulType = haulType;
    }

    public String getCrewRemark() {
        return this.crewRemark;
    }

    public void setCrewRemark(String crewRemark) {
        this.crewRemark = crewRemark;
    }

    public List<StowingListConfigurationComplete> getStowingLists() {
        return this.stowingLists;
    }

    public void setStowingLists(List<StowingListConfigurationComplete> stowingLists) {
        this.stowingLists = stowingLists;
    }

    public AirportComplete getDeliveryAirport() {
        return this.deliveryAirport;
    }

    public void setDeliveryAirport(AirportComplete deliveryAirport) {
        this.deliveryAirport = deliveryAirport;
    }

    public String getDefaultGate() {
        return this.defaultGate;
    }

    public void setDefaultGate(String defaultGate) {
        this.defaultGate = defaultGate;
    }

    public Integer getReturnDay() {
        return this.returnDay;
    }

    public void setReturnDay(Integer returnDay) {
        this.returnDay = returnDay;
    }

    public List<HandlingCostComplete> getHandlingCosts() {
        return this.handlingCosts;
    }

    public void setHandlingCosts(List<HandlingCostComplete> handlingCosts) {
        this.handlingCosts = handlingCosts;
    }

    public Boolean getUpliftCount() {
        return this.upliftCount;
    }

    public void setUpliftCount(Boolean upliftCount) {
        this.upliftCount = upliftCount;
    }

    public ReportFileComplete getLabelLayout() {
        return this.labelLayout;
    }

    public void setLabelLayout(ReportFileComplete labelLayout) {
        this.labelLayout = labelLayout;
    }

    public ReportFileComplete getDeliverySlipSheet() {
        return this.deliverySlipSheet;
    }

    public void setDeliverySlipSheet(ReportFileComplete deliverySlipSheet) {
        this.deliverySlipSheet = deliverySlipSheet;
    }

    public List<AdditionalOrderTemplateComplete> getAdditionalOrders() {
        return this.additionalOrders;
    }

    public void setAdditionalOrders(List<AdditionalOrderTemplateComplete> additionalOrders) {
        this.additionalOrders = additionalOrders;
    }

    public Boolean getFillUpTrays() {
        return this.fillUpTrays;
    }

    public void setFillUpTrays(Boolean fillUpTrays) {
        this.fillUpTrays = fillUpTrays;
    }

    public Boolean getLoadFlightToHandheld() {
        return this.loadFlightToHandheld;
    }

    public void setLoadFlightToHandheld(Boolean loadFlightToHandheld) {
        this.loadFlightToHandheld = loadFlightToHandheld;
    }

    public FlightScheduleLegComplete getStdLeg() {
        return this.stdLeg;
    }

    public void setStdLeg(FlightScheduleLegComplete stdLeg) {
        this.stdLeg = stdLeg;
    }

    public FlightScheduleLegComplete getStaLeg() {
        return this.staLeg;
    }

    public void setStaLeg(FlightScheduleLegComplete staLeg) {
        this.staLeg = staLeg;
    }

    public ReportFileComplete getSpecialMealLayout() {
        return this.specialMealLayout;
    }

    public void setSpecialMealLayout(ReportFileComplete specialMealLayout) {
        this.specialMealLayout = specialMealLayout;
    }

    public Boolean getFillEmptyEquipments() {
        return this.fillEmptyEquipments;
    }

    public void setFillEmptyEquipments(Boolean fillEmptyEquipments) {
        this.fillEmptyEquipments = fillEmptyEquipments;
    }

    public ReportFileComplete getSealLabelLayout() {
        return this.sealLabelLayout;
    }

    public void setSealLabelLayout(ReportFileComplete sealLabelLayout) {
        this.sealLabelLayout = sealLabelLayout;
    }

    public Boolean getTransitDelivery() {
        return this.transitDelivery;
    }

    public void setTransitDelivery(Boolean transitDelivery) {
        this.transitDelivery = transitDelivery;
    }

    public Long getStaLegId() {
        return this.staLegId;
    }

    public void setStaLegId(Long staLegId) {
        this.staLegId = staLegId;
    }

    public Long getStdLegId() {
        return this.stdLegId;
    }

    public void setStdLegId(Long stdLegId) {
        this.stdLegId = stdLegId;
    }

    public void beforeMarshal(Marshaller m) {
        if (this.staLeg != null) {
            Long l = this.staLegId = this.staLeg.getId() != null ? this.staLeg.getId() : this.staLeg.getClientOId();
        }
        if (this.stdLeg != null) {
            this.stdLegId = this.stdLeg.getId() != null ? this.stdLeg.getId() : this.stdLeg.getClientOId();
        }
    }

    @Override
    public void afterUnmarshal(Unmarshaller m, Object o) {
        HashMap<Long, FlightScheduleLegComplete> legMap = new HashMap<Long, FlightScheduleLegComplete>();
        for (FlightScheduleLegComplete leg : this.getLegs()) {
            legMap.put(leg.getId() != null ? leg.getId() : leg.getClientOId(), leg);
        }
        if (this.staLegId != null) {
            this.staLeg = (FlightScheduleLegComplete)legMap.get(this.staLegId);
        }
        if (this.stdLegId != null) {
            this.stdLeg = (FlightScheduleLegComplete)legMap.get(this.stdLegId);
        }
    }

    public ContactComplete getDeliveryContact() {
        return this.deliveryContact;
    }

    public void setDeliveryContact(ContactComplete deliveryContact) {
        this.deliveryContact = deliveryContact;
    }

    @Override
    public void setLog(BasicLogComplete log) {
        this.log = log;
    }

    @Override
    public BasicLogComplete getLog() {
        return this.log;
    }
}

