/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.masterdata;

import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.IStoreQuantity;
import ch.icit.pegasus.server.core.calculator.IUnit;
import ch.icit.pegasus.server.core.dtos.AEmbeddedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.supply.Quantity")
public class QuantityComplete
extends AEmbeddedDTO
implements IQuantity {
    @DTOField(target="amount")
    @XmlAttribute
    private Double quantity;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private UnitComplete unit;

    public QuantityComplete() {
    }

    public QuantityComplete(QuantityComplete q) {
        this();
        if (q != null) {
            this.quantity = q.getQuantity();
            this.unit = q.getUnit();
        }
    }

    public QuantityComplete(StoreQuantityComplete q) {
        this();
        if (q != null) {
            this.quantity = q.getAmount().doubleValue();
            this.unit = q.getUnit();
        }
    }

    public QuantityComplete(Double amount, UnitComplete unit) {
        this();
        this.quantity = amount;
        this.unit = unit;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public Double getAmount() {
        return this.getQuantity();
    }

    public UnitComplete getUnit() {
        return this.unit;
    }

    public IQuantity newQuantity(Double quantity, IUnit unit) {
        return new QuantityComplete(quantity, (UnitComplete)unit);
    }

    public IStoreQuantity newStoreQuantity(long quantity, IUnit unit) {
        return new StoreQuantityComplete(quantity, (UnitComplete)unit);
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public void setUnit(UnitComplete unit) {
        this.unit = unit;
    }

    @Override
    public String toString() {
        return this.quantity + " " + this.unit;
    }
}

