/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.masterdata;

import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.IStoreQuantity;
import ch.icit.pegasus.server.core.calculator.IUnit;
import ch.icit.pegasus.server.core.dtos.AEmbeddedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.supply.StoreQuantity")
public class StoreQuantityComplete
extends AEmbeddedDTO
implements IStoreQuantity {
    @DTOField(minValue=0.0)
    @XmlAttribute
    private Long amount;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private UnitComplete unit;

    public StoreQuantityComplete() {
    }

    public StoreQuantityComplete(StoreQuantityComplete q) {
        this();
        if (q != null) {
            this.amount = q.getAmount();
            this.unit = q.getUnit();
        }
    }

    public StoreQuantityComplete(Long amount, UnitComplete unit) {
        this();
        this.amount = amount;
        this.unit = unit;
    }

    public UnitComplete getUnit() {
        return this.unit;
    }

    public void setUnit(UnitComplete unit) {
        this.unit = unit;
    }

    public Long getAmount() {
        return this.amount;
    }

    public IStoreQuantity newStoreQuantity(long quantity, IUnit unit) {
        return new StoreQuantityComplete(quantity, (UnitComplete)unit);
    }

    public IQuantity newQuantity(double quantity, IUnit unit) {
        return new QuantityComplete(quantity, (UnitComplete)unit);
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Override
    public String toString() {
        return this.amount + " " + this.unit;
    }
}

