/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.masterdata;

import ch.icit.pegasus.server.core.dtos.AEmbeddedDTO;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.SqlTimeAdapter;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import java.sql.Time;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.LocalTime;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.masterdata.TimePeriod")
public class TimePeriodComplete
extends AEmbeddedDTO {
    @XmlJavaTypeAdapter(value=SqlTimeAdapter.class)
    private Time startTime;
    @XmlJavaTypeAdapter(value=SqlTimeAdapter.class)
    private Time endTime;

    public TimePeriodComplete() {
    }

    public TimePeriodComplete(Time startTime, Time endTime) {
        this.setStartTime(startTime);
        this.setEndTime(endTime);
    }

    public Time getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Time startTime) {
        this.startTime = startTime;
        this.fixStartTime();
    }

    public Time getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Time endTime) {
        this.endTime = endTime;
        this.fixEndTime();
    }

    private void fixStartTime() {
        if (this.startTime == null) {
            return;
        }
        LocalTime startLT = new LocalTime((Object)this.startTime).withSecondOfMinute(0).withMillisOfSecond(0);
        this.startTime = new Time(startLT.toDateTimeToday().getMillis());
    }

    private void fixEndTime() {
        if (this.endTime == null) {
            return;
        }
        LocalTime endLT = new LocalTime((Object)this.endTime).withSecondOfMinute(0).withMillisOfSecond(0);
        endLT = endLT.plusMinutes(1);
        this.endTime = new Time(endLT.toDateTimeToday().getMillis() - 1L);
    }
}

