/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.search;

import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AircraftTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.BoundDirectionE;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchTypeE;
import ch.icit.pegasus.server.core.dtos.search.ProductVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryReference;
import ch.icit.pegasus.server.core.dtos.util.NominatedStateE;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlSeeAlso(value={ProductSearchConfiguration.class, ProductVariantSearchConfiguration.class})
@ADtoSearchConfiguration.SubClassIndex
public abstract class AProductSearchConfiguration<T extends IDTO>
extends ADtoSearchConfiguration<T, PRODUCT_COLUMN> {
    @XmlAttribute
    private Integer number;
    @XmlAttribute
    private String name;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private AircraftTypeComplete aircraftType;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ProductCategoryReference mainCategory;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ProductCategoryReference subCategory;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CustomerLight customer;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private BasicArticleReference article;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ProductReference product;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private RecipeReference recipe;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private SalesPriceFactorComplete priceFactor;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private HandlingCostComplete handling;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CabinClassComplete cabinClass;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CateringServiceTypeComplete serviceType;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private SpecialMenuTypeComplete spmlType;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private HaulTypeComplete haultType;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlAttribute
    private String additionalComment;
    private BoundDirectionE inout;
    private ProductTypeComplete productType;
    private NominatedStateE nominated;
    private List<CustomerLight> showOtherCustomerProducts;
    private ProductCatalogTypeE catalogType;
    private MealTypeComplete mealType;
    private ProductSearchTypeE productSearchType = ProductSearchTypeE.ALL;
    @XmlAttribute
    private Boolean sobProduct;
    @XmlAttribute
    private Boolean additional;
    private PeriodComplete period;
    private PeriodComplete variantPeriod;
    private ModificationStateE state;
    @XmlAttribute
    private Boolean simpleProduct;
    @XmlAttribute
    private Boolean counted;

    public ProductSearchTypeE getProductSearchtype() {
        return this.productSearchType;
    }

    public AProductSearchConfiguration() {
        this.setShowOtherCustomerProducts(new ArrayList<CustomerLight>());
    }

    public AProductSearchConfiguration(Integer number) {
        this.number = number;
    }

    public ProductCatalogTypeE getCatalogType() {
        return this.catalogType;
    }

    public void setCatalogType(ProductCatalogTypeE catalogType) {
        this.catalogType = catalogType;
    }

    public RecipeReference getRecipe() {
        return this.recipe;
    }

    public void setRecipe(RecipeReference recipe) {
        this.recipe = recipe;
    }

    public CabinClassComplete getCabinClass() {
        return this.cabinClass;
    }

    public void setCabinClass(CabinClassComplete cabinClass) {
        this.cabinClass = cabinClass;
    }

    public CateringServiceTypeComplete getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(CateringServiceTypeComplete serviceType) {
        this.serviceType = serviceType;
    }

    public SpecialMenuTypeComplete getSpmlType() {
        return this.spmlType;
    }

    public void setSpmlType(SpecialMenuTypeComplete spmlType) {
        this.spmlType = spmlType;
    }

    public HaulTypeComplete getHaultType() {
        return this.haultType;
    }

    public void setHaultType(HaulTypeComplete haultType) {
        this.haultType = haultType;
    }

    public BoundDirectionE getInout() {
        return this.inout;
    }

    public void setInout(BoundDirectionE inout) {
        this.inout = inout;
    }

    public AircraftTypeComplete GalleyEquipmentType() {
        return this.aircraftType;
    }

    public AircraftTypeComplete getAircraftType() {
        return this.aircraftType;
    }

    public void setAircraftType(AircraftTypeComplete aircraftType) {
        this.aircraftType = aircraftType;
    }

    public ProductCategoryReference getMainCategory() {
        return this.mainCategory;
    }

    public void setMainCategory(ProductCategoryReference mainCategory) {
        this.mainCategory = mainCategory;
    }

    public ProductCategoryReference getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(ProductCategoryReference subCategory) {
        this.subCategory = subCategory;
    }

    public CustomerLight getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerLight customer) {
        this.customer = customer;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = this.limitString(name);
    }

    public BasicArticleReference getArticle() {
        return this.article;
    }

    public void setArticle(BasicArticleReference article) {
        this.article = article;
    }

    public PeriodComplete getPeriod() {
        return this.period;
    }

    public void setPeriod(PeriodComplete period) {
        this.period = period;
    }

    public Boolean getAdditional() {
        return this.additional;
    }

    public void setAdditional(Boolean additional) {
        this.additional = additional;
    }

    public ModificationStateE getState() {
        return this.state;
    }

    public void setState(ModificationStateE state) {
        this.state = state;
    }

    public ProductReference getProduct() {
        return this.product;
    }

    public void setProduct(ProductReference product) {
        this.product = product;
    }

    public PeriodComplete getVariantPeriod() {
        return this.variantPeriod;
    }

    public void setVariantPeriod(PeriodComplete variantPeriod) {
        this.variantPeriod = variantPeriod;
    }

    public SalesPriceFactorComplete getPriceFactor() {
        return this.priceFactor;
    }

    public void setPriceFactor(SalesPriceFactorComplete priceFactor) {
        this.priceFactor = priceFactor;
    }

    public PRODUCT_COLUMN getDefaultSortColumn() {
        return PRODUCT_COLUMN.NUMBER;
    }

    public HandlingCostComplete getHandling() {
        return this.handling;
    }

    public void setHandling(HandlingCostComplete handling) {
        this.handling = handling;
    }

    public Boolean getSimpleProduct() {
        return this.simpleProduct;
    }

    public void setSimpleProduct(Boolean simpleProduct) {
        this.simpleProduct = simpleProduct;
    }

    public MealTypeComplete getMealType() {
        return this.mealType;
    }

    public void setMealType(MealTypeComplete mealType) {
        this.mealType = mealType;
    }

    public Boolean getCounted() {
        return this.counted;
    }

    public void setCounted(Boolean counted) {
        this.counted = counted;
    }

    public String getAdditionalComment() {
        return this.additionalComment;
    }

    public void setAdditionalComment(String additionalComment) {
        this.additionalComment = this.limitString(additionalComment);
    }

    public List<CustomerLight> getShowOtherCustomerProducts() {
        return this.showOtherCustomerProducts;
    }

    public void setShowOtherCustomerProducts(List<CustomerLight> showOtherCustomerProducts) {
        this.showOtherCustomerProducts = showOtherCustomerProducts;
    }

    public ProductTypeComplete getProductType() {
        return this.productType;
    }

    public void setProductType(ProductTypeComplete productType) {
        this.productType = productType;
    }

    public NominatedStateE getNominated() {
        return this.nominated;
    }

    public void setNominated(NominatedStateE nominated) {
        this.nominated = nominated;
    }

    public Boolean getSobProduct() {
        return this.sobProduct;
    }

    public void setSobProduct(Boolean sobProduct) {
        this.sobProduct = sobProduct;
    }

    public ProductSearchTypeE getProductSearchType() {
        return this.productSearchType;
    }

    public void setProductSearchType(ProductSearchTypeE productSearchType) {
        this.productSearchType = productSearchType;
    }

    public List<Tuple<String, String>> getSearchConfig() {
        ArrayList<Tuple<String, String>> rets = new ArrayList<Tuple<String, String>>();
        rets.add(new Tuple((Object)"Search Type", (Object)(this.productSearchType != null ? this.productSearchType.toString() : "")));
        rets.add(new Tuple((Object)"Number", (Object)(this.number != null ? this.number.toString() : "")));
        rets.add(new Tuple((Object)"Name", (Object)(this.name != null ? this.name.toString() : "")));
        rets.add(new Tuple((Object)"Aircraft Type", (Object)(this.aircraftType != null ? this.aircraftType.getCode() : "")));
        rets.add(new Tuple((Object)"Customer", (Object)(this.customer != null ? this.customer.getCode() : "")));
        rets.add(new Tuple((Object)"Sales Price Factor", (Object)(this.priceFactor != null ? this.priceFactor.getCode() : "")));
        rets.add(new Tuple((Object)"Handling Cost", (Object)(this.handling != null ? "" + this.handling.getNumber() : "")));
        rets.add(new Tuple((Object)"Cabin Class", (Object)(this.cabinClass != null ? this.cabinClass.getCode() : "")));
        rets.add(new Tuple((Object)"Service Type", (Object)(this.serviceType != null ? this.serviceType.getCode() : "")));
        rets.add(new Tuple((Object)"SPML Type", (Object)(this.spmlType != null ? this.spmlType.getCode() : "")));
        rets.add(new Tuple((Object)"Haul Type", (Object)(this.haultType != null ? this.haultType.getCode() : "")));
        rets.add(new Tuple((Object)"Additional Comment", (Object)(this.additionalComment != null ? this.additionalComment.toString() : "")));
        rets.add(new Tuple((Object)"InOut", (Object)(this.inout != null ? this.inout.toString() : "")));
        rets.add(new Tuple((Object)"Product Type", (Object)(this.productType != null ? this.productType.getCode() : "")));
        rets.add(new Tuple((Object)"Nominated", (Object)(this.nominated != null ? this.nominated.toString() : "")));
        rets.add(new Tuple((Object)"Regular/SPML/AlaCarte", (Object)(this.catalogType != null ? this.catalogType.toString() : "")));
        rets.add(new Tuple((Object)"Meal Type", (Object)(this.mealType != null ? this.mealType.getCode() : "")));
        rets.add(new Tuple((Object)"Sob Product", (Object)(this.sobProduct != null ? this.sobProduct.toString() : "")));
        rets.add(new Tuple((Object)"Additional", (Object)(this.additional != null ? this.additional.toString() : "")));
        rets.add(new Tuple((Object)"Period", (Object)(this.period != null && this.period.getStartDate() != null && this.period.getEndDate() != null ? this.period.toString() : "")));
        rets.add(new Tuple((Object)"Variant Period", (Object)(this.variantPeriod != null ? this.variantPeriod.toString() : "")));
        rets.add(new Tuple((Object)"State", (Object)(this.state != null ? this.state.toString() : "")));
        rets.add(new Tuple((Object)"Article/Recipe Product", (Object)(this.simpleProduct != null ? (Boolean.TRUE.equals(this.simpleProduct) ? "Article" : "Recipe") : "")));
        rets.add(new Tuple((Object)"Counted", (Object)(this.counted != null ? this.counted.toString() : "")));
        return rets;
    }

    public static enum PRODUCT_COLUMN {
        NUMBER,
        NAME,
        CUSTOMER,
        CUSTOMERNO,
        CATEGORY,
        START_DATE,
        END_DATE,
        PRICE,
        STATE,
        CYCLE,
        HINT;

    }
}

