/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.supply;

import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DTO(target="ch.icit.pegasus.server.core.entities.basicarticle.BasicArticlePrice")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class BasicArticlePriceComplete
extends ADTO
implements Comparable<BasicArticlePriceComplete> {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(BasicArticlePriceComplete.class);
    private PriceComplete price;
    private PeriodComplete validity;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private BasicArticleReference article;
    @XmlTransient
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ArticlePriceCalculationLight calculation;
    @IgnoreField
    @XmlAttribute
    private String calculationName;
    @XmlAttribute
    private String comment;

    @Override
    public int compareTo(BasicArticlePriceComplete o) {
        return this.validity.getStartDate().compareTo(o.getValidity().getStartDate());
    }

    public PriceComplete getPrice() {
        return this.price;
    }

    public void setPrice(PriceComplete price) {
        this.price = price;
    }

    public PeriodComplete getValidity() {
        return this.validity;
    }

    public void setValidity(PeriodComplete validity) {
        this.validity = validity;
    }

    public BasicArticleReference getArticle() {
        return this.article;
    }

    public void setArticle(BasicArticleReference article) {
        this.article = article;
    }

    public ArticlePriceCalculationLight getCalculation() {
        return this.calculation;
    }

    public void setCalculation(ArticlePriceCalculationLight calculation) {
        this.calculation = calculation;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void beforeMarshal(Marshaller m) {
        try {
            if (this.getCalculation() != null) {
                this.setCalculationName(this.getCalculation().getNumber() + " - " + this.getCalculation().getName());
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (parent instanceof BasicArticleReference) {
            this.article = (BasicArticleReference)parent;
        }
        if (parent instanceof BasicArticleLight) {
            this.article = (BasicArticleLight)parent;
        }
        if (parent instanceof BasicArticleComplete) {
            this.article = (BasicArticleComplete)parent;
        }
    }

    public String getCalculationName() {
        return this.calculationName;
    }

    public void setCalculationName(String calculationName) {
        this.calculationName = calculationName;
    }
}

