/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.error;

import ch.icit.pegasus.server.core.error.ClientMessage;
import ch.icit.pegasus.server.core.error.ClientMessages;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class ClientMessageResolver {
    private final Properties languageProperties;
    private static final Logger log = LoggerFactory.getLogger(ClientMessageResolver.class);

    public ClientMessageResolver(Properties languageProperties) {
        this.languageProperties = languageProperties;
    }

    public String getMessageString(ClientMessage message) {
        String str = this.languageProperties.getProperty(message.getDefinition().getMsgCode());
        return MessageFormatter.arrayFormat((String)str, (Object[])message.getParams()).getMessage();
    }

    public static List<String> validate(Properties languageProperties) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<String> invalidCodes = new ArrayList<String>();
        for (Field f : ClientMessages.class.getFields()) {
            int actualNumParams;
            Class<?> type = f.getType();
            if (!ClientMessages.ClientMessageDefinition.class.isAssignableFrom(type) || !Modifier.isStatic(f.getModifiers())) continue;
            int numParams = new Integer(type.getSimpleName().substring(ClientMessages.ClientMessageDefinition.class.getSimpleName().length()));
            ClientMessages.ClientMessageDefinition def = (ClientMessages.ClientMessageDefinition)f.get(null);
            String code = def.getMsgCode();
            String msg = languageProperties.getProperty(code);
            if (msg == null) {
                invalidCodes.add(code + " (not defined)");
            }
            if (numParams == (actualNumParams = msg.split("{}").length - 1)) continue;
            invalidCodes.add(code + " (invalid number of parameters)");
        }
        for (String c : invalidCodes) {
            log.trace("Invalid property found: " + c);
        }
        if (invalidCodes.isEmpty()) {
            log.debug("Successfully validated language Properties!");
        }
        return invalidCodes;
    }
}

