/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.i18n.message;

import ch.icit.pegasus.server.core.i18n.message.MessageProperties;
import ch.icit.pegasus.server.core.i18n.message.UserMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class UserMessages {
    public static final UserMessage NO_STEP_FUNCTION_IN_MEALPLAN = new UserMessage(1, "no_step_function_in_mealplan");
    public static final UserMessage NO_STEP_FUNCTION_IN_STOWING_LIST = new UserMessage(1, "no_step_function_in_stowing_list");
    public static final UserMessage NO_STEP_FOUND_FOR_VALUE_IN_MEALPLAN = new UserMessage(2, "no_step_found_for_value_in_mealplan");
    public static final UserMessage NO_STEP_FOUND_FOR_VALUE_IN_STOWING_LIST = new UserMessage(2, "no_step_found_for_value_in_stowing_list");
    public static final UserMessage FAILED_TO_CALCULATE_DELIVERABLE = new UserMessage(4, "failed_to_calculate_deliverable");
    public static final UserMessage CALCULATE_DELIVERY_AMOUNT = new UserMessage(0, "calculate_delivery_amount");
    public static final UserMessage CALCULATE_SPML_CHOICE_DISTRIBUTION = new UserMessage(0, "calculate_spml_choice_distribution");
    public static final UserMessage NOT_ENOUGH_SPML_EQUIPMENTS = new UserMessage(2, "not_enough_spml_equipments");
    public static final UserMessage NOT_ENOUGH_ALACARTE_EQUIPMENTS = new UserMessage(2, "not_enough_alacarte_equipments");
    public static final UserMessage STOWING_LIST_CAPACITY_EXCEEDED = new UserMessage(3, "stowing_list_capacity_exceeded");
    public static final UserMessage NO_FUNCTION_DEFINED_FOR_PAX_DI = new UserMessage(1, "no_function_defined_for_pax_di");
    public static final UserMessage NO_VALID_PRODUCT_VARIANT = new UserMessage(1, "no_valid_product_variant");
    public static final UserMessage NO_VALID_CURRENCY_VARIANT = new UserMessage(1, "no_valid_currency_variant");
    public static final UserMessage NO_VALID_EQUIPMENT_VARIANT = new UserMessage(1, "no_valid_equipment_variant");
    public static final UserMessage FAILED_TO_CALCULATE_PRODUCT = new UserMessage(2, "failed_to_calculate_product");
    public static final UserMessage MULTIPLE_ITEMS_IN_RESERVED_SPACE = new UserMessage(2, "multiple_items_in_reserved_space");
    public static final UserMessage NO_EQUIPMENT_FOUND_FOR_ADDITIONAL_ORDER = new UserMessage(3, "no_equipment_found_for_additional_order");
    public static final UserMessage NO_EQUIPMENT_FOUND_FOR_ADDITIONAL_SPML_ORDER = new UserMessage(3, "no_equipment_found_for_additional_spml_order");
    public static final UserMessage MULTIPLE_FILL_CHOICES = new UserMessage(3, "multiple_fill_choices");
    public static final UserMessage CHOICE_ROUNDING_WITHOUT_FILLUP = new UserMessage(3, "choice_rounding_without_fillup");
    public static final UserMessage UNUSED_MEALTYPE_CONFIGURATION = new UserMessage(2, "unused_mealtype_configuration");
    public static final UserMessage ALACARTE_MEAL_NOT_DEFINED_IN_CATALOG = new UserMessage(7, "alacarte_meal_not_defined_in_catalog");
    public static final UserMessage SPECIAL_MEAL_NOT_DEFINED_IN_CATALOG = new UserMessage(7, "special_meal_not_defined_in_catalog");
    public static final UserMessage ADDITIONAL_SPECIAL_MEAL_NOT_DEFINED_IN_CATALOG = new UserMessage(3, "additional_special_meal_not_defined_in_catalog");
    public static final UserMessage NO_VALID_ROTATION = new UserMessage(2, "no_valid_rotation");
    public static final UserMessage NO_VALID_ROTATION_USE_FIRST_CYCLE = new UserMessage(2, "no_valid_rotation_use_first_cycle");
    public static final UserMessage NO_VALID_ROTATION_STD_BIGGER_THAN_START = new UserMessage(3, "no_valid_rotation_std_bigger_than_start");
    public static final UserMessage NO_VALID_ROTATION_STD_BIGGER_THAN_START_USE_FIRST_CYCLE = new UserMessage(3, "no_valid_rotation_std_bigger_than_start_use_first_cycle");
    public static final UserMessage NO_ALCACARTE_CATALOG_DEFINED = new UserMessage(0, "no_alacarte_catalog_defined");
    public static final UserMessage TOO_MANY_SPML_AND_ALACARTE_ORDERS = new UserMessage(0, "too_many_spml_and_alacarte_orders");
    public static final UserMessage FILL_ROUNDING_STRATEGY_WITHOUT_AMOUNT_NORMALIZATION = new UserMessage(3, "fill_rounding_strategy_without_amount_normalization");
    public static final UserMessage NO_FIX_PRICE_FOUND = new UserMessage(4, "no_fix_price_found");
    public static final UserMessage NO_VALID_HANDLINGCOST = new UserMessage(2, "no_valid_handlingcost");
    public static final UserMessage NEGATIVE_AMOUNT_TOO_HIGH_FOR_LOADING_GROUP = new UserMessage(4, "negative_amount_too_high_for_loading_group");
    public static final UserMessage NEGATIVE_AMOUNT_TOO_HIGH_FOR_PRODUCT = new UserMessage(5, "negative_amount_too_high_for_product");
    public static final UserMessage NEGATIVE_STEP_IN_STOWING_LIST = new UserMessage(1, "negative_step_in_stowing_list");
    public static final UserMessage NEGATIVE_RESULT_FOR_LINEAR_FUNCTION = new UserMessage(1, "negative_result_for_linear_function");
    public static final UserMessage NEGATIVE_FIX_AMOUNT_IN_STOWING_LIST = new UserMessage(1, "negative_fix_amount_in_stowing_list");
    public static final UserMessage NEGATIVE_AMOUNT_FOR_PRODUCT_WITHOUT_RATIO_CHOICE = new UserMessage(3, "negative_amount_for_product_without_ratio_choice");
    public static final UserMessage MULTIPLE_RATIO_CHOICES_FOR_SAME_PRODUCT = new UserMessage(3, "multiple_ratio_choices_for_same_product");
    public static final UserMessage RETURNS_COUNT_SPACE_NO_SINGLE_DEPARTMENT = new UserMessage(2, "returns_count_space_no_single_department");
    public static final UserMessage RETURNS_COUNT_EQUIPMENT_NO_SINGLE_DEPARTMENT = new UserMessage(2, "returns_count_equipment_no_single_department");
    public static final UserMessage NO_MEAL_FOUND_ON_FLIGHT = new UserMessage(2, "no_meal_found_on_flight");
    public static final UserMessage UNABLE_TO_DELETE_FLIGHT = new UserMessage(3, "unable_to_delete_flight");
    public static final UserMessage NO_STOWING_LIST_FOUND = new UserMessage(2, "no_stowing_list_found");
    public static final UserMessage NO_AIRCRAFT_FOUND = new UserMessage(2, "no_aircraft_found");
    public static final UserMessage UNABLE_TO_OPEN_FLIGHT = new UserMessage(3, "unable_to_open_flight");
    private static final MessageProperties messages = new MessageProperties();
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final char DELIM_VAR = '$';

    private UserMessages() {
    }

    public static void load(InputStream in) throws IOException {
        messages.load(in);
    }

    public static void write(OutputStream out) throws IOException {
        messages.store(out);
    }

    public static String buildMessage(UserMessage message, Object ... args) {
        int numArgs = args.length;
        assert (message.getNumArgs() == numArgs);
        String template = messages.get(message).toString();
        if (template == null) {
            return null;
        }
        if (numArgs == 0) {
            return template;
        }
        StringBuilder str = new StringBuilder();
        int last = 0;
        int cur = -1;
        int size = template.length();
        while (cur < size) {
            int argNum;
            cur = template.indexOf(123, last);
            if (cur == -1 || size < cur + 4) {
                str.append(template.substring(last));
                break;
            }
            str.append(template.substring(last, cur));
            char[] var = template.substring(cur, cur + 4).toCharArray();
            last = cur + 4;
            assert (var.length == 4);
            assert (var[0] == '{');
            if (var[1] != '$' || var[3] != '}' || !Character.isDigit(var[2]) || (argNum = Character.getNumericValue(var[2]) - 1) > numArgs) continue;
            str.append(args[argNum]);
        }
        return str.toString();
    }

    static {
        messages.put(NO_STEP_FUNCTION_IN_MEALPLAN, "No step function is defined in the Meal Plan for the Deliverable '{$1}'");
        messages.put(NO_STEP_FUNCTION_IN_STOWING_LIST, "No step function is defined in the Stowing List for the Deliverable '{$1}'");
        messages.put(NO_STEP_FOUND_FOR_VALUE_IN_MEALPLAN, "No step found in the Meal Plan for the value '{$1}' for the Deliverable '{$2}' - Using the last step...");
        messages.put(NO_STEP_FOUND_FOR_VALUE_IN_STOWING_LIST, "No step found in the Stowing List for the value '{$1}' for the Deliverable '{$2}' - Using the last step...");
        messages.put(FAILED_TO_CALCULATE_DELIVERABLE, "Failed to {$1} for Deliverable '{$2}' of Flight '{$3}'{$4}");
        messages.put(CALCULATE_DELIVERY_AMOUNT, "calculate delivery amount");
        messages.put(CALCULATE_SPML_CHOICE_DISTRIBUTION, "calculate spml / choice distribution");
        messages.put(NOT_ENOUGH_SPML_EQUIPMENTS, "There are not enough equipments configured for SPML. {$1} Special Meals for the Deliverable '{$2}' could not be stowed!");
        messages.put(NOT_ENOUGH_ALACARTE_EQUIPMENTS, "There are not enough equipments configured for A la Carte Menus. {$1} A la Carte Meals for the Deliverable '{$2}' could not be stowed!");
        messages.put(STOWING_LIST_CAPACITY_EXCEEDED, "The calculated Quantity ({$1}) exceeds the Stowing List Capacity ({$2}) for the Deliverable '{$3}'!");
        messages.put(NO_FUNCTION_DEFINED_FOR_PAX_DI, "No Function defined for the Pax Related Deliverable '{$1}'!");
        messages.put(NO_VALID_PRODUCT_VARIANT, "No valid Productvariant found for '{$1}'!");
        messages.put(MULTIPLE_ITEMS_IN_RESERVED_SPACE, "Failed to generate Tray Labels for the Reserved Space '{$1}' in the Equipment '{$2}'. Multiple Items are not supported for Reserved Space Trays!");
        messages.put(NO_EQUIPMENT_FOUND_FOR_ADDITIONAL_ORDER, "Failed to stow Additional Order '{$1}'. No Equipment found for Cabin Class '{$2}' and Leg '{$3}'!");
        messages.put(NO_EQUIPMENT_FOUND_FOR_ADDITIONAL_SPML_ORDER, "Failed to stow Additional Special Meal Order '{$1}'. No Equipment found for Cabin Class '{$2}' and Legs '{$3}'!");
        messages.put(MULTIPLE_FILL_CHOICES, "Multiple Choices with Rounding Strategy FILL UP found for the Service '{$1}' and the Meal Type '{$2}'! The FILL UP strategy may only be used once per Meal Type!");
        messages.put(CHOICE_ROUNDING_WITHOUT_FILLUP, "The Rounding Strategy for the Choice '{$}' of the Part '{$2}' of the service '{$3}' was ignored, because no FILL UP choice was found for it's Meal Type!");
        messages.put(UNUSED_MEALTYPE_CONFIGURATION, "The Service '{$1}' contains a Configuration for the Meal Type '{$2}' but this Meal Type is not set for any of the Service Parts!");
        messages.put(NO_VALID_ROTATION, "No valid cycle found for service '{$1}' for std '{$2}'!");
        messages.put(NO_VALID_ROTATION_USE_FIRST_CYCLE, "No valid cycle found for service '{$1}' for std '{$2}'! The first cycle was selected...");
        messages.put(NO_VALID_ROTATION_STD_BIGGER_THAN_START, "No valid cycle found for service '{$1}' for std '{$2}'! Std is before the start date of the fix rotation ({$3})!");
        messages.put(NO_VALID_ROTATION_STD_BIGGER_THAN_START_USE_FIRST_CYCLE, "No valid cycle found for service '{$1}' for std '{$2}'! Std is before the start date of the fix rotation ({$3})! The first cycle was selected...");
        messages.put(ALACARTE_MEAL_NOT_DEFINED_IN_CATALOG, "No product defined in the A la Carte Product Catalog of the Mealplan for the Cycle {$1} and Cabin Class '{$2}', Service Type '{$3}', Meal Type '{$4}', A la Carte Menu Type '{$5}', Bound Direction '{$6}' and Haul Type '{$7}'");
        messages.put(SPECIAL_MEAL_NOT_DEFINED_IN_CATALOG, "No product defined in the Special Meal Product Catalog of the Mealplan for the Cycle {$1} and Cabin Class '{$2}', Service Type '{$3}', Meal Type '{$4}', Special Menu Type '{$5}', Bound Direction '{$6}' and Haul Type '{$7}'");
        messages.put(ADDITIONAL_SPECIAL_MEAL_NOT_DEFINED_IN_CATALOG, "No product defined in the Special Meal Product Catalog of the Mealplan for the Cycle {$1} and Cabin Class '{$2}' and Additional Special Menu Type '{$3}'");
        messages.put(NO_ALCACARTE_CATALOG_DEFINED, "The Flight has A la Carte Orders but no A la Carte Product Catalog is defined for the Mealplan!");
        messages.put(TOO_MANY_SPML_AND_ALACARTE_ORDERS, "Too many Special Meal and/or A la Carte Orders! The number of the orders must not exceed the pax amount!");
        messages.put(FILL_ROUNDING_STRATEGY_WITHOUT_AMOUNT_NORMALIZATION, "Rounding Strategy FILL must only be used if 'normalizeRatioAmounts' is set to true! This is not the case for the Choice '{$1}' in the Loading Group '{$2}' in the Catering Service '{$3}'!");
        messages.put(NO_FIX_PRICE_FOUND, "No fix price found - flight: '{$1}' - date: '{$2}' - paxclass: '{$3}' - leg: '{$4}'.");
        messages.put(NO_VALID_HANDLINGCOST, "HandlingCost '{$1}' - '{$2}' has no valid period!");
        messages.put(NEGATIVE_AMOUNT_TOO_HIGH_FOR_LOADING_GROUP, "The negative Amount for the Loading Group '{$1}' ({$2}) in the Catering Service '{$3}' exceeds the number of delivered Products from RATIO choices ({$4})! Negative Amounts may only be subtracted from RATIO choices.");
        messages.put(NEGATIVE_AMOUNT_TOO_HIGH_FOR_PRODUCT, "The negative Amount for the Product '{$1}' ({$2}) in the Loading Group '{$3}'in the Catering Service '{$4}' exceeds the number of delivered Products ({$5})! Negative Amounts may only be subtracted from RATIO choices.");
        messages.put(NEGATIVE_STEP_IN_STOWING_LIST, "Negative step amount in Instruction for Deliverable '{$1}'!");
        messages.put(NEGATIVE_RESULT_FOR_LINEAR_FUNCTION, "Negative result for the pax related function for the Deliverable '{$1}'!");
        messages.put(NEGATIVE_FIX_AMOUNT_IN_STOWING_LIST, "Negative fix amount for Deliverable '{$1}'!");
        messages.put(NEGATIVE_AMOUNT_FOR_PRODUCT_WITHOUT_RATIO_CHOICE, "Found a negative amount for Product '{$1}' in Loading Group '{$2}' in Catering Service '{$3}', but found no RATIO choice with the same product to subtract the amount from!");
        messages.put(MULTIPLE_RATIO_CHOICES_FOR_SAME_PRODUCT, "Found multiple RATIO Choices for the Product '{$1}' in the Loading Group '{$2}' in the Catering Service '{$3}'!");
        messages.put(RETURNS_COUNT_SPACE_NO_SINGLE_DEPARTMENT, "The Delivery Space '{$1}' contains returns Returns Count Products but has set {$2} departments. Each Returns Count Space must have set exactly one department!");
        messages.put(RETURNS_COUNT_EQUIPMENT_NO_SINGLE_DEPARTMENT, "The Equipment '{$1}' contains returns Returns Count Products but has set {$2} departments. Each Returns Count Equipment must have set exactly one department!");
        messages.put(FAILED_TO_CALCULATE_PRODUCT, "Failed to calculated Product '{$1}', '{$2}'!");
        messages.put(NO_VALID_CURRENCY_VARIANT, "No valid Currency Variant found for '{$1}'!");
        messages.put(NO_MEAL_FOUND_ON_FLIGHT, "No Meal found on Flight '{$1}' at '{$2}'!");
        messages.put(UNABLE_TO_DELETE_FLIGHT, " Unable to set Flight '{$1}' at '{$2}' back to planned: '{$3}'");
        messages.put(NO_STOWING_LIST_FOUND, "No Stowing List found for Flight '{$1}' at '{$2}'");
        messages.put(NO_AIRCRAFT_FOUND, "No Aircraft found for Flight '{$1}' at '{$2}'");
        messages.put(UNABLE_TO_OPEN_FLIGHT, "Unable to open Flight '{$1}' at '{$2}': '{$3}'");
    }
}

