/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.json;

import ch.icit.pegasus.server.core.json.JsonObject;
import ch.icit.util.Invoker;
import ch.icit.util.InvokerException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonConverter {
    public static final String dtypeTag = "__dtype";
    public static final String referencesTag = "__references";
    List<String> references = new ArrayList<String>();
    Set<Object> objectCache = new HashSet<Object>();

    public String toJson(Object source) throws InvokerException {
        return this.toJson(source, true, 0);
    }

    private String toJson(Object source, boolean toplevel, int level) throws InvokerException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getLevelString(level) + "{");
        buffer.append("\n");
        List fields = Invoker.getAllFields(source.getClass(), null);
        String str = this.getLevelString(level + 1) + "\"" + dtypeTag + "\" : \"" + source.getClass().getName() + "\"";
        buffer.append(str);
        for (Field field : fields) {
            Object value = Invoker.getFieldValue((Field)field, (Object)source);
            boolean isReferenceField = this.isReferenceField(field);
            if (value == null) {
                str = this.createNameStringWithColumn(level, field.getName()) + "null";
                str = ",\n" + str;
                buffer.append(str);
                continue;
            }
            if (value instanceof JsonObject) {
                boolean referenceField = this.isReferenceField(field);
                boolean embedded = ((JsonObject)value).isEmbedded();
                this.handleJsonObject(level, buffer, false, field.getName(), value, referenceField, embedded);
                continue;
            }
            if (value instanceof List) {
                this.handleList(level, buffer, field.getName(), isReferenceField, (List)value, true);
                continue;
            }
            if (value instanceof Set) {
                this.handleSet(level, buffer, field.getName(), isReferenceField, (Set)value, true);
                continue;
            }
            if (value instanceof Map) {
                this.handleMap(level, buffer, field.getName(), isReferenceField, (Map)value);
                continue;
            }
            str = this.getLevelString(level + 1) + "\"" + field.getName() + "\" : " + value.toString();
            str = ",\n" + str;
            buffer.append(str);
        }
        if (toplevel) {
            str = this.getLevelString(level + 1) + "\"" + referencesTag + "\" : [";
            boolean f = true;
            for (String reference : this.references) {
                if (!f) {
                    str = str + ",";
                }
                str = str + "\n" + reference;
                f = false;
            }
            str = str + "\n" + this.getLevelString(level + 1) + "]";
            str = ",\n" + str;
            buffer.append(str);
        }
        buffer.append("\n" + this.getLevelString(level) + "}");
        return buffer.toString();
    }

    private String createNameStringWithColumn(int level, String valueName) {
        return this.getLevelString(level + 1) + "\"" + valueName + "\" : ";
    }

    private boolean handleMap(int level, StringBuffer buffer, String fieldName, boolean isReferenceMap, Map value) throws InvokerException {
        String str = this.createNameStringWithColumn(level, fieldName) + "[";
        str = ",\n" + str;
        Map list = value;
        boolean f = true;
        for (Map.Entry objectObjectEntry : list.entrySet()) {
            String s;
            StringBuffer internalBuffer;
            boolean embedded;
            boolean referenceField;
            Object key = objectObjectEntry.getKey();
            Object val = objectObjectEntry.getValue();
            if (key instanceof JsonObject) {
                referenceField = isReferenceMap;
                embedded = ((JsonObject)key).isEmbedded();
                internalBuffer = new StringBuffer();
                this.handleJsonObject(level + 3, internalBuffer, true, "key", key, referenceField, embedded);
                s = internalBuffer.toString();
                s = this.getLevelString(level + 2) + "{ \n" + s + ",\n";
                s = !f ? ",\n" + s : "\n" + s;
                f = false;
                str = str + s;
            } else {
                String s2 = this.getLevelString(level + 2) + "{ \n" + this.getLevelString(level + 3) + "\"key\" : " + key.toString() + ",\n";
                s2 = !f ? ",\n" + s2 : "\n" + s2;
                f = false;
                str = str + s2;
            }
            if (val instanceof JsonObject) {
                referenceField = isReferenceMap;
                embedded = ((JsonObject)val).isEmbedded();
                internalBuffer = new StringBuffer();
                this.handleJsonObject(level + 3, internalBuffer, true, "value", val, referenceField, embedded);
                s = internalBuffer.toString();
                s = s + "\n" + this.getLevelString(level + 2) + "}";
                f = false;
                str = str + s;
                continue;
            }
            if (val instanceof List) {
                StringBuffer internalBuffer2 = new StringBuffer();
                this.handleList(level + 2, internalBuffer2, "value", isReferenceMap, (List)val, false);
                String s3 = internalBuffer2.toString();
                s3 = s3.trim();
                s3 = this.getLevelString(level + 3) + s3;
                s3 = s3 + "\n" + this.getLevelString(level + 2) + "}";
                f = false;
                str = str + s3;
                continue;
            }
            if (val instanceof Set) {
                StringBuffer internalBuffer3 = new StringBuffer();
                this.handleSet(level + 2, internalBuffer3, "value", isReferenceMap, (Set)val, false);
                String s4 = internalBuffer3.toString();
                s4 = s4.trim();
                s4 = this.getLevelString(level + 3) + s4;
                s4 = s4 + "\n" + this.getLevelString(level + 2) + "}";
                f = false;
                str = str + s4;
                continue;
            }
            if (val instanceof Map) {
                StringBuffer internalBuffer4 = new StringBuffer();
                this.handleMap(level + 2, internalBuffer4, "value", isReferenceMap, (Map)val);
                String s5 = internalBuffer4.toString();
                s5 = s5.trim();
                s5 = this.getLevelString(level + 3) + s5;
                s5 = s5 + "\n" + this.getLevelString(level + 2) + "}";
                f = false;
                str = str + s5;
                continue;
            }
            String s6 = this.getLevelString(level + 3) + "\"value\" : " + val.toString();
            s6 = s6 + "\n" + this.getLevelString(2) + "}";
            f = false;
            str = str + s6;
        }
        str = str + "\n" + this.getLevelString(level + 1) + "]";
        buffer.append(str);
        return false;
    }

    private boolean handleSet(int level, StringBuffer buffer, String fieldName, boolean isReferenceList, Set value, boolean toplevel) throws InvokerException {
        return this.handleList(level, buffer, fieldName, isReferenceList, new ArrayList(value), toplevel);
    }

    private boolean handleList(int level, StringBuffer buffer, String fieldName, boolean isReferenceList, List value, boolean toplevel) throws InvokerException {
        String str = this.createNameStringWithColumn(level, fieldName) + "[";
        if (toplevel) {
            str = ",\n" + str;
        }
        List list = value;
        boolean f = true;
        for (Object listEntry : list) {
            if (listEntry instanceof JsonObject) {
                boolean referenceField = isReferenceList;
                boolean embedded = ((JsonObject)listEntry).isEmbedded();
                StringBuffer internalBuffer = new StringBuffer();
                this.handleJsonObject(level + 2, internalBuffer, true, "value", listEntry, referenceField, embedded);
                String s = internalBuffer.toString();
                s = s.trim();
                s = this.getLevelString(level + 2) + "{ \n" + this.getLevelString(level + 3) + s + "\n" + this.getLevelString(level + 2) + "}";
                s = !f ? ",\n" + s : "\n" + s;
                f = false;
                str = str + s;
                continue;
            }
            if (listEntry instanceof List) {
                StringBuffer internalBuffer = new StringBuffer();
                this.handleList(level + 2, internalBuffer, "value", isReferenceList, (List)listEntry, false);
                String s = internalBuffer.toString();
                s = s.trim();
                s = this.getLevelString(level + 2) + "{ \n" + this.getLevelString(level + 3) + s + "\n" + this.getLevelString(level + 2) + "}";
                s = !f ? ",\n" + s : "\n" + s;
                f = false;
                str = str + s;
                continue;
            }
            if (listEntry instanceof Set) {
                StringBuffer internalBuffer = new StringBuffer();
                this.handleSet(level + 2, internalBuffer, "value", isReferenceList, (Set)listEntry, false);
                String s = internalBuffer.toString();
                s = s.trim();
                s = this.getLevelString(level + 2) + "{ \n" + this.getLevelString(level + 3) + s + "\n" + this.getLevelString(level + 2) + "}";
                s = !f ? ",\n" + s : "\n" + s;
                f = false;
                str = str + s;
                continue;
            }
            if (listEntry instanceof Map) {
                StringBuffer internalBuffer = new StringBuffer();
                this.handleMap(level + 2, internalBuffer, "value", isReferenceList, (Map)listEntry);
                String s = internalBuffer.toString();
                s = s.trim();
                s = this.getLevelString(level + 2) + "{ \n" + this.getLevelString(level + 3) + s + "\n" + this.getLevelString(level + 2) + "}";
                s = !f ? ",\n" + s : "\n" + s;
                f = false;
                str = str + s;
                continue;
            }
            String s = this.getLevelString(level + 2) + "{\n" + this.getLevelString(level + 3) + "\"value\" : " + listEntry.toString() + "\n" + this.getLevelString(level + 2) + "}";
            s = !f ? ",\n" + s : "\n" + s;
            f = false;
            str = str + s;
        }
        str = str + "\n" + this.getLevelString(level + 1) + "]";
        buffer.append(str);
        return false;
    }

    private void handleJsonObject(int level, StringBuffer buffer, boolean first, String fieldName, Object value, boolean referenceField, boolean embedded) throws InvokerException {
        if (referenceField) {
            String str = this.getLevelString(level + 1) + "\"" + fieldName + "\" : \"" + value.getClass().getSimpleName() + "_" + ((JsonObject)value).getId() + "\"";
            if (!first) {
                str = ",\n" + str;
            }
            buffer.append(str);
        } else if (!embedded) {
            if (!this.objectCache.contains(value)) {
                String topLevelEntry = this.toJson(value, false, 4);
                String entry = this.getLevelString(3) + "\"" + value.getClass().getSimpleName() + "_" + ((JsonObject)value).getId() + "\": " + topLevelEntry;
                this.references.add(entry);
                this.objectCache.add(value);
            }
            String str = this.getLevelString(level + 1) + "\"" + fieldName + "\" : \"" + value.getClass().getSimpleName() + "_" + ((JsonObject)value).getId() + "\"";
            if (!first) {
                str = ",\n" + str;
            }
            buffer.append(str);
        } else {
            String ret = this.toJson(value, false, level + 1);
            String str = this.getLevelString(level + 1) + "\"" + fieldName + "\" :" + ret;
            if (!first) {
                str = ",\n" + str;
            }
            buffer.append(str);
        }
    }

    private String getLevelString(int level) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buffer.append("\t");
        }
        return buffer.toString();
    }

    public boolean isReferenceField(Field field) {
        return true;
    }

    public Object getReferencedField(String idName) {
        return null;
    }
}

