/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListUtils {
    public static final <T> List<List<T>> split(List<T> original, int maxListSize, Class<? extends List> listImplementation) {
        if (maxListSize <= 0) {
            throw new IllegalArgumentException("maxListSize must be greater than zero");
        }
        Object[] elements = original.toArray();
        int maxChunks = (int)Math.ceil((double)elements.length / (double)maxListSize);
        ArrayList<List<T>> lists = new ArrayList<List<T>>(maxChunks);
        for (int i = 0; i < maxChunks; ++i) {
            int from = i * maxListSize;
            int to = Math.min(from + maxListSize, elements.length);
            Object[] range = Arrays.copyOfRange(elements, from, to);
            lists.add(ListUtils.createSublist(range, listImplementation));
        }
        return lists;
    }

    public static final <T> List<List<T>> split(List<T> original, int maxListSize) {
        return ListUtils.split(original, maxListSize, ArrayList.class);
    }

    private static <T> List<T> createSublist(T[] elements, Class<? extends List> listImplementation) {
        List<T> sublist;
        List<T> asList = Arrays.asList(elements);
        try {
            sublist = listImplementation.newInstance();
            sublist.addAll(asList);
        }
        catch (InstantiationException e) {
            sublist = asList;
        }
        catch (IllegalAccessException e) {
            sublist = asList;
        }
        return sublist;
    }
}

