/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourcesLoader {
    private static final Logger log = LoggerFactory.getLogger(ResourcesLoader.class);

    private ResourcesLoader() {
    }

    public static final URL getResource(String name) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(name);
        if (url == null) {
            log.warn("Resource [" + name + "] not found!");
        } else {
            log.debug("Resource [name=" + name + "] -> [url=" + url.toString() + "]");
        }
        try {
            url = ResourcesLoader.escapeWhiteSpaces(url);
        }
        catch (MalformedURLException e) {
            log.error("", (Throwable)e);
        }
        return url;
    }

    public static final InputStream getResourceAsStream(String name) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(name);
        if (is == null) {
            log.warn("Resource [" + name + "] not found!");
        } else {
            log.debug("Resource [name=" + name + "] -> InputStream");
        }
        return is;
    }

    public static List<URL> getResources(String name) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> urls = null;
        try {
            urls = cl.getResources(name);
        }
        catch (IOException e) {
            log.debug("I/O problem with resource: [" + name + "]", (Throwable)e);
            throw e;
        }
        ArrayList<URL> escapedUrls = new ArrayList<URL>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            escapedUrls.add(ResourcesLoader.escapeWhiteSpaces(url));
        }
        return escapedUrls;
    }

    private static final URL escapeWhiteSpaces(URL url) throws MalformedURLException {
        String path = url.toExternalForm();
        return new URL(path);
    }
}

