/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils;

public enum BarcodeDevice {
    DELOCK(true),
    MC_9300(false),
    POWER_SCAN_PD7100(true),
    HONEYWELL_1300G(true),
    SYMBOL_Z2FLRM(true),
    MOTOROLA_RSXXX(false),
    MANHATTAN(true),
    PROGLOVE_MARK3(false);

    private boolean onWorkstation;

    private BarcodeDevice(boolean workstation) {
        this.onWorkstation = workstation;
    }

    public boolean isOnWorkstation() {
        return this.onWorkstation;
    }

    public String toString() {
        switch (this) {
            case MC_9300: {
                return "Zebra (MC9300)";
            }
            case MOTOROLA_RSXXX: {
                return "Motorola (RS507, RS5100)";
            }
            case PROGLOVE_MARK3: {
                return "Mark3";
            }
            case HONEYWELL_1300G: {
                return "Honeywell (1300G)";
            }
            case POWER_SCAN_PD7100: {
                return "PowerScan (PD7100)";
            }
            case SYMBOL_Z2FLRM: {
                return "Symbol (Z2FLRM)";
            }
            case DELOCK: {
                return "Delock (90507, QR Code)";
            }
            case MANHATTAN: {
                return "Manhattan";
            }
        }
        return "";
    }
}

