/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils.builder;

import ch.icit.utils.BarcodeType;
import ch.icit.utils.GTINCategory;
import ch.icit.utils.builder.BarcodeBuilderEAN128;
import ch.icit.utils.builder.BarcodeBuilderEAN13;
import ch.icit.utils.builder.BarcodeBuilderEANX;

public class BarcodeBuilder {
    private static BarcodeBuilder builder = new BarcodeBuilder();
    private BarcodeBuilderEAN13 barcodeBuilderEAN13 = new BarcodeBuilderEAN13();
    private BarcodeBuilderEAN128 barcodeBuilderEAN128 = new BarcodeBuilderEAN128();
    private BarcodeBuilderEANX barcodeBuilderEANX = new BarcodeBuilderEANX();

    public static BarcodeBuilder getBuilder() {
        return builder;
    }

    private BarcodeBuilder() {
    }

    public BarcodeBuilderEAN128 getBarcodeBuilderEAN128() {
        return this.barcodeBuilderEAN128;
    }

    public BarcodeBuilderEAN13 getBarcodeBuilderEAN13() {
        return this.barcodeBuilderEAN13;
    }

    public BarcodeBuilderEANX getBarcodeBuilderEANX() {
        return this.barcodeBuilderEANX;
    }

    public String createBarcode(String companyCode, GTINCategory category, String content, BarcodeType type, boolean silent) {
        switch (type) {
            case EAN_13: {
                return this.barcodeBuilderEAN13.createEAN13Barcode(content, category, companyCode, silent);
            }
            case EAN_128: {
                return this.barcodeBuilderEAN128.createEAN128Barcode(content, category, companyCode, silent);
            }
        }
        throw new IllegalStateException("Unknown Barcode Type");
    }

    public String createBarcodeWithChecksum(String companyCode, GTINCategory category, String content, BarcodeType type, boolean silent) {
        switch (type) {
            case EAN_13: {
                return this.barcodeBuilderEAN13.createEAN13BarcodeWithChecksum(content, category, companyCode, silent);
            }
            case EAN_128: {
                break;
            }
        }
        throw new IllegalStateException("Unknown Barcode Type");
    }

    public String createBarcodeWithoutCategoryWithChecksum(String company, String content, BarcodeType type, boolean silent) {
        switch (type) {
            case EAN_13: {
                return this.barcodeBuilderEAN13.createBarcodeWithoutCategoryWithChecksum(company, content);
            }
            case EAN_128: {
                break;
            }
        }
        throw new IllegalStateException("Unknown Barcode Type");
    }

    public String readCompanyCode(String barcode, String expectedCompany, GTINCategory expectedCategory, BarcodeType type, boolean silent) {
        switch (type) {
            case EAN_13: {
                this.barcodeBuilderEAN13.validateBarcode(barcode, expectedCategory, expectedCompany, silent);
                return this.barcodeBuilderEAN13.readBarcodeCompanyOfEAN13(barcode);
            }
            case EAN_128: {
                this.barcodeBuilderEAN128.validateBarcode(barcode, expectedCategory, expectedCompany, silent);
                return this.barcodeBuilderEAN128.readCompanyOfEAN128(barcode);
            }
            case EAN_X: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown Barcode Type");
    }

    public GTINCategory readCategory(String barcode, String expectedCompany, GTINCategory expectedCategory, BarcodeType type, boolean silent) {
        switch (type) {
            case EAN_13: {
                this.barcodeBuilderEAN13.validateBarcode(barcode, expectedCategory, expectedCompany, silent);
                return this.barcodeBuilderEAN13.readBarcodeCategoryOfEAN13(barcode);
            }
            case EAN_128: {
                this.barcodeBuilderEAN128.validateBarcode(barcode, expectedCategory, expectedCompany, silent);
                return this.barcodeBuilderEAN128.readCategoryOfEAN128(barcode);
            }
            case EAN_X: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown Barcode Type");
    }

    public String readContent(String barcode, String expectedCompany, GTINCategory expectedCategory, BarcodeType type, boolean silent) {
        switch (type) {
            case EAN_13: {
                this.barcodeBuilderEAN13.validateBarcode(barcode, expectedCategory, expectedCompany, silent);
                return this.barcodeBuilderEAN13.readBarcodeContentOfEAN13(barcode);
            }
            case EAN_128: {
                this.barcodeBuilderEAN128.validateBarcode(barcode, expectedCategory, expectedCompany, silent);
                return this.barcodeBuilderEAN128.readContentOfEAN128(barcode);
            }
            case EAN_X: {
                return barcode;
            }
        }
        throw new IllegalStateException("Unknown Barcode Type");
    }

    public Integer readContentAsInteger(String barcode, String expectedCompany, GTINCategory expectedCategory, BarcodeType type, boolean silent) {
        switch (type) {
            case EAN_13: {
                this.barcodeBuilderEAN13.validateBarcode(barcode, expectedCategory, expectedCompany, silent);
                return this.barcodeBuilderEAN13.readBarcodeContentOfEAN13AsInteger(barcode);
            }
            case EAN_128: {
                break;
            }
            case EAN_X: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown Barcode Type");
    }

    public BarcodeType getBarcodeType(String usedBarcode) {
        if (usedBarcode.length() == 12 || usedBarcode.length() == 13) {
            return BarcodeType.EAN_13;
        }
        if (usedBarcode.length() == 20 || usedBarcode.length() == 21) {
            return BarcodeType.EAN_128;
        }
        return BarcodeType.EAN_X;
    }
}

