/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils.reader;

import ch.icit.utils.BarcodeDevice;
import ch.icit.utils.BarcodeType;
import ch.icit.utils.builder.BarcodeBuilder;
import ch.icit.utils.reader.BarcodeListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;

public class BarcodeHandler {
    private BarcodeDevice currentDevice;
    private BarcodeListener listener;
    private String currentBarcode = "";
    private int endOffset = 1;
    private KeyAdapter keyListener;
    private String companyCode;

    public BarcodeHandler(BarcodeListener listener, String companyCode) {
        this.listener = listener;
        this.companyCode = companyCode;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public BarcodeDevice getCurrentDevice() {
        return this.currentDevice;
    }

    public void setCurrentDevice(BarcodeDevice currentDevice) {
        this.currentDevice = currentDevice;
    }

    public void registerInputListener(JComponent component) {
        if (this.keyListener != null) {
            component.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
        switch (this.getCurrentDevice()) {
            case MC_9300: 
            case PROGLOVE_MARK3: 
            case MOTOROLA_RSXXX: 
            case DELOCK: 
            case POWER_SCAN_PD7100: {
                this.keyListener = new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        BarcodeHandler.this.currentBarcode = BarcodeHandler.this.currentBarcode + e.getKeyChar();
                        if (e.getKeyCode() == 10) {
                            String usedBarcode = BarcodeHandler.this.currentBarcode;
                            if ((usedBarcode = usedBarcode.substring(0, usedBarcode.length() - 1)).endsWith("\n")) {
                                usedBarcode = usedBarcode.substring(0, usedBarcode.length() - 1);
                            }
                            BarcodeType barcodeType = BarcodeBuilder.getBuilder().getBarcodeType(usedBarcode);
                            if (!usedBarcode.trim().isEmpty()) {
                                BarcodeHandler.this.listener.barcodeReady(barcodeType, usedBarcode);
                            }
                            BarcodeHandler.this.currentBarcode = "";
                        }
                    }
                };
                component.addKeyListener(this.keyListener);
                break;
            }
            case SYMBOL_Z2FLRM: {
                this.keyListener = new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        BarcodeHandler.this.currentBarcode = BarcodeHandler.this.currentBarcode + e.getKeyChar();
                        int targetLength = BarcodeHandler.this.companyCode.length() == 1 ? 12 : 13;
                        if (BarcodeHandler.this.currentBarcode.length() == targetLength) {
                            String usedBarcode = BarcodeHandler.this.currentBarcode;
                            BarcodeType barcodeType = BarcodeBuilder.getBuilder().getBarcodeType(usedBarcode);
                            if (!usedBarcode.trim().isEmpty()) {
                                BarcodeHandler.this.listener.barcodeReady(barcodeType, usedBarcode);
                            }
                        }
                    }
                };
                component.addKeyListener(this.keyListener);
                break;
            }
            case HONEYWELL_1300G: 
            case MANHATTAN: {
                this.keyListener = new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        BarcodeHandler.this.currentBarcode = BarcodeHandler.this.currentBarcode + e.getKeyChar();
                        if (e.getKeyCode() == 40) {
                            String usedBarcode = BarcodeHandler.this.currentBarcode;
                            if ((usedBarcode = usedBarcode.substring(0, usedBarcode.length() - 1)).endsWith("\n")) {
                                usedBarcode = usedBarcode.substring(0, usedBarcode.length() - 1);
                            }
                            BarcodeType barcodeType = BarcodeBuilder.getBuilder().getBarcodeType(usedBarcode);
                            if (!usedBarcode.trim().isEmpty()) {
                                BarcodeHandler.this.listener.barcodeReady(barcodeType, usedBarcode);
                            }
                            BarcodeHandler.this.currentBarcode = "";
                        }
                    }
                };
                component.addKeyListener(this.keyListener);
            }
        }
    }

    public void resetBarcode() {
        this.currentBarcode = "";
    }
}

