/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils;

import ch.icit.utils.ExcelCell;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkitException;
import ch.icit.utils.StyledWorkbook;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CSVWorkbook
extends StyledWorkbook {
    private final String columnSeparator;
    private final String lineSeparator;
    private final String unixNewLine = "\n";
    SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    List<String> lines = new ArrayList<String>();

    public CSVWorkbook() {
        this(",", "\r\n");
    }

    public CSVWorkbook(String columnSeparator, String lineSeparator) {
        super(null);
        this.columnSeparator = columnSeparator;
        this.lineSeparator = lineSeparator;
    }

    public void appendLine(String line) {
        this.lines.add(line);
    }

    public void appendLine(ExcelRow row) {
        StringBuffer line = new StringBuffer();
        for (int i = 0; i < row.getCells().size(); ++i) {
            Object value;
            if (i != 0 && i != row.getCells().size()) {
                line.append(this.columnSeparator);
            }
            if ((value = row.getCellValue(i)) instanceof ExcelCell) {
                Object valueX = ((ExcelCell)value).getValue();
                if (valueX == null) {
                    line.append("");
                    continue;
                }
                if (valueX instanceof Date) {
                    this.innerAppend(line, this.dateFormat.format(valueX));
                    continue;
                }
                if (valueX instanceof Timestamp) {
                    this.innerAppend(line, this.dateFormat.format(valueX));
                    continue;
                }
                if (valueX instanceof java.sql.Date) {
                    this.innerAppend(line, this.dateFormat.format(valueX));
                    continue;
                }
                if (valueX instanceof Time) {
                    this.innerAppend(line, this.dateFormat.format(valueX));
                    continue;
                }
                this.innerAppend(line, valueX.toString().trim().replaceAll(this.columnSeparator, "").replaceAll(this.lineSeparator, "").replaceAll("\n", ""));
                continue;
            }
            if (value instanceof Date) {
                this.innerAppend(line, this.dateFormat.format(value));
                continue;
            }
            if (value instanceof Timestamp) {
                this.innerAppend(line, this.dateFormat.format(value));
                continue;
            }
            if (value instanceof java.sql.Date) {
                this.innerAppend(line, this.dateFormat.format(value));
                continue;
            }
            if (value instanceof Time) {
                this.innerAppend(line, this.dateFormat.format(value));
                continue;
            }
            this.innerAppend(line, value == null ? "" : value.toString().trim().replaceAll(this.columnSeparator, "").replaceAll(this.lineSeparator, "").replaceAll("\n", ""));
        }
        line.append(this.lineSeparator);
        this.lines.add(line.toString());
    }

    private void innerAppend(StringBuffer buffer, String value) {
        buffer.append(value);
    }

    public File writeToFile(String newPath) throws ExcelToolkitException {
        BufferedWriter brOut;
        File f = new File(newPath);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                throw new ExcelToolkitException(e);
            }
        }
        try {
            brOut = Files.newBufferedWriter(Paths.get(newPath, new String[0]), StandardCharsets.UTF_16, StandardOpenOption.WRITE);
        }
        catch (IOException e1) {
            throw new ExcelToolkitException(e1);
        }
        for (String line : this.lines) {
            try {
                brOut.write(line);
            }
            catch (IOException e1) {
                throw new ExcelToolkitException(e1);
            }
        }
        try {
            brOut.close();
        }
        catch (IOException e) {
            throw new ExcelToolkitException(e);
        }
        return f;
    }
}

