/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils;

import ch.icit.utils.ExcelGroupToolkit;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelRowCreator;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import ch.icit.utils.StyledWorkbook;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelGroup {
    private ExcelRow header = new ExcelRow(null);
    private Map<Object, ExcelRow> rows = new HashMap<Object, ExcelRow>();
    private boolean noHorizontalSum = false;
    private boolean enableSecondSum = false;
    private Object defaultFillObject = "";
    private List<String> additionalColumns = new ArrayList<String>();
    private boolean useAdditionalColumnsForSumRow = true;
    private String horizontalString;
    private String secondHorizontalString;
    private Object userObject;
    private ExcelRowCreator rowCreator;
    private boolean useVeritcalSum = true;
    private Set<Integer> ignoreColumns = new HashSet<Integer>();
    private Set<Integer> substractColumns = new HashSet<Integer>();

    public ExcelGroup(Object userObject) {
        this.userObject = userObject;
    }

    public void setUseAdditionalColumnsForSumRow(boolean useAdditionalColumnsForSumRow) {
        this.useAdditionalColumnsForSumRow = useAdditionalColumnsForSumRow;
    }

    public void addIgnoreColumn(int column) {
        this.ignoreColumns.add(column);
    }

    public void addSubstractColumn(int column) {
        this.substractColumns.add(column);
    }

    public List<String> getAdditionalColumns() {
        return this.additionalColumns;
    }

    public String getSecondHorizontalString() {
        return this.secondHorizontalString;
    }

    public void setSecondHorizontalString(String secondHorizontalString) {
        this.secondHorizontalString = secondHorizontalString;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setNoHorizontalSum(boolean b) {
        this.noHorizontalSum = b;
    }

    public String getHorizontalSumString() {
        return this.horizontalString;
    }

    public void addHeader(Object object, String ... fields) {
        this.header.addCell(object, fields);
    }

    public int ensureRows(List userObjects, int position, List objects, String userObjectField, String[] titles, String ... fields) {
        for (int i = 0; i < userObjects.size(); ++i) {
            Object u;
            Object base = u = userObjects.get(i);
            if (userObjectField != null && !userObjectField.isEmpty()) {
                u = ExcelGroupToolkit.reflectionRead(u, userObjectField);
            }
            Object o = objects.get(i);
            this.ensureRow(u, base, position, o, titles, fields);
        }
        return userObjects.size();
    }

    public ExcelRow ensureRow(Object userObject, Object baseObject, int position, Object object, String[] titles, String ... fields) {
        ExcelRow cr = this.rows.get(userObject);
        if (cr == null) {
            cr = this.rowCreator != null ? this.rowCreator.getNewExcelRow(userObject, false) : new ExcelRow(userObject);
            cr.addCell(object, titles);
            cr.setBaseUserObject(baseObject);
            this.rows.put(userObject, cr);
        }
        this.fill(cr, position);
        cr.addCell(object, fields);
        return cr;
    }

    public int writeGroup(StyledWorkbook workbook, Sheet sheet, int verticalSumOffset, int verticalSumJump, int horizontalSumOffset, int horizontalSumJump, Comparator<ExcelRow> comparator, int rowLength, int cr) throws ExcelToolkitException {
        String column;
        String sumString;
        int currentRow;
        int startRow = currentRow = cr;
        if (this.header != null && this.header.getCellCount() > 0) {
            currentRow = this.header.writeRow(workbook, sheet, true, currentRow, null);
        }
        if (this.rows.isEmpty()) {
            return cr;
        }
        ArrayList<ExcelRow> dr = new ArrayList<ExcelRow>();
        dr.addAll(this.rows.values());
        String horizontalSumString = "=SUM(";
        String secondHSumString = "=SUM(";
        String thirdHSumString = "=SUM(";
        String fourthHSumString = "=SUM(";
        String fifthHSumString = "=SUM(";
        String sixthHSumString = "=SUM(";
        String seventhHSumString = "=SUM(";
        String eightHSumString = "=SUM(";
        if (horizontalSumOffset != -1) {
            for (int i = horizontalSumOffset; i <= rowLength; i += horizontalSumJump) {
                if (this.ignoreColumns.contains(i)) continue;
                boolean substract = this.substractColumns.contains(i);
                horizontalSumString = horizontalSumString + (substract ? "-1*" : "") + this.getColumn(i, true);
                horizontalSumString = horizontalSumString + ",";
                secondHSumString = secondHSumString + (substract ? "-1*" : "") + this.getColumn(i - 1, true);
                secondHSumString = secondHSumString + ",";
                thirdHSumString = thirdHSumString + (substract ? "-1*" : "") + this.getColumn(i - 2, true);
                thirdHSumString = thirdHSumString + ",";
                fourthHSumString = fourthHSumString + (substract ? "-1*" : "") + this.getColumn(i - 3, true);
                fourthHSumString = fourthHSumString + ",";
                fifthHSumString = fifthHSumString + (substract ? "-1*" : "") + this.getColumn(i - 4, true);
                fifthHSumString = fifthHSumString + ",";
                if (i - 5 > horizontalSumOffset) {
                    sixthHSumString = sixthHSumString + (substract ? "-1*" : "") + this.getColumn(i - 5, true);
                    sixthHSumString = sixthHSumString + ",";
                }
                if (i - 6 > horizontalSumOffset) {
                    seventhHSumString = seventhHSumString + (substract ? "-1*" : "") + this.getColumn(i - 6, true);
                    seventhHSumString = seventhHSumString + ",";
                }
                if (i - 7 <= horizontalSumOffset) continue;
                eightHSumString = eightHSumString + (substract ? "-1*" : "") + this.getColumn(i - 7, true);
                eightHSumString = eightHSumString + ",";
            }
            if (horizontalSumString.length() > 5) {
                horizontalSumString = horizontalSumString.substring(0, horizontalSumString.length() - 1);
            }
            horizontalSumString = horizontalSumString + ")";
            if (secondHSumString.length() > 5) {
                secondHSumString = secondHSumString.substring(0, secondHSumString.length() - 1);
            }
            secondHSumString = secondHSumString + ")";
            if (thirdHSumString.length() > 5) {
                thirdHSumString = thirdHSumString.substring(0, thirdHSumString.length() - 1);
            }
            thirdHSumString = thirdHSumString + ")";
            if (fourthHSumString.length() > 5) {
                fourthHSumString = fourthHSumString.substring(0, fourthHSumString.length() - 1);
            }
            fourthHSumString = fourthHSumString + ")";
            if (fifthHSumString.length() > 5) {
                fifthHSumString = fifthHSumString.substring(0, fifthHSumString.length() - 1);
            }
            fifthHSumString = fifthHSumString + ")";
            if (sixthHSumString.length() > 5) {
                sixthHSumString = sixthHSumString.substring(0, sixthHSumString.length() - 1);
            }
            sixthHSumString = sixthHSumString + ")";
            if (seventhHSumString.length() > 5) {
                seventhHSumString = seventhHSumString.substring(0, seventhHSumString.length() - 1);
            }
            seventhHSumString = seventhHSumString + ")";
            if (eightHSumString.length() > 5) {
                eightHSumString = eightHSumString.substring(0, eightHSumString.length() - 1);
            }
            eightHSumString = eightHSumString + ")";
        } else {
            horizontalSumString = null;
            secondHSumString = null;
            thirdHSumString = null;
            fourthHSumString = null;
            fifthHSumString = null;
            sixthHSumString = null;
            seventhHSumString = null;
            eightHSumString = null;
        }
        this.horizontalString = horizontalSumString;
        this.secondHorizontalString = this.enableSecondSum ? secondHSumString : null;
        Collections.sort(dr, comparator);
        for (ExcelRow r : dr) {
            this.fill(r, rowLength);
            sumString = horizontalSumString;
            r.setAdditionalColumns(this.additionalColumns);
            currentRow = this.enableSecondSum ? r.writeRow(workbook, sheet, false, currentRow, this.secondHorizontalString, sumString) : r.writeRow(workbook, sheet, false, currentRow, sumString, this.secondHorizontalString);
            for (String s : this.additionalColumns) {
                String formatted = s.replaceAll("&", "" + (currentRow + 1));
                r.addCell(formatted, new String[0]);
            }
        }
        ExcelRow sum = new ExcelRow(null);
        sum.addCell(this.getSubTotalString(), new String[0]);
        if (this.getUseVeritcalSum() && verticalSumOffset != -1) {
            this.fill(sum, verticalSumOffset);
            for (int i = verticalSumOffset; i < rowLength; i += verticalSumJump) {
                sumString = "=SUM(";
                column = this.getColumn(i + 1, false);
                sumString = sumString + column + startRow;
                sumString = sumString + ":" + column + currentRow + ")";
                sum.addCell(sumString, new String[0]);
                this.fill(sum, Math.min(i + verticalSumJump, rowLength));
            }
            if (this.useAdditionalColumnsForSumRow) {
                for (String s : this.additionalColumns) {
                    String formatted = s.replaceAll("&", "" + currentRow);
                    sum.addCell(formatted, new String[0]);
                }
            }
        }
        String sumString2 = "=SUM(";
        String secondSumString = "=SUM(";
        if (this.noHorizontalSum) {
            sumString2 = null;
            secondSumString = null;
        } else {
            column = this.getColumn(sum.getCellCount() + 1, false);
            sumString2 = sumString2 + column + startRow;
            sumString2 = sumString2 + ":" + column + currentRow + ")";
            column = this.getColumn(sum.getCellCount() + 2, false);
            secondSumString = secondSumString + column + startRow;
            secondSumString = secondSumString + ":" + column + currentRow + ")";
        }
        if (!this.enableSecondSum) {
            secondSumString = null;
        }
        if (!this.noHorizontalSum) {
            currentRow = sum.writeRow(workbook, sheet, true, currentRow, sumString2, secondSumString);
        }
        currentRow = ExcelToolkit.addSpace(sheet, currentRow);
        return currentRow;
    }

    public String getSubTotalString() {
        return "Subtotal...";
    }

    public String getColumn(int column, boolean withPattern) {
        String t = ExcelToolkit.getAlpha4Digit(column);
        if (withPattern) {
            t = t + ExcelRow.columnWildCard;
        }
        return t;
    }

    private void fill(ExcelRow row, int to) {
        while (row.getCellCount() < to) {
            row.addCell(this.defaultFillObject, new String[0]);
        }
    }

    public void setDefaultFillObject(Object defaultFillObject) {
        this.defaultFillObject = defaultFillObject;
    }

    public Object getTitle() {
        return this.header.getCellValue(0);
    }

    public void addRow(ExcelRow row) {
        this.rows.put(row.getUserObject(), row);
    }

    public boolean hasRows() {
        return !this.rows.isEmpty();
    }

    public void setEnableSecondSum(boolean enableSecondSum2) {
        this.enableSecondSum = enableSecondSum2;
    }

    public void setRowCreator(ExcelRowCreator rowCreator) {
        this.rowCreator = rowCreator;
    }

    public boolean getUseVeritcalSum() {
        return this.useVeritcalSum;
    }

    public void setUseVeritcalSum(boolean useVeritcalSum) {
        this.useVeritcalSum = useVeritcalSum;
    }
}

