/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils;

import ch.icit.utils.ExcelGroup;
import ch.icit.utils.ExcelGroupToolkit;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelRowCreator;
import ch.icit.utils.ExcelToolkitException;
import ch.icit.utils.StyledWorkbook;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelGroupStack {
    private Map<Object, ExcelGroup> groups = new HashMap<Object, ExcelGroup>();
    private boolean hasNoHorizontalSum;
    private boolean enableSecondSum;
    private ExcelRowCreator rowCreator;

    public void setAddtionalColumns(List<String> columns) {
        for (Map.Entry<Object, ExcelGroup> c : this.groups.entrySet()) {
            c.getValue().getAdditionalColumns().addAll(columns);
        }
    }

    public void setUseAdditionalColumnsForSumRow(boolean useAdditionalColumnsForSumRow) {
        for (Map.Entry<Object, ExcelGroup> c : this.groups.entrySet()) {
            c.getValue().setUseAdditionalColumnsForSumRow(useAdditionalColumnsForSumRow);
        }
    }

    public boolean getEnableSecondSum() {
        return this.enableSecondSum;
    }

    public void setEnableSecondSum(boolean enableSecondSum) {
        this.enableSecondSum = enableSecondSum;
        if (!this.groups.isEmpty()) {
            for (ExcelGroup g : this.groups.values()) {
                g.setEnableSecondSum(enableSecondSum);
            }
        }
    }

    public void addItems(String groupNamePrefix, String groupNameField, List objects, String groupField, String rowField, String[] titleFields, String[] valueFields, int position) {
        for (Object o : objects) {
            Object groupObject = ExcelGroupToolkit.reflectionRead(o, groupField);
            Object rowObject = ExcelGroupToolkit.reflectionRead(o, rowField);
            ExcelGroup group = this.groups.get(groupObject);
            if (group == null) {
                group = new ExcelGroup(groupObject);
                group.setRowCreator(this.rowCreator);
                group.setNoHorizontalSum(this.hasNoHorizontalSum);
                group.setEnableSecondSum(this.enableSecondSum);
                String groupName = groupNamePrefix + " ";
                String dynamicName = "" + ExcelGroupToolkit.reflectionRead(o, groupNameField);
                groupName = groupName.contains(ExcelRow.columnWildCard) ? groupName.replaceAll(ExcelRow.columnWildCard, dynamicName) : groupName + " " + dynamicName;
                group.addHeader(groupName, new String[0]);
                this.groups.put(groupObject, group);
            }
            group.ensureRow(rowObject, o, position, o, titleFields, valueFields);
        }
    }

    public int writeGroups(StyledWorkbook workbook, Sheet sheet, int verticalSumOffset, int verticalSumJump, int horizontalSumOffset, int horizontalSumJump, int rowLength, int cr, Comparator<ExcelGroup> groupComparator, Comparator<ExcelRow> rowComparator) throws ExcelToolkitException {
        int currentRow = cr;
        ArrayList<ExcelGroup> gs = new ArrayList<ExcelGroup>();
        gs.addAll(this.groups.values());
        if (groupComparator != null) {
            Collections.sort(gs, groupComparator);
        }
        for (ExcelGroup group : gs) {
            currentRow = group.writeGroup(workbook, sheet, verticalSumOffset, verticalSumJump, horizontalSumOffset, horizontalSumJump, rowComparator, rowLength, currentRow);
        }
        return currentRow;
    }

    public String getHorizontalSum() {
        for (ExcelGroup g : this.groups.values()) {
            String t = g.getHorizontalSumString();
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public void setHasNoHorizontalSum(boolean b) {
        this.hasNoHorizontalSum = b;
        if (!this.groups.isEmpty()) {
            for (ExcelGroup g : this.groups.values()) {
                g.setNoHorizontalSum(this.hasNoHorizontalSum);
            }
        }
    }

    public void setRowCreator(ExcelRowCreator excelRowCreator) {
        this.rowCreator = excelRowCreator;
    }
}

