/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class StyledWorkbook {
    private Workbook workbook;
    private Font defaultFont;
    private Font headerFont;
    private CellStyle headerLeftStyle;
    private CellStyle headerRightStyle;
    private CellStyle headerDecimalStyle;
    private CellStyle headerIntegerStyle;
    private CellStyle headerIntegerWithoutSeperatorStyle;
    private CellStyle headerDateStyle;
    private CellStyle headerDateTimeStyle;
    private CellStyle headerTimeStyle;
    private CellStyle headerDefaultStyle;
    private CellStyle leftStyle;
    private CellStyle rightStyle;
    private CellStyle integerStyle;
    private CellStyle integerWithoutSeperatorStyle;
    private CellStyle decimalStyle;
    private CellStyle defaultStyle;
    private CellStyle dateStyle;
    private CellStyle dateTimeStyle;
    private CellStyle timeStyle;
    private CellStyle cateringPointDurationStyle;
    private boolean useIntegerStyleWithoutSeperator = false;
    private double defaultImageWidth = 2.0;
    private Map<Integer, CellStyle> columnStylesMap = new HashMap<Integer, CellStyle>();

    public StyledWorkbook(Workbook workbook) {
        this.workbook = workbook;
        if (workbook == null) {
            return;
        }
        this.headerFont = workbook.createFont();
        this.headerFont.setFontHeightInPoints((short)10);
        this.headerFont.setColor((short)0);
        this.headerFont.setBold(true);
        this.defaultFont = workbook.createFont();
        this.defaultFont.setFontHeightInPoints((short)10);
        this.defaultFont.setColor((short)0);
        this.headerLeftStyle = workbook.createCellStyle();
        this.headerRightStyle = workbook.createCellStyle();
        this.headerDecimalStyle = workbook.createCellStyle();
        this.headerIntegerStyle = workbook.createCellStyle();
        this.headerIntegerWithoutSeperatorStyle = workbook.createCellStyle();
        this.headerDateStyle = workbook.createCellStyle();
        this.headerDateTimeStyle = workbook.createCellStyle();
        this.headerTimeStyle = workbook.createCellStyle();
        this.headerDefaultStyle = workbook.createCellStyle();
        this.headerLeftStyle.setFont(this.headerFont);
        this.headerRightStyle.setFont(this.headerFont);
        this.headerDecimalStyle.setFont(this.headerFont);
        this.headerIntegerStyle.setFont(this.headerFont);
        this.headerIntegerWithoutSeperatorStyle.setFont(this.headerFont);
        this.headerDateStyle.setFont(this.headerFont);
        this.headerDefaultStyle.setFont(this.headerFont);
        this.headerTimeStyle.setFont(this.headerFont);
        this.headerDateTimeStyle.setFont(this.headerFont);
        this.headerRightStyle.setAlignment(HorizontalAlignment.RIGHT);
        this.headerLeftStyle.setAlignment(HorizontalAlignment.LEFT);
        this.headerDefaultStyle.setAlignment(HorizontalAlignment.LEFT);
        this.headerDateStyle.setDataFormat(workbook.createDataFormat().getFormat("dd.MM.yy"));
        this.headerDateTimeStyle.setDataFormat(workbook.createDataFormat().getFormat("dd.MM.yy - HH:mm"));
        this.headerTimeStyle.setDataFormat(workbook.createDataFormat().getFormat("HH:mm"));
        this.headerDecimalStyle.setDataFormat(workbook.createDataFormat().getFormat("#,##0.0#"));
        this.headerIntegerStyle.setDataFormat(workbook.createDataFormat().getFormat("#,##0"));
        this.headerIntegerWithoutSeperatorStyle.setDataFormat(workbook.createDataFormat().getFormat("0"));
        this.leftStyle = workbook.createCellStyle();
        this.rightStyle = workbook.createCellStyle();
        this.integerStyle = workbook.createCellStyle();
        this.integerWithoutSeperatorStyle = workbook.createCellStyle();
        this.decimalStyle = workbook.createCellStyle();
        this.defaultStyle = workbook.createCellStyle();
        this.dateStyle = workbook.createCellStyle();
        this.dateTimeStyle = workbook.createCellStyle();
        this.timeStyle = workbook.createCellStyle();
        this.cateringPointDurationStyle = workbook.createCellStyle();
        this.rightStyle.setAlignment(HorizontalAlignment.RIGHT);
        this.leftStyle.setAlignment(HorizontalAlignment.LEFT);
        this.dateStyle.setDataFormat(workbook.createDataFormat().getFormat("dd.MM.yy"));
        this.dateTimeStyle.setDataFormat(workbook.createDataFormat().getFormat("dd.MM.yy - HH:mm"));
        this.timeStyle.setDataFormat(workbook.createDataFormat().getFormat("HH:mm"));
        this.cateringPointDurationStyle.setDataFormat(workbook.createDataFormat().getFormat("hh:mm:ss"));
        this.decimalStyle.setDataFormat(workbook.createDataFormat().getFormat("#,##0.0#"));
        this.integerStyle.setDataFormat(workbook.createDataFormat().getFormat("#,##0"));
        this.integerWithoutSeperatorStyle.setDataFormat(workbook.createDataFormat().getFormat("0"));
        this.rightStyle.setFont(this.defaultFont);
        this.leftStyle.setFont(this.defaultFont);
        this.decimalStyle.setFont(this.defaultFont);
        this.defaultStyle.setFont(this.defaultFont);
        this.dateStyle.setFont(this.defaultFont);
        this.integerStyle.setFont(this.defaultFont);
        this.integerWithoutSeperatorStyle.setFont(this.defaultFont);
        this.dateTimeStyle.setFont(this.defaultFont);
        this.timeStyle.setFont(this.defaultFont);
        this.cateringPointDurationStyle.setFont(this.defaultFont);
    }

    private void setBorder(CellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBottomBorderColor((short)0);
        cellStyle.setTopBorderColor((short)0);
        cellStyle.setRightBorderColor((short)0);
        cellStyle.setLeftBorderColor((short)0);
    }

    public void setBordered() {
        this.setBorder(this.headerLeftStyle);
        this.setBorder(this.headerRightStyle);
        this.setBorder(this.headerDecimalStyle);
        this.setBorder(this.headerIntegerStyle);
        this.setBorder(this.headerIntegerWithoutSeperatorStyle);
        this.setBorder(this.headerDateStyle);
        this.setBorder(this.headerDateTimeStyle);
        this.setBorder(this.headerTimeStyle);
        this.setBorder(this.headerDefaultStyle);
        this.setBorder(this.leftStyle);
        this.setBorder(this.rightStyle);
        this.setBorder(this.integerStyle);
        this.setBorder(this.integerWithoutSeperatorStyle);
        this.setBorder(this.decimalStyle);
        this.setBorder(this.defaultStyle);
        this.setBorder(this.dateStyle);
        this.setBorder(this.dateTimeStyle);
        this.setBorder(this.timeStyle);
        this.setBorder(this.cateringPointDurationStyle);
    }

    public void setColumnStyle(Integer column, CellStyle style) {
        this.columnStylesMap.put(column, style);
    }

    public CellStyle getColumnStyle(Integer column) {
        return this.columnStylesMap.get(column);
    }

    public CellStyle getCateringPointDurationStyle() {
        return this.cateringPointDurationStyle;
    }

    public void setCateringPointDurationStyle(CellStyle cateringPointDurationStyle) {
        this.cateringPointDurationStyle = cateringPointDurationStyle;
    }

    public CellStyle getHeaderDateTimeStyle() {
        return this.headerDateTimeStyle;
    }

    public void setHeaderDateTimeStyle(CellStyle headerDateTimeStyle) {
        this.headerDateTimeStyle = headerDateTimeStyle;
    }

    public CellStyle getHeaderTimeStyle() {
        return this.headerTimeStyle;
    }

    public void setHeaderTimeStyle(CellStyle headerTimeStyle) {
        this.headerTimeStyle = headerTimeStyle;
    }

    public CellStyle getDateTimeStyle() {
        return this.dateTimeStyle;
    }

    public void setDateTimeStyle(CellStyle dateTimeStyle) {
        this.dateTimeStyle = dateTimeStyle;
    }

    public CellStyle getTimeStyle() {
        return this.timeStyle;
    }

    public void setTimeStyle(CellStyle timeStyle) {
        this.timeStyle = timeStyle;
    }

    public CellStyle getHeaderIntegerWithoutSeperatorStyle() {
        return this.headerIntegerWithoutSeperatorStyle;
    }

    public void setHeaderIntegerWithoutSeperatorStyle(CellStyle headerIntegerWithoutSeperatorStyle) {
        this.headerIntegerWithoutSeperatorStyle = headerIntegerWithoutSeperatorStyle;
    }

    public CellStyle getIntegerWithoutSeperatorStyle() {
        return this.integerWithoutSeperatorStyle;
    }

    public void setIntegerWithoutSeperatorStyle(CellStyle integerWithoutSeperatorStyle) {
        this.integerWithoutSeperatorStyle = integerWithoutSeperatorStyle;
    }

    public boolean isUseIntegerStyleWithoutSeperator() {
        return this.useIntegerStyleWithoutSeperator;
    }

    public void setUseIntegerStyleWithoutSeperator(boolean useIntegerStyleWithoutSeperator) {
        this.useIntegerStyleWithoutSeperator = useIntegerStyleWithoutSeperator;
    }

    public CellStyle getHeaderDefaultStyle() {
        return this.headerDefaultStyle;
    }

    public void setHeaderDefaultStyle(CellStyle headerDefaultStyle) {
        this.headerDefaultStyle = headerDefaultStyle;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public void setHeaderFont(Font headerFont) {
        this.headerFont = headerFont;
    }

    public CellStyle getHeaderLeftStyle() {
        return this.headerLeftStyle;
    }

    public void setHeaderLeftStyle(CellStyle headerLeftStyle) {
        this.headerLeftStyle = headerLeftStyle;
    }

    public CellStyle getHeaderRightStyle() {
        return this.headerRightStyle;
    }

    public void setHeaderRightStyle(CellStyle headerRightStyle) {
        this.headerRightStyle = headerRightStyle;
    }

    public CellStyle getHeaderDecimalStyle() {
        return this.headerDecimalStyle;
    }

    public void setHeaderDecimalStyle(CellStyle headerDecimalStyle) {
        this.headerDecimalStyle = headerDecimalStyle;
    }

    public CellStyle getHeaderIntegerStyle() {
        return this.headerIntegerStyle;
    }

    public void setHeaderIntegerStyle(CellStyle headerIntegerStyle) {
        this.headerIntegerStyle = headerIntegerStyle;
    }

    public CellStyle getHeaderDateStyle() {
        return this.headerDateStyle;
    }

    public void setHeaderDateStyle(CellStyle headerDateStyle) {
        this.headerDateStyle = headerDateStyle;
    }

    public CellStyle getLeftStyle() {
        return this.leftStyle;
    }

    public void setLeftStyle(CellStyle leftStyle) {
        this.leftStyle = leftStyle;
    }

    public CellStyle getRightStyle() {
        return this.rightStyle;
    }

    public void setRightStyle(CellStyle rightStyle) {
        this.rightStyle = rightStyle;
    }

    public CellStyle getIntegerStyle() {
        return this.integerStyle;
    }

    public void setIntegerStyle(CellStyle integerStyle) {
        this.integerStyle = integerStyle;
    }

    public CellStyle getDecimalStyle() {
        return this.decimalStyle;
    }

    public void setDecimalStyle(CellStyle decimalStyle) {
        this.decimalStyle = decimalStyle;
    }

    public CellStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(CellStyle defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public CellStyle getDateStyle() {
        return this.dateStyle;
    }

    public void setDateStyle(CellStyle dateStyle) {
        this.dateStyle = dateStyle;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public CellStyle createCellStyle() {
        if (this.workbook == null) {
            return null;
        }
        return this.workbook.createCellStyle();
    }

    public double getDefaultImageWidth() {
        return this.defaultImageWidth;
    }

    public void setDefaultImageWidth(double defaultImageWidth) {
        this.defaultImageWidth = defaultImageWidth;
    }
}

