/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FtpClientConfiguration.class);
    private String user;
    private String password;
    private String url;
    private int port;
    private String folder;
    private int identifier;
    private boolean useKeyAuth;
    private String localPrivateKeyPath;
    private boolean moveParsedFiles = false;
    private String reportsType;
    private List<String> mailAddress = new ArrayList<String>();
    private Integer retry;
    private Long timeWait;
    private Integer maxRetry;

    public FtpClientConfiguration() {
        this.retry = 0;
        this.maxRetry = 0;
        this.timeWait = 0L;
        this.mailAddress = new ArrayList<String>();
    }

    public FtpClientConfiguration(int identifier) {
        this.retry = 0;
        this.maxRetry = 0;
        this.timeWait = 0L;
        this.identifier = identifier;
    }

    public FtpClientConfiguration(String user, String password, String url, String folder, int identifier, Integer maxRetry, Long timeToWait, boolean useKeyAuth, String ppkPath) {
        this.retry = 0;
        this.maxRetry = maxRetry;
        this.timeWait = timeToWait;
        this.folder = folder;
        this.identifier = identifier;
        int i = url.lastIndexOf(":");
        boolean init = false;
        if (i != -1) {
            String t = url.substring(i + 1);
            String u = url.substring(0, i);
            try {
                Integer p = Integer.valueOf(t);
                this.init(user, password, u, p, useKeyAuth, ppkPath);
                init = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!init) {
            this.init(user, password, url, 22, useKeyAuth, ppkPath);
        }
    }

    public FtpClientConfiguration(String user, String password, String url, Integer port, String folder, boolean moveParsedFiles, Integer maxRetry, Long timeWait, boolean useKeyAuth, String ppkPath) {
        this.retry = 0;
        this.maxRetry = maxRetry;
        this.timeWait = timeWait;
        this.folder = folder;
        this.moveParsedFiles = moveParsedFiles;
        this.reportsType = "empty";
        int i = url.lastIndexOf(":");
        boolean init = false;
        if (i != -1) {
            String t = url.substring(i + 1);
            String u = url.substring(0, i);
            try {
                Integer p = Integer.valueOf(t);
                this.init(user, password, u, p, useKeyAuth, ppkPath);
                init = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!init) {
            if (port == null) {
                this.init(user, password, url, 22, useKeyAuth, ppkPath);
            } else {
                this.init(user, password, url, port, useKeyAuth, ppkPath);
            }
        }
    }

    public FtpClientConfiguration(String user, String password, List<String> mailAddress, String url, Integer port, String folder, boolean moveParsedFiles, String reportsType, Integer maxRetry, Long timeWait, boolean useKeyAuth, String ppkPath) {
        this.retry = 0;
        this.maxRetry = maxRetry;
        this.timeWait = timeWait;
        this.mailAddress = mailAddress;
        this.folder = folder;
        this.moveParsedFiles = moveParsedFiles;
        this.reportsType = reportsType;
        int i = url.lastIndexOf(":");
        boolean init = false;
        if (i != -1) {
            String t = url.substring(i + 1);
            String u = url.substring(0, i);
            try {
                Integer p = Integer.valueOf(t);
                this.init(user, password, u, p, useKeyAuth, ppkPath);
                init = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!init) {
            if (port == null) {
                this.init(user, password, url, 22, useKeyAuth, ppkPath);
            } else {
                this.init(user, password, url, port, useKeyAuth, ppkPath);
            }
        }
    }

    public FtpClientConfiguration(String user, String password, String url, String folder, Integer maxRetry, Long timeWait, boolean useKeyAuth, String ppkPath) {
        this.retry = 0;
        this.maxRetry = maxRetry;
        this.timeWait = timeWait;
        this.folder = folder;
        int i = url.lastIndexOf(":");
        boolean init = false;
        if (i != -1) {
            String t = url.substring(i + 1);
            String u = url.substring(0, i);
            try {
                Integer p = Integer.valueOf(t);
                this.init(user, password, u, p, useKeyAuth, ppkPath);
                init = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!init) {
            this.init(user, password, url, 22, useKeyAuth, ppkPath);
        }
    }

    public FtpClientConfiguration(String user, String password, String url, int port, boolean useKeyAuth, String ppkPath) {
        this.init(user, password, url, port, useKeyAuth, ppkPath);
    }

    private void init(String user2, String password2, String url2, int port2, boolean useKeyAuth, String ppkPath) {
        this.useKeyAuth = useKeyAuth;
        this.setUser(user2);
        this.setPassword(password2);
        this.setUrl(url2);
        this.setPort(port2);
        this.localPrivateKeyPath = ppkPath;
    }

    public String getLocalPrivateKeyPath() {
        return this.localPrivateKeyPath;
    }

    public void setLocalPrivateKeyPath(String localPrivateKeyPath) {
        this.localPrivateKeyPath = localPrivateKeyPath;
    }

    public boolean isMoveParsedFiles() {
        return this.moveParsedFiles;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    public boolean getMoveParsedFiles() {
        return this.moveParsedFiles;
    }

    public void setMoveParsedFiles(boolean moveParsedFiles) {
        this.moveParsedFiles = moveParsedFiles;
    }

    public String getReportsType() {
        return this.reportsType;
    }

    public void setReportsType(String reportsType) {
        this.reportsType = reportsType;
    }

    public List<String> getMailAddress() {
        return this.mailAddress;
    }

    public void setMailAddress(List<String> mailAddress) {
        this.mailAddress = mailAddress;
    }

    public Integer getRetry() {
        return this.retry;
    }

    public void setRetry(Integer retry) {
        this.retry = retry;
    }

    public Long getTimeWait() {
        return this.timeWait;
    }

    public void setTimeWait(Long timeWait) {
        this.timeWait = timeWait;
    }

    public Integer getMaxRetry() {
        return this.maxRetry;
    }

    public void setMaxRetry(Integer maxRetry) {
        this.maxRetry = maxRetry;
    }

    public boolean isUseKeyAuth() {
        return this.useKeyAuth;
    }

    public void setUseKeyAuth(boolean useKeyAuth) {
        this.useKeyAuth = useKeyAuth;
    }
}

