/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils.ftp;

import ch.icit.utils.Triple;
import ch.icit.utils.Tuple;
import java.io.File;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPFile;

public interface FtpFileSelector {
    public static final String DATE_FORMAT = "yyyyMMdd_HHmmss";

    public Map<FTPFile, Triple<Timestamp, String, Date>> selectFiles(List<FTPFile> var1);

    public Map<FTPFile, Tuple<Timestamp, String>> selectFilesForDelete(List<FTPFile> var1);

    public Tuple<String, String> getFileLocalName(String var1, Timestamp var2, String var3);

    public List<String> getPatternList();

    public String getValidFileType(String var1);

    public static Map<File, String> generateRemoteFileName(List<File> files) {
        HashMap<File, String> fileList = new HashMap<File, String>();
        for (File file : files) {
            String newName = file.getName();
            int i = newName.lastIndexOf("_");
            String remoteFilename = newName.substring(0, i);
            String extension = null;
            int index = file.getName().lastIndexOf(".");
            if (index != -1) {
                extension = file.getName().substring(index, file.getName().length());
            }
            if (extension != null) {
                remoteFilename = remoteFilename + extension;
            }
            fileList.put(file, remoteFilename);
        }
        return fileList;
    }

    public static Map<File, String> generateRemoteFileNameDirectly(List<File> files) {
        HashMap<File, String> fileList = new HashMap<File, String>();
        for (File file : files) {
            String newName = file.getName();
            fileList.put(file, newName);
        }
        return fileList;
    }

    public static List<String> checkFilename(List<String> incorrectFilenames, String orgName, List<String> patternList) {
        if (incorrectFilenames == null) {
            incorrectFilenames = new ArrayList<String>();
        }
        if (!orgName.equals(".") && !orgName.equals("..")) {
            boolean isCorrect = false;
            if (patternList != null && patternList.size() > 0) {
                for (String pattern : patternList) {
                    boolean flag = Pattern.matches(pattern, orgName);
                    if (!flag) continue;
                    isCorrect = true;
                    break;
                }
                if (!isCorrect) {
                    System.out.println("Filename incorrect:" + orgName);
                    incorrectFilenames.add(orgName);
                }
            }
        }
        return incorrectFilenames;
    }
}

